package io.prestosql.jdbc.$internal.jackson.datatype.guava.deser;

import java.io.IOException;

import io.prestosql.jdbc.$internal.jackson.databind.DeserializationContext;
import io.prestosql.jdbc.$internal.jackson.databind.JavaType;
import io.prestosql.jdbc.$internal.jackson.databind.JsonDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.deser.NullValueProvider;
import io.prestosql.jdbc.$internal.jackson.databind.jsontype.TypeDeserializer;

import io.prestosql.jdbc.$internal.guava.collect.ImmutableCollection.Builder;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableSortedSet;

public class ImmutableSortedSetDeserializer
    extends GuavaImmutableCollectionDeserializer<ImmutableSortedSet<Object>>
{
    private static final long serialVersionUID = 1L;

    public ImmutableSortedSetDeserializer(JavaType selfType,
            JsonDeserializer<?> deser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    public ImmutableSortedSetDeserializer withResolved(JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        return new ImmutableSortedSetDeserializer(_containerType,
                valueDeser, typeDeser, nuller, unwrapSingle);
    }

    @SuppressWarnings("unchecked")
    @Override
    protected Builder<Object> createBuilder() {
        /* Not quite sure what to do with sorting/ordering; may require better support either
         * via annotations, or via custom serialization (bean style that includes ordering
         * aspects)
         */
        @SuppressWarnings("rawtypes")
        ImmutableSortedSet.Builder<?> builderComp = ImmutableSortedSet.<Comparable> naturalOrder();
        ImmutableSortedSet.Builder<Object> builder = (ImmutableSortedSet.Builder<Object>) builderComp;
        return builder;
    }

    @Override
    protected ImmutableSortedSet<Object> _createEmpty(DeserializationContext ctxt) throws IOException {
        return ImmutableSortedSet.of();
    }

    @Override
    protected ImmutableSortedSet<Object> _createWithSingleElement(DeserializationContext ctxt, Object value) throws IOException {
        return (ImmutableSortedSet<Object>) createBuilder()
                .add(value)
                .build();
    }
}
