package io.prestosql.jdbc.$internal.jackson.datatype.joda.deser.key;

import java.io.IOException;
import java.util.TimeZone;

import io.prestosql.jdbc.$internal.joda.time.DateTime;
import io.prestosql.jdbc.$internal.joda.time.DateTimeZone;

import io.prestosql.jdbc.$internal.jackson.databind.DeserializationContext;
import io.prestosql.jdbc.$internal.jackson.databind.DeserializationFeature;

public class DateTimeKeyDeserializer extends JodaKeyDeserializer {
    private static final long serialVersionUID = 1L;

    @Override
    protected DateTime deserialize(String key, DeserializationContext ctxt) throws IOException {
        if (ctxt.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE)) {
            TimeZone tz = ctxt.getTimeZone();
            DateTimeZone dtz = (tz == null) ? DateTimeZone.UTC : DateTimeZone.forTimeZone(tz);
            return new DateTime(key, dtz);
        }
        return DateTime.parse(key);
    }

}
