package io.prestosql.jdbc.$internal.jackson.datatype.guava.deser;

import io.prestosql.jdbc.$internal.jackson.databind.JavaType;
import io.prestosql.jdbc.$internal.jackson.databind.JsonDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.KeyDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.deser.NullValueProvider;
import io.prestosql.jdbc.$internal.jackson.databind.jsontype.TypeDeserializer;

import io.prestosql.jdbc.$internal.guava.collect.ImmutableMap.Builder;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableSortedMap;

public class ImmutableSortedMapDeserializer
    extends GuavaImmutableMapDeserializer<ImmutableSortedMap<Object, Object>>
{
    private static final long serialVersionUID = 2L;

    public ImmutableSortedMapDeserializer(JavaType type, KeyDeserializer keyDeser,
            JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller) {
        super(type, keyDeser, valueDeser, typeDeser, nuller);
    }

    @SuppressWarnings("unchecked")
    @Override
    protected Builder<Object, Object> createBuilder() {
        // Not quite sure what to do with sorting/ordering; may require better
        // support either via annotations, or via custom serialization (bean
        // style that includes ordering aspects)
        @SuppressWarnings("rawtypes")
        ImmutableSortedMap.Builder<?, Object> naturalOrder = ImmutableSortedMap.<Comparable, Object>naturalOrder();
        ImmutableSortedMap.Builder<Object, Object> builder = (ImmutableSortedMap.Builder<Object, Object>) naturalOrder;
        return builder;
    }

    @Override
    public GuavaMapDeserializer<ImmutableSortedMap<Object, Object>> withResolved(KeyDeserializer keyDeser,
            JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller)
    {
        return new ImmutableSortedMapDeserializer(_containerType, keyDeser, valueDeser, typeDeser, nuller);
    }
}
