package io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.multimap.list;

import io.prestosql.jdbc.$internal.jackson.databind.JsonDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.KeyDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.deser.NullValueProvider;
import io.prestosql.jdbc.$internal.jackson.databind.jsontype.TypeDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.type.MapLikeType;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.multimap.GuavaMultimapDeserializer;
import io.prestosql.jdbc.$internal.guava.collect.ArrayListMultimap;

import java.lang.reflect.Method;

/**
 * Provides deserialization for the Guava ArrayListMultimap class.
 *
 * @author mvolkhart
 */
public class ArrayListMultimapDeserializer
    extends GuavaMultimapDeserializer<ArrayListMultimap<Object,Object>>
{
    private static final long serialVersionUID = 1L;

    public ArrayListMultimapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer,
            TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        super(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
    }

    public ArrayListMultimapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer,
            TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer,
            Method creatorMethod, NullValueProvider nvp) {
        super(type, keyDeserializer, elementTypeDeserializer, elementDeserializer, creatorMethod, nvp);
    }

    @Override
    protected ArrayListMultimap<Object, Object> createMultimap() {
        return ArrayListMultimap.create();
    }

    @Override
    protected JsonDeserializer<?> _createContextual(MapLikeType type,
            KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer,
            JsonDeserializer<?> elementDeserializer, Method method,
            NullValueProvider nvp) {
        return new ArrayListMultimapDeserializer(type, keyDeserializer, typeDeserializer,
                elementDeserializer, method, nvp);
    }
}
