package io.prestosql.jdbc.$internal.jackson.datatype.guava.ser;

import io.prestosql.jdbc.$internal.jackson.core.JsonGenerator;
import io.prestosql.jdbc.$internal.jackson.databind.PropertyName;
import io.prestosql.jdbc.$internal.jackson.databind.SerializerProvider;
import io.prestosql.jdbc.$internal.jackson.databind.ser.BeanPropertyWriter;
import io.prestosql.jdbc.$internal.jackson.databind.util.NameTransformer;
import io.prestosql.jdbc.$internal.guava.base.Optional;

public class GuavaOptionalBeanPropertyWriter extends BeanPropertyWriter
{
    private static final long serialVersionUID = 1;

    protected GuavaOptionalBeanPropertyWriter(BeanPropertyWriter base) {
        super(base);
    }

    protected GuavaOptionalBeanPropertyWriter(BeanPropertyWriter base, PropertyName newName) {
        super(base, newName);
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new GuavaOptionalBeanPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter unwrappingWriter(NameTransformer unwrapper) {
        return new GuavaUnwrappingOptionalBeanPropertyWriter(this, unwrapper);
    }

    @Override
    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception
    {
        if (_nullSerializer == null) {
            Object value = get(bean);
            if (value == null || Optional.absent().equals(value)) {
                return;
            }
        }
        super.serializeAsField(bean, gen, prov);
    }
}
