package io.prestosql.jdbc.$internal.jackson.datatype.joda.deser.key;

import java.io.IOException;

import io.prestosql.jdbc.$internal.jackson.databind.DeserializationContext;
import io.prestosql.jdbc.$internal.joda.time.LocalDate;
import io.prestosql.jdbc.$internal.joda.time.format.DateTimeFormatter;
import io.prestosql.jdbc.$internal.joda.time.format.ISODateTimeFormat;

public class LocalDateKeyDeserializer extends JodaKeyDeserializer {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter parser = ISODateTimeFormat.localDateParser();

    @Override
    protected LocalDate deserialize(String key, DeserializationContext ctxt) throws IOException {
        return parser.parseLocalDate(key);
    }
}