/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import io.airlift.concurrent.Threads;
import io.prestosql.client.Warning;
import io.prestosql.execution.warnings.WarningCollectorConfig;
import io.prestosql.jdbc.PrestoSqlWarning;
import io.prestosql.plugin.blackhole.BlackHolePlugin;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.PrestoWarning;
import io.prestosql.spi.WarningCode;
import io.prestosql.testing.TestingWarningCollector;
import io.prestosql.testing.TestingWarningCollectorConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestJdbcWarnings {
    private static final int PRELOADED_WARNINGS = 5;
    private TestingPrestoServer server;
    private Connection connection;
    private Statement statement;
    private ExecutorService executor;

    @BeforeClass
    public void setupServer() throws Exception {
        this.server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"testing-warning-collector.add-warnings", (Object)"true").put((Object)"testing-warning-collector.preloaded-warnings", (Object)String.valueOf(5)).build()).build();
        this.server.installPlugin((Plugin)new BlackHolePlugin());
        this.server.createCatalog("blackhole", "blackhole");
        this.server.waitForNodeRefresh(Duration.ofSeconds(10L));
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            statement.execute("CREATE SCHEMA blackhole.blackhole");
            statement.executeUpdate("CREATE TABLE slow_table (x int) WITH (   split_count = 1,    pages_per_split = 5,    rows_per_page = 3,    page_processing_delay = '1s')");
        }
    }

    @AfterClass(alwaysRun=true)
    public void tearDownServer() throws Exception {
        this.server.close();
    }

    @BeforeMethod
    public void setup() throws Exception {
        this.connection = this.createConnection();
        this.statement = this.connection.createStatement();
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        this.executor.shutdownNow();
        this.statement.close();
        this.connection.close();
    }

    @Test
    public void testStatementWarnings() throws SQLException {
        Assert.assertFalse((boolean)this.statement.execute("CREATE SCHEMA blackhole.test_schema"));
        SQLWarning warning = this.statement.getWarnings();
        Assert.assertNotNull((Object)warning);
        TestingWarningCollectorConfig warningCollectorConfig = new TestingWarningCollectorConfig().setPreloadedWarnings(5);
        TestingWarningCollector warningCollector = new TestingWarningCollector(new WarningCollectorConfig(), warningCollectorConfig);
        List expectedWarnings = warningCollector.getWarnings();
        TestJdbcWarnings.assertStartsWithExpectedWarnings(warning, TestJdbcWarnings.fromPrestoWarnings(expectedWarnings));
        this.statement.clearWarnings();
        Assert.assertNull((Object)this.statement.getWarnings());
    }

    @Test
    public void testLongRunningStatement() throws Exception {
        Future<Object> future = this.executor.submit(() -> {
            this.statement.execute("CREATE TABLE test_long_running AS SELECT * FROM slow_table");
            return null;
        });
        TestJdbcWarnings.assertStatementWarnings(this.statement, future);
        this.statement.execute("DROP TABLE test_long_running");
    }

    @Test
    public void testLongRunningQuery() throws Exception {
        Future<Object> future = this.executor.submit(() -> {
            ResultSet resultSet = this.statement.executeQuery("SELECT * FROM slow_table");
            while (resultSet.next()) {
            }
            return null;
        });
        TestJdbcWarnings.assertStatementWarnings(this.statement, future);
    }

    @Test
    public void testExecuteQueryWarnings() throws SQLException {
        try (ResultSet rs = this.statement.executeQuery("SELECT a FROM (VALUES 1, 2, 3) t(a)");){
            Assert.assertNull((Object)this.statement.getConnection().getWarnings());
            HashSet<WarningEntry> currentWarnings = new HashSet<WarningEntry>();
            TestJdbcWarnings.assertWarnings(rs.getWarnings(), currentWarnings);
            while (rs.next()) {
                TestJdbcWarnings.assertWarnings(this.statement.getWarnings(), currentWarnings);
            }
            TestingWarningCollectorConfig warningCollectorConfig = new TestingWarningCollectorConfig().setPreloadedWarnings(5).setAddWarnings(true);
            TestingWarningCollector warningCollector = new TestingWarningCollector(new WarningCollectorConfig(), warningCollectorConfig);
            List expectedWarnings = warningCollector.getWarnings();
            for (PrestoWarning prestoWarning : expectedWarnings) {
                Assert.assertTrue((boolean)currentWarnings.contains(new WarningEntry((Throwable)TestJdbcWarnings.toPrestoSqlWarning(prestoWarning))));
            }
        }
    }

    @Test
    public void testSqlWarning() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 3; ++i) {
            builder.add((Object)new PrestoWarning(new WarningCode(i, "CODE_" + i), "warning message " + i));
        }
        ImmutableList warnings = builder.build();
        SQLWarning warning = TestJdbcWarnings.fromPrestoWarnings((List<PrestoWarning>)warnings);
        Assert.assertEquals((int)Iterators.size(warning.iterator()), (int)warnings.size());
        TestJdbcWarnings.assertWarningsEqual(warning, (SQLWarning)TestJdbcWarnings.toPrestoSqlWarning((PrestoWarning)warnings.get(0)));
        TestJdbcWarnings.assertWarningsEqual(warning.getNextWarning(), (SQLWarning)TestJdbcWarnings.toPrestoSqlWarning((PrestoWarning)warnings.get(1)));
        TestJdbcWarnings.assertWarningsEqual(warning.getNextWarning().getNextWarning(), (SQLWarning)TestJdbcWarnings.toPrestoSqlWarning((PrestoWarning)warnings.get(2)));
    }

    private static void assertStatementWarnings(Statement statement, Future<?> future) throws Exception {
        while (!future.isDone() && statement.getWarnings() == null) {
            Thread.sleep(100L);
        }
        HashSet<WarningEntry> warnings = new HashSet<WarningEntry>();
        SQLWarning warning = statement.getWarnings();
        Assert.assertTrue((boolean)warnings.add(new WarningEntry(warning)));
        while (warning.getNextWarning() != null) {
            warning = warning.getNextWarning();
            Assert.assertTrue((boolean)warnings.add(new WarningEntry(warning)));
        }
        int initialSize = warnings.size();
        Assertions.assertThat((int)initialSize).isGreaterThanOrEqualTo(6);
        while (!future.isDone()) {
            if (warning.getNextWarning() == null) {
                Thread.sleep(100L);
                continue;
            }
            warning = warning.getNextWarning();
            Assert.assertTrue((boolean)warnings.add(new WarningEntry(warning)));
        }
        int finalSize = warnings.size();
        Assertions.assertThat((int)finalSize).isGreaterThan(initialSize);
        future.get();
    }

    private static SQLWarning fromPrestoWarnings(List<PrestoWarning> warnings) {
        PrestoSqlWarning first;
        Objects.requireNonNull(warnings, "warnings is null");
        Assert.assertFalse((boolean)warnings.isEmpty());
        Iterator<PrestoWarning> iterator = warnings.iterator();
        Object current = first = TestJdbcWarnings.toPrestoSqlWarning(iterator.next());
        while (iterator.hasNext()) {
            current.setNextWarning((SQLWarning)TestJdbcWarnings.toPrestoSqlWarning(iterator.next()));
            current = current.getNextWarning();
        }
        return first;
    }

    private static PrestoSqlWarning toPrestoSqlWarning(PrestoWarning warning) {
        return new PrestoSqlWarning(TestJdbcWarnings.toClientWarning(warning));
    }

    private static Warning toClientWarning(PrestoWarning warning) {
        WarningCode code = warning.getWarningCode();
        return new Warning(new Warning.Code(code.getCode(), code.getName()), warning.getMessage());
    }

    private static void assertWarningsEqual(SQLWarning actual, SQLWarning expected) {
        Assert.assertEquals((String)actual.getMessage(), (String)expected.getMessage());
        Assert.assertEquals((String)actual.getSQLState(), (String)expected.getSQLState());
        Assert.assertEquals((int)actual.getErrorCode(), (int)expected.getErrorCode());
    }

    private static void addWarnings(Set<WarningEntry> currentWarnings, SQLWarning newWarning) {
        if (newWarning == null) {
            return;
        }
        for (Throwable warning : newWarning) {
            WarningEntry entry = new WarningEntry(warning);
            currentWarnings.add(entry);
        }
    }

    private Connection createConnection() throws SQLException {
        String url = String.format("jdbc:presto://%s/blackhole/blackhole", this.server.getAddress());
        return DriverManager.getConnection(url, "test", null);
    }

    private static void assertWarnings(SQLWarning warning, Set<WarningEntry> currentWarnings) {
        if (warning == null) {
            return;
        }
        int previousSize = currentWarnings.size();
        TestJdbcWarnings.addWarnings(currentWarnings, warning);
        Assert.assertTrue((currentWarnings.size() >= previousSize ? 1 : 0) != 0);
    }

    private static void assertStartsWithExpectedWarnings(SQLWarning warning, SQLWarning expected) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)warning);
        while (true) {
            TestJdbcWarnings.assertWarningsEqual(warning, expected);
            warning = warning.getNextWarning();
            expected = expected.getNextWarning();
            if (expected == null) {
                return;
            }
            Assert.assertNotNull((Object)warning);
        }
    }

    private static class WarningEntry {
        public final int vendorCode;
        public final String sqlState;
        public final String message;

        public WarningEntry(Throwable throwable) {
            Objects.requireNonNull(throwable, "throwable is null");
            Assert.assertTrue((boolean)(throwable instanceof SQLWarning));
            SQLWarning warning = (SQLWarning)throwable;
            this.vendorCode = warning.getErrorCode();
            this.sqlState = Objects.requireNonNull(warning.getSQLState(), "SQLState is null");
            this.message = Objects.requireNonNull(warning.getMessage(), "message is null");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WarningEntry)) {
                return false;
            }
            WarningEntry that = (WarningEntry)other;
            return this.vendorCode == that.vendorCode && this.sqlState.equals(that.sqlState) && this.message.equals(that.message);
        }

        public int hashCode() {
            return Objects.hash(this.vendorCode, this.sqlState, this.message);
        }
    }
}

