/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.log.Logging;
import io.prestosql.jdbc.TestingJdbcUtils;
import io.prestosql.plugin.blackhole.BlackHolePlugin;
import io.prestosql.plugin.hive.HiveHadoop2Plugin;
import io.prestosql.plugin.tpch.TpchMetadata;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.CountingMockConnector;
import io.prestosql.type.ColorType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestPrestoDatabaseMetaData {
    private static final String TEST_CATALOG = "test_catalog";
    private static final String COUNTING_CATALOG = "mock_catalog";
    private CountingMockConnector countingMockConnector;
    private TestingPrestoServer server;
    private Connection connection;

    @BeforeClass
    public void setupServer() throws Exception {
        Statement statement;
        Logging.initialize();
        this.server = TestingPrestoServer.create();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog(TEST_CATALOG, "tpch");
        this.server.installPlugin((Plugin)new BlackHolePlugin());
        this.server.createCatalog("blackhole", "blackhole");
        this.server.installPlugin((Plugin)new HiveHadoop2Plugin());
        this.server.createCatalog("hive", "hive-hadoop2", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)this.server.getBaseDataDir().resolve("hive").toAbsolutePath().toString()).put((Object)"hive.security", (Object)"sql-standard").build());
        this.countingMockConnector = new CountingMockConnector();
        this.server.installPlugin(this.countingMockConnector.getPlugin());
        this.server.createCatalog(COUNTING_CATALOG, "mock", (Map)ImmutableMap.of());
        this.server.waitForNodeRefresh(Duration.ofSeconds(10L));
        try (Connection connection = this.createConnection();){
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE SCHEMA blackhole.blackhole");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        connection = this.createConnection();
        try {
            connection.setCatalog("hive");
            statement = connection.createStatement();
            try {
                statement.execute("SET ROLE admin");
                statement.execute("CREATE SCHEMA default");
                statement.execute("CREATE TABLE default.test_table (a varchar)");
                statement.execute("CREATE VIEW default.test_view AS SELECT * FROM hive.default.test_table");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @AfterClass(alwaysRun=true)
    public void tearDownServer() throws Exception {
        this.server.close();
        this.server = null;
        this.countingMockConnector = null;
    }

    @BeforeMethod
    public void setup() throws Exception {
        this.connection = this.createConnection();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.connection.close();
    }

    @Test
    public void testGetClientInfoProperties() throws Exception {
        DatabaseMetaData metaData = this.connection.getMetaData();
        try (ResultSet resultSet = metaData.getClientInfoProperties();){
            TestingJdbcUtils.assertResultSet(resultSet).hasColumnCount(4).hasColumn(1, "NAME", 12).hasColumn(2, "MAX_LEN", 4).hasColumn(3, "DEFAULT_VALUE", 12).hasColumn(4, "DESCRIPTION", 12).hasRows(TestingJdbcUtils.list(TestingJdbcUtils.list("ApplicationName", Integer.MAX_VALUE, null, null), TestingJdbcUtils.list("ClientInfo", Integer.MAX_VALUE, null, null), TestingJdbcUtils.list("ClientTags", Integer.MAX_VALUE, null, null), TestingJdbcUtils.list("TraceToken", Integer.MAX_VALUE, null, null)));
        }
    }

    @Test
    public void testPassEscapeInMetaDataQuery() throws Exception {
        DatabaseMetaData metaData = this.connection.getMetaData();
        Set<String> queries = this.captureQueries(() -> {
            String schemaPattern = "defau" + metaData.getSearchStringEscape() + "_t";
            try (ResultSet resultSet = metaData.getColumns("blackhole", schemaPattern, null, null);){
                Assert.assertFalse((boolean)resultSet.next(), (String)"There should be no results");
            }
            return null;
        });
        Assert.assertEquals((int)queries.size(), (int)1, (String)("Expected exactly one query, got " + queries.size()));
        String query = (String)Iterables.getOnlyElement(queries);
        io.airlift.testing.Assertions.assertContains((String)query, (String)"_t' ESCAPE '", (String)"Metadata query does not contain ESCAPE");
    }

    @Test
    public void testGetTypeInfo() throws Exception {
        DatabaseMetaData metaData = this.connection.getMetaData();
        ResultSet typeInfo = metaData.getTypeInfo();
        while (typeInfo.next()) {
            int jdbcType = typeInfo.getInt("DATA_TYPE");
            switch (jdbcType) {
                case -5: {
                    TestPrestoDatabaseMetaData.assertColumnSpec(typeInfo, -5, 19L, 10L, "bigint");
                    break;
                }
                case 16: {
                    TestPrestoDatabaseMetaData.assertColumnSpec(typeInfo, 16, null, null, "boolean");
                    break;
                }
                case 4: {
                    TestPrestoDatabaseMetaData.assertColumnSpec(typeInfo, 4, 10L, 10L, "integer");
                    break;
                }
                case 3: {
                    TestPrestoDatabaseMetaData.assertColumnSpec(typeInfo, 3, 38L, 10L, "decimal");
                    break;
                }
                case 12: {
                    TestPrestoDatabaseMetaData.assertColumnSpec(typeInfo, 12, null, null, "varchar");
                    break;
                }
                case 93: {
                    TestPrestoDatabaseMetaData.assertColumnSpec(typeInfo, 93, 23L, null, "timestamp");
                    break;
                }
                case 8: {
                    TestPrestoDatabaseMetaData.assertColumnSpec(typeInfo, 8, 53L, 2L, "double");
                }
            }
        }
    }

    @Test
    public void testGetUrl() throws Exception {
        DatabaseMetaData metaData = this.connection.getMetaData();
        Assert.assertEquals((String)metaData.getURL(), (String)("jdbc:presto://" + this.server.getAddress()));
    }

    @Test
    public void testGetDatabaseProductVersion() throws Exception {
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertEquals((String)metaData.getDatabaseProductName(), (String)"Presto");
            Assert.assertEquals((String)metaData.getDatabaseProductVersion(), (String)"testversion");
            Assert.assertEquals((int)metaData.getDatabaseMajorVersion(), (int)0);
            Assert.assertEquals((int)metaData.getDatabaseMinorVersion(), (int)0);
        }
    }

    @Test
    public void testGetCatalogs() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getCatalogs();){
            Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEqualTo(TestingJdbcUtils.list(TestingJdbcUtils.list("blackhole"), TestingJdbcUtils.list("hive"), TestingJdbcUtils.list(COUNTING_CATALOG), TestingJdbcUtils.list("system"), TestingJdbcUtils.list(TEST_CATALOG)));
            ResultSetMetaData metadata = rs.getMetaData();
            Assert.assertEquals((int)metadata.getColumnCount(), (int)1);
            Assert.assertEquals((String)metadata.getColumnLabel(1), (String)"TABLE_CAT");
            Assert.assertEquals((int)metadata.getColumnType(1), (int)12);
        }
    }

    @Test
    public void testGetSchemas() throws Exception {
        ArrayList<List<String>> hive = new ArrayList<List<String>>();
        hive.add(TestingJdbcUtils.list("hive", "information_schema"));
        hive.add(TestingJdbcUtils.list("hive", "default"));
        ArrayList<List<String>> countingCatalog = new ArrayList<List<String>>();
        countingCatalog.add(TestingJdbcUtils.list(COUNTING_CATALOG, "information_schema"));
        countingCatalog.add(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1"));
        countingCatalog.add(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2"));
        ArrayList<List<String>> system = new ArrayList<List<String>>();
        system.add(TestingJdbcUtils.list("system", "information_schema"));
        system.add(TestingJdbcUtils.list("system", "jdbc"));
        system.add(TestingJdbcUtils.list("system", "metadata"));
        system.add(TestingJdbcUtils.list("system", "runtime"));
        ArrayList<List<String>> blackhole = new ArrayList<List<String>>();
        blackhole.add(TestingJdbcUtils.list("blackhole", "information_schema"));
        blackhole.add(TestingJdbcUtils.list("blackhole", "default"));
        blackhole.add(TestingJdbcUtils.list("blackhole", "blackhole"));
        ArrayList<List<String>> test = new ArrayList<List<String>>();
        test.add(TestingJdbcUtils.list(TEST_CATALOG, "information_schema"));
        for (String schema : TpchMetadata.SCHEMA_NAMES) {
            test.add(TestingJdbcUtils.list(TEST_CATALOG, schema));
        }
        ArrayList<List<String>> all = new ArrayList<List<String>>();
        all.addAll(hive);
        all.addAll(countingCatalog);
        all.addAll(system);
        all.addAll(test);
        all.addAll(blackhole);
        try (Connection connection = this.createConnection();){
            try (ResultSet rs = connection.getMetaData().getSchemas();){
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, all);
            }
            rs = connection.getMetaData().getSchemas(null, null);
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, all);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(TEST_CATALOG, null);
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, test);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas("", null);
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(TEST_CATALOG, "information_schema");
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(TestingJdbcUtils.list(TEST_CATALOG, "information_schema")));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(null, "information_schema");
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(TestingJdbcUtils.list(TEST_CATALOG, "information_schema"), TestingJdbcUtils.list(COUNTING_CATALOG, "information_schema"), TestingJdbcUtils.list("blackhole", "information_schema"), TestingJdbcUtils.list("hive", "information_schema"), TestingJdbcUtils.list("system", "information_schema")));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(null, "sf_");
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(TestingJdbcUtils.list(TEST_CATALOG, "sf1")));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(null, "sf%");
            try {
                List<List<String>> expected = test.stream().filter(item -> ((String)item.get(1)).startsWith("sf")).collect(Collectors.toList());
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, expected);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas("unknown", null);
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(null, "unknown");
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(TEST_CATALOG, "unknown");
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas("unknown", "unknown");
            try {
                TestPrestoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    private static void assertGetSchemasResult(ResultSet rs, List<List<String>> expectedSchemas) throws SQLException {
        List<List<Object>> data = TestingJdbcUtils.readRows(rs);
        Assertions.assertThat(data).hasSize(expectedSchemas.size());
        for (List<Object> row : data) {
            Assertions.assertThat(TestingJdbcUtils.list((String)row.get(1), (String)row.get(0))).isIn(expectedSchemas);
        }
        ResultSetMetaData metadata = rs.getMetaData();
        Assert.assertEquals((int)metadata.getColumnCount(), (int)2);
        Assert.assertEquals((String)metadata.getColumnLabel(1), (String)"TABLE_SCHEM");
        Assert.assertEquals((int)metadata.getColumnType(1), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(2), (String)"TABLE_CATALOG");
        Assert.assertEquals((int)metadata.getColumnType(2), (int)12);
    }

    @Test
    public void testGetTables() throws Exception {
        ResultSet rs;
        try (Connection connection = this.createConnection();){
            rs = connection.getMetaData().getTables(null, null, null, null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, null, null, null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables("", null, null, null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", null, null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "", null, null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).doesNotContain((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", TestingJdbcUtils.array("TABLE"));
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).doesNotContain((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(null, "information_schema", null, null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(null, null, "tables", null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).doesNotContain((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(null, null, null, TestingJdbcUtils.array("TABLE"));
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "inf%", "tables", null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).doesNotContain((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tab%", null);
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).doesNotContain((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables("unknown", "information_schema", "tables", TestingJdbcUtils.array("TABLE"));
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "unknown", "tables", TestingJdbcUtils.array("TABLE"));
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "unknown", TestingJdbcUtils.array("TABLE"));
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", TestingJdbcUtils.array("unknown"));
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", TestingJdbcUtils.array("unknown", "TABLE"));
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "tables")}).doesNotContain((Object[])new List[]{TestPrestoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", TestingJdbcUtils.array(new String[0]));
            try {
                TestPrestoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            for (boolean includeTable : new boolean[]{false, true}) {
                for (boolean includeView : new boolean[]{false, true}) {
                    ArrayList<String> types = new ArrayList<String>();
                    ArrayList<List<Object>> expected = new ArrayList<List<Object>>();
                    if (includeTable) {
                        types.add("TABLE");
                        expected.add(TestPrestoDatabaseMetaData.getTablesRow("hive", "default", "test_table", "TABLE"));
                    }
                    if (includeView) {
                        types.add("VIEW");
                        expected.add(TestPrestoDatabaseMetaData.getTablesRow("hive", "default", "test_view", "VIEW"));
                    }
                    try (ResultSet rs2 = connection.getMetaData().getTables("hive", "default", "test_%", types.toArray(new String[0]));){
                        TestPrestoDatabaseMetaData.assertTableMetadata(rs2);
                        ImmutableMultiset rows = ImmutableMultiset.copyOf(TestingJdbcUtils.readRows(rs2));
                        Assertions.assertThat((Iterable)rows).isEqualTo((Object)ImmutableMultiset.copyOf(expected));
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static List<Object> getTablesRow(String schema, String table) {
        return TestPrestoDatabaseMetaData.getTablesRow(TEST_CATALOG, schema, table, "TABLE");
    }

    private static List<Object> getTablesRow(String catalog, String schema, String table, String type) {
        return TestingJdbcUtils.list(catalog, schema, table, type, null, null, null, null, null, null);
    }

    private static void assertTableMetadata(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        Assert.assertEquals((int)metadata.getColumnCount(), (int)10);
        Assert.assertEquals((String)metadata.getColumnLabel(1), (String)"TABLE_CAT");
        Assert.assertEquals((int)metadata.getColumnType(1), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(2), (String)"TABLE_SCHEM");
        Assert.assertEquals((int)metadata.getColumnType(2), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(3), (String)"TABLE_NAME");
        Assert.assertEquals((int)metadata.getColumnType(3), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(4), (String)"TABLE_TYPE");
        Assert.assertEquals((int)metadata.getColumnType(4), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(5), (String)"REMARKS");
        Assert.assertEquals((int)metadata.getColumnType(5), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(6), (String)"TYPE_CAT");
        Assert.assertEquals((int)metadata.getColumnType(6), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(7), (String)"TYPE_SCHEM");
        Assert.assertEquals((int)metadata.getColumnType(7), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(8), (String)"TYPE_NAME");
        Assert.assertEquals((int)metadata.getColumnType(8), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(9), (String)"SELF_REFERENCING_COL_NAME");
        Assert.assertEquals((int)metadata.getColumnType(9), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(10), (String)"REF_GENERATION");
        Assert.assertEquals((int)metadata.getColumnType(10), (int)12);
    }

    @Test
    public void testGetTableTypes() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet tableTypes = connection.getMetaData().getTableTypes();){
            Assertions.assertThat(TestingJdbcUtils.readRows(tableTypes)).isEqualTo(TestingJdbcUtils.list(TestingJdbcUtils.list("TABLE"), TestingJdbcUtils.list("VIEW")));
            ResultSetMetaData metadata = tableTypes.getMetaData();
            Assert.assertEquals((int)metadata.getColumnCount(), (int)1);
            Assert.assertEquals((String)metadata.getColumnLabel(1), (String)"TABLE_TYPE");
            Assert.assertEquals((int)metadata.getColumnType(1), (int)12);
        }
    }

    @Test
    public void testGetColumns() throws Exception {
        ResultSet rs;
        try (Connection connection = this.createConnection();){
            rs = connection.getMetaData().getColumns(null, null, "tables", "table_name");
            try {
                TestPrestoDatabaseMetaData.assertColumnMetadata(rs);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)rs.getString("TABLE_CAT"), (String)"blackhole");
                Assert.assertEquals((String)rs.getString("TABLE_SCHEM"), (String)"information_schema");
                Assert.assertEquals((String)rs.getString("TABLE_NAME"), (String)"tables");
                Assert.assertEquals((String)rs.getString("COLUMN_NAME"), (String)"table_name");
                Assert.assertEquals((int)rs.getInt("DATA_TYPE"), (int)12);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)rs.getString("TABLE_CAT"), (String)"hive");
                Assert.assertEquals((String)rs.getString("TABLE_SCHEM"), (String)"information_schema");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)rs.getString("TABLE_CAT"), (String)COUNTING_CATALOG);
                Assert.assertEquals((String)rs.getString("TABLE_SCHEM"), (String)"information_schema");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)rs.getString("TABLE_CAT"), (String)"system");
                Assert.assertEquals((String)rs.getString("TABLE_SCHEM"), (String)"information_schema");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)rs.getString("TABLE_CAT"), (String)"system");
                Assert.assertEquals((String)rs.getString("TABLE_SCHEM"), (String)"jdbc");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)rs.getString("TABLE_CAT"), (String)TEST_CATALOG);
                Assert.assertEquals((String)rs.getString("TABLE_SCHEM"), (String)"information_schema");
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, null, "tables", "table_name");
            try {
                TestPrestoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(null, "information_schema", "tables", "table_name");
            try {
                TestPrestoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(5);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, "information_schema", "tables", "table_name");
            try {
                TestPrestoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, "inf%", "tables", "table_name");
            try {
                TestPrestoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, "information_schema", "tab%", "table_name");
            try {
                TestPrestoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(2);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, "information_schema", "tables", "%m%");
            try {
                TestPrestoDatabaseMetaData.assertColumnMetadata(rs);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)rs.getString("COLUMN_NAME"), (String)"table_schema");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)rs.getString("COLUMN_NAME"), (String)"table_name");
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection("blackhole", "blackhole");
        try (Statement statement = connection.createStatement();){
            Assert.assertEquals((int)statement.executeUpdate("CREATE TABLE test_get_columns_table (c_boolean boolean, c_bigint bigint, c_integer integer, c_smallint smallint, c_tinyint tinyint, c_real real, c_double double, c_varchar_1234 varchar(1234), c_varchar varchar, c_char_345 char(345), c_varbinary varbinary, c_time time, c_time_0 time(0), c_time_3 time(3), c_time_6 time(6), c_time_9 time(9), c_time_12 time(12), c_time_with_time_zone time with time zone, c_time_with_time_zone_0 time(0) with time zone, c_time_with_time_zone_3 time(3) with time zone, c_time_with_time_zone_6 time(6) with time zone, c_time_with_time_zone_9 time(9) with time zone, c_time_with_time_zone_12 time(12) with time zone, c_timestamp timestamp, c_timestamp_0 timestamp(0), c_timestamp_3 timestamp(3), c_timestamp_6 timestamp(6), c_timestamp_9 timestamp(9), c_timestamp_12 timestamp(12), c_timestamp_with_time_zone timestamp with time zone, c_timestamp_with_time_zone_0 timestamp(0) with time zone, c_timestamp_with_time_zone_3 timestamp(3) with time zone, c_timestamp_with_time_zone_6 timestamp(6) with time zone, c_timestamp_with_time_zone_9 timestamp(9) with time zone, c_timestamp_with_time_zone_12 timestamp(12) with time zone, c_date date, c_decimal_8_2 decimal(8,2), c_decimal_38_0 decimal(38,0), c_array array<bigint>, c_color color)"), (int)0);
            try (ResultSet rs2 = connection.getMetaData().getColumns("blackhole", "blackhole", "test_get_columns_table", null);){
                TestPrestoDatabaseMetaData.assertColumnMetadata(rs2);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 16, null, null, null, null, (Type)BooleanType.BOOLEAN);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, -5, 19L, 10L, null, null, (Type)BigintType.BIGINT);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 4, 10L, 10L, null, null, (Type)IntegerType.INTEGER);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 5, 5L, 10L, null, null, (Type)SmallintType.SMALLINT);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, -6, 3L, 10L, null, null, (Type)TinyintType.TINYINT);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 7, 24L, 2L, null, null, (Type)RealType.REAL);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 8, 53L, 2L, null, null, (Type)DoubleType.DOUBLE);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 12, 1234L, null, null, 1234L, (Type)VarcharType.createVarcharType((int)1234));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 12, Integer.MAX_VALUE, null, null, Integer.MAX_VALUE, (Type)VarcharType.createUnboundedVarcharType());
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 1, 345L, null, null, 345L, (Type)CharType.createCharType((long)345L));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, -3, Integer.MAX_VALUE, null, null, Integer.MAX_VALUE, (Type)VarbinaryType.VARBINARY);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 92, 12L, null, 3L, null, (Type)TimeType.TIME);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 92, 8L, null, 0L, null, (Type)TimeType.createTimeType((int)0));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 92, 12L, null, 3L, null, (Type)TimeType.createTimeType((int)3));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 92, 15L, null, 6L, null, (Type)TimeType.createTimeType((int)6));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 92, 18L, null, 9L, null, (Type)TimeType.createTimeType((int)9));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 92, 21L, null, 12L, null, (Type)TimeType.createTimeType((int)12));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2013, 18L, null, 3L, null, (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2013, 14L, null, 0L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)0));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2013, 18L, null, 3L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)3));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2013, 21L, null, 6L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)6));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2013, 24L, null, 9L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2013, 27L, null, 12L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)12));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 93, 25L, null, 3L, null, (Type)TimestampType.TIMESTAMP);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 93, 21L, null, 0L, null, (Type)TimestampType.createTimestampType((int)0));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 93, 25L, null, 3L, null, (Type)TimestampType.createTimestampType((int)3));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 93, 28L, null, 6L, null, (Type)TimestampType.createTimestampType((int)6));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 93, 31L, null, 9L, null, (Type)TimestampType.createTimestampType((int)9));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 93, 34L, null, 12L, null, (Type)TimestampType.createTimestampType((int)12));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2014, 59L, null, 3L, null, (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2014, 55L, null, 0L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2014, 59L, null, 3L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2014, 62L, null, 6L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2014, 65L, null, 9L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2014, 68L, null, 12L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 91, 14L, null, null, null, (Type)DateType.DATE);
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 3, 8L, 10L, 2L, null, (Type)DecimalType.createDecimalType((int)8, (int)2));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 3, 38L, 10L, 0L, null, (Type)DecimalType.createDecimalType((int)38, (int)0));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2003, null, null, null, null, (Type)new ArrayType((Type)BigintType.BIGINT));
                TestPrestoDatabaseMetaData.assertColumnSpec(rs2, 2000, null, null, null, null, (Type)ColorType.COLOR);
                Assert.assertFalse((boolean)rs2.next());
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static void assertColumnSpec(ResultSet rs, int jdbcType, Long columnSize, Long numPrecRadix, Long decimalDigits, Long charOctetLength, Type type) throws SQLException {
        String message = " of " + type.getDisplayName() + ": ";
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getObject("TYPE_NAME"), (Object)type.getDisplayName(), (String)"TYPE_NAME");
        Assert.assertEquals((Object)rs.getObject("DATA_TYPE"), (Object)jdbcType, (String)("DATA_TYPE" + message));
        Assert.assertEquals((Object)rs.getObject("COLUMN_SIZE"), (Object)columnSize, (String)("COLUMN_SIZE" + message));
        Assert.assertEquals((Object)rs.getObject("NUM_PREC_RADIX"), (Object)numPrecRadix, (String)("NUM_PREC_RADIX" + message));
        Assert.assertEquals((Object)rs.getObject("DECIMAL_DIGITS"), (Object)decimalDigits, (String)("DECIMAL_DIGITS" + message));
        Assert.assertEquals((Object)rs.getObject("CHAR_OCTET_LENGTH"), (Object)charOctetLength, (String)("CHAR_OCTET_LENGTH" + message));
    }

    private static void assertColumnMetadata(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        Assert.assertEquals((int)metadata.getColumnCount(), (int)24);
        Assert.assertEquals((String)metadata.getColumnLabel(1), (String)"TABLE_CAT");
        Assert.assertEquals((int)metadata.getColumnType(1), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(2), (String)"TABLE_SCHEM");
        Assert.assertEquals((int)metadata.getColumnType(2), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(3), (String)"TABLE_NAME");
        Assert.assertEquals((int)metadata.getColumnType(3), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(4), (String)"COLUMN_NAME");
        Assert.assertEquals((int)metadata.getColumnType(4), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(5), (String)"DATA_TYPE");
        Assert.assertEquals((int)metadata.getColumnType(5), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(6), (String)"TYPE_NAME");
        Assert.assertEquals((int)metadata.getColumnType(6), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(7), (String)"COLUMN_SIZE");
        Assert.assertEquals((int)metadata.getColumnType(7), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(8), (String)"BUFFER_LENGTH");
        Assert.assertEquals((int)metadata.getColumnType(8), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(9), (String)"DECIMAL_DIGITS");
        Assert.assertEquals((int)metadata.getColumnType(9), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(10), (String)"NUM_PREC_RADIX");
        Assert.assertEquals((int)metadata.getColumnType(10), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(11), (String)"NULLABLE");
        Assert.assertEquals((int)metadata.getColumnType(11), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(12), (String)"REMARKS");
        Assert.assertEquals((int)metadata.getColumnType(12), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(13), (String)"COLUMN_DEF");
        Assert.assertEquals((int)metadata.getColumnType(13), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(14), (String)"SQL_DATA_TYPE");
        Assert.assertEquals((int)metadata.getColumnType(14), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(15), (String)"SQL_DATETIME_SUB");
        Assert.assertEquals((int)metadata.getColumnType(15), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(16), (String)"CHAR_OCTET_LENGTH");
        Assert.assertEquals((int)metadata.getColumnType(16), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(17), (String)"ORDINAL_POSITION");
        Assert.assertEquals((int)metadata.getColumnType(17), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(18), (String)"IS_NULLABLE");
        Assert.assertEquals((int)metadata.getColumnType(18), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(19), (String)"SCOPE_CATALOG");
        Assert.assertEquals((int)metadata.getColumnType(19), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(20), (String)"SCOPE_SCHEMA");
        Assert.assertEquals((int)metadata.getColumnType(20), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(21), (String)"SCOPE_TABLE");
        Assert.assertEquals((int)metadata.getColumnType(21), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(22), (String)"SOURCE_DATA_TYPE");
        Assert.assertEquals((int)metadata.getColumnType(22), (int)-5);
        Assert.assertEquals((String)metadata.getColumnLabel(23), (String)"IS_AUTOINCREMENT");
        Assert.assertEquals((int)metadata.getColumnType(23), (int)12);
        Assert.assertEquals((String)metadata.getColumnLabel(24), (String)"IS_GENERATEDCOLUMN");
        Assert.assertEquals((int)metadata.getColumnType(24), (int)12);
    }

    @Test
    public void testGetPseudoColumns() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getPseudoColumns(null, null, null, null);){
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetProcedures() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getProcedures(null, null, null);){
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetProcedureColumns() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getProcedureColumns(null, null, null, null);){
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetSuperTables() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getSuperTables(null, null, null);){
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetUdts() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getUDTs(null, null, null, null);){
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetAttributes() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getAttributes(null, null, null, null);){
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetSuperTypes() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getSuperTypes(null, null, null);){
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetSchemasMetadataCalls() throws Exception {
        Verify.verify((boolean)this.connection.getMetaData().getSearchStringEscape().equals("\\"));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(null, null), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(COUNTING_CATALOG, null), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "information_schema"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(COUNTING_CATALOG, "test\\_schema%"), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(COUNTING_CATALOG, "test_sch_ma1"), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(COUNTING_CATALOG, ""), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas("wrong", null), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount());
    }

    @Test
    public void testGetTablesMetadataCalls() throws Exception {
        Verify.verify((boolean)this.connection.getMetaData().getSearchStringEscape().equals("\\"));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(null, null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test\\_schema1", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), (Collection)this.countingMockConnector.getAllTables().filter(schemaTableName -> schemaTableName.getSchemaName().equals("test_schema1")).map(schemaTableName -> TestingJdbcUtils.list(COUNTING_CATALOG, schemaTableName.getSchemaName(), schemaTableName.getTableName(), "TABLE")).collect(ImmutableList.toImmutableList()), new CountingMockConnector.MetadataCallsCount().withListTablesCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test_sch_ma1", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), (Collection)this.countingMockConnector.getAllTables().filter(schemaTableName -> schemaTableName.getSchemaName().equals("test_schema1")).map(schemaTableName -> TestingJdbcUtils.list(COUNTING_CATALOG, schemaTableName.getSchemaName(), schemaTableName.getTableName(), "TABLE")).collect(ImmutableList.toImmutableList()), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "TABLE"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2", "test_table1", "TABLE")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, "test_t_ble1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "TABLE"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2", "test_table1", "TABLE")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test\\_schema1", "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "TABLE")), new CountingMockConnector.MetadataCallsCount());
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test_schema1", "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "TABLE")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables("wrong", null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount());
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, "", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, null, new String[0]), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount());
    }

    @Test
    public void testGetColumnsMetadataCalls() throws Exception {
        Verify.verify((boolean)this.connection.getMetaData().getSearchStringEscape().equals("\\"));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L).withGetColumnsCount(3000L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L).withGetColumnsCount(3000L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test\\_schema1", "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.range(0, 100).mapToObj(i -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_" + i, "varchar")).collect(ImmutableList.toImmutableList()), new CountingMockConnector.MetadataCallsCount().withListTablesCount(1L).withGetColumnsCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test\\_schema1", "test\\_table1", "column\\_17"), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_17", "varchar")), new CountingMockConnector.MetadataCallsCount().withListTablesCount(1L).withGetColumnsCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test_schema1", "test_table1", "column_17"), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_17", "varchar")), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(2L).withListTablesCount(3L).withGetColumnsCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, "test_schema1", "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.range(0, 100).mapToObj(columnIndex -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_" + columnIndex, "varchar")).collect(ImmutableList.toImmutableList()), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(2L).withListTablesCount(3L).withGetColumnsCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, "test_schema1", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.range(0, 1000).boxed().flatMap(tableIndex -> IntStream.range(0, 100).mapToObj(columnIndex -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table" + tableIndex, "column_" + columnIndex, "varchar"))).collect(ImmutableList.toImmutableList()), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(3L).withListTablesCount(1001L).withGetColumnsCount(1000L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, null, "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.rangeClosed(1, 2).boxed().flatMap(schemaIndex -> IntStream.range(0, 100).mapToObj(columnIndex -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema" + schemaIndex, "test_table1", "column_" + columnIndex, "varchar"))).collect(ImmutableList.toImmutableList()), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(3L).withListTablesCount(8L).withGetColumnsCount(2L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, "test\\_schema1", "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.range(0, 100).mapToObj(i -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_" + i, "varchar")).collect(ImmutableList.toImmutableList()), new CountingMockConnector.MetadataCallsCount().withListTablesCount(1L).withGetColumnsCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns("wrong", null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount());
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "wrong\\_schema1", "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount().withListTablesCount(1L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "wrong_schema1", "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(2L).withListTablesCount(0L).withGetColumnsCount(0L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(0L).withGetColumnsCount(0L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, null, "", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(0L).withGetColumnsCount(0L));
        this.assertMetadataCalls(this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, null, null, ""), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), new CountingMockConnector.MetadataCallsCount().withListSchemasCount(1L).withListTablesCount(2L).withGetColumnsCount(3000L));
    }

    private static void assertColumnSpec(ResultSet rs, int dataType, Long precision, Long numPrecRadix, String typeName) throws SQLException {
        String message = " of " + typeName + ": ";
        Assert.assertEquals((Object)rs.getObject("TYPE_NAME"), (Object)typeName, (String)("TYPE_NAME" + message));
        Assert.assertEquals((Object)rs.getObject("DATA_TYPE"), (Object)dataType, (String)("DATA_TYPE" + message));
        Assert.assertEquals((Object)rs.getObject("PRECISION"), (Object)precision, (String)("PRECISION" + message));
        Assert.assertEquals((Object)rs.getObject("LITERAL_PREFIX"), null, (String)("LITERAL_PREFIX" + message));
        Assert.assertEquals((Object)rs.getObject("LITERAL_SUFFIX"), null, (String)("LITERAL_SUFFIX" + message));
        Assert.assertEquals((Object)rs.getObject("CREATE_PARAMS"), null, (String)("CREATE_PARAMS" + message));
        Assert.assertEquals((Object)rs.getObject("NULLABLE"), (Object)1L, (String)("NULLABLE" + message));
        Assert.assertEquals((Object)rs.getObject("CASE_SENSITIVE"), (Object)false, (String)("CASE_SENSITIVE" + message));
        Assert.assertEquals((Object)rs.getObject("SEARCHABLE"), (Object)3L, (String)("SEARCHABLE" + message));
        Assert.assertEquals((Object)rs.getObject("UNSIGNED_ATTRIBUTE"), null, (String)("UNSIGNED_ATTRIBUTE" + message));
        Assert.assertEquals((Object)rs.getObject("FIXED_PREC_SCALE"), (Object)false, (String)("FIXED_PREC_SCALE" + message));
        Assert.assertEquals((Object)rs.getObject("AUTO_INCREMENT"), null, (String)("AUTO_INCREMENT" + message));
        Assert.assertEquals((Object)rs.getObject("LOCAL_TYPE_NAME"), null, (String)("LOCAL_TYPE_NAME" + message));
        Assert.assertEquals((Object)rs.getObject("MINIMUM_SCALE"), (Object)0L, (String)("MINIMUM_SCALE" + message));
        Assert.assertEquals((Object)rs.getObject("MAXIMUM_SCALE"), (Object)0L, (String)("MAXIMUM_SCALE" + message));
        Assert.assertEquals((Object)rs.getObject("SQL_DATA_TYPE"), null, (String)("SQL_DATA_TYPE" + message));
        Assert.assertEquals((Object)rs.getObject("SQL_DATETIME_SUB"), null, (String)("SQL_DATETIME_SUB" + message));
        Assert.assertEquals((Object)rs.getObject("NUM_PREC_RADIX"), (Object)numPrecRadix, (String)("NUM_PREC_RADIX" + message));
    }

    private Set<String> captureQueries(Callable<?> action) throws Exception {
        Set queryIdsBefore = (Set)this.server.getQueryManager().getQueries().stream().map(BasicQueryInfo::getQueryId).collect(ImmutableSet.toImmutableSet());
        action.call();
        return (Set)this.server.getQueryManager().getQueries().stream().filter(queryInfo -> !queryIdsBefore.contains(queryInfo.getQueryId())).map(BasicQueryInfo::getQuery).collect(ImmutableSet.toImmutableSet());
    }

    private void assertMetadataCalls(MetaDataCallback<? extends Collection<List<Object>>> callback, CountingMockConnector.MetadataCallsCount expectedMetadataCallsCount) throws Exception {
        this.assertMetadataCalls(callback, (Collection<List<Object>> actual) -> {}, expectedMetadataCallsCount);
    }

    private void assertMetadataCalls(MetaDataCallback<? extends Collection<List<Object>>> callback, Collection<List<?>> expected, CountingMockConnector.MetadataCallsCount expectedMetadataCallsCount) throws Exception {
        this.assertMetadataCalls(callback, (Collection<List<Object>> actual) -> Assertions.assertThat((Iterable)ImmutableMultiset.copyOf((Iterable)Objects.requireNonNull(actual, "actual is null"))).isEqualTo((Object)ImmutableMultiset.copyOf((Iterable)Objects.requireNonNull(expected, "expected is null"))), expectedMetadataCallsCount);
    }

    private void assertMetadataCalls(MetaDataCallback<? extends Collection<List<Object>>> callback, Consumer<Collection<List<Object>>> resultsVerification, CountingMockConnector.MetadataCallsCount expectedMetadataCallsCount) throws Exception {
        CountingMockConnector.MetadataCallsCount actualMetadataCallsCount;
        try (Connection connection = this.createConnection();){
            actualMetadataCallsCount = this.countingMockConnector.runCounting(() -> {
                try {
                    Collection actual = (Collection)callback.apply(connection.getMetaData());
                    resultsVerification.accept(actual);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        Assert.assertEquals((Object)actualMetadataCallsCount, (Object)expectedMetadataCallsCount);
    }

    private MetaDataCallback<List<List<Object>>> readMetaData(MetaDataCallback<ResultSet> query, List<String> columns) {
        return metaData -> {
            try (ResultSet resultSet = (ResultSet)query.apply(metaData);){
                List<List<Object>> list = TestingJdbcUtils.readRows(resultSet, columns);
                return list;
            }
        };
    }

    private Connection createConnection() throws SQLException {
        String url = String.format("jdbc:presto://%s", this.server.getAddress());
        return DriverManager.getConnection(url, "admin", null);
    }

    private Connection createConnection(String catalog, String schema) throws SQLException {
        String url = String.format("jdbc:presto://%s/%s/%s", this.server.getAddress(), catalog, schema);
        return DriverManager.getConnection(url, "admin", null);
    }

    private static interface MetaDataCallback<T> {
        public T apply(DatabaseMetaData var1) throws SQLException;
    }
}

