/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logging;
import io.prestosql.client.ClientSelectedRole;
import io.prestosql.execution.QueryState;
import io.prestosql.jdbc.PrestoConnection;
import io.prestosql.jdbc.PrestoIntervalDayTime;
import io.prestosql.jdbc.PrestoIntervalYearMonth;
import io.prestosql.jdbc.PrestoResultSet;
import io.prestosql.jdbc.PrestoStatement;
import io.prestosql.plugin.blackhole.BlackHolePlugin;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.TimeZoneKey;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPrestoDriver {
    private static final DateTimeZone ASIA_ORAL_ZONE = DateTimeZone.forID((String)"Asia/Oral");
    private static final GregorianCalendar ASIA_ORAL_CALENDAR = new GregorianCalendar(TimeZone.getTimeZone(ZoneId.of(ASIA_ORAL_ZONE.getID())));
    private static final String TEST_CATALOG = "test_catalog";
    private TestingPrestoServer server;
    private ExecutorService executorService;

    @BeforeClass
    public void setup() throws Exception {
        Logging.initialize();
        this.server = TestingPrestoServer.create();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog(TEST_CATALOG, "tpch");
        this.server.installPlugin((Plugin)new BlackHolePlugin());
        this.server.createCatalog("blackhole", "blackhole");
        this.server.waitForNodeRefresh(Duration.ofSeconds(10L));
        this.setupTestTables();
        this.executorService = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    }

    private void setupTestTables() throws SQLException {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Assert.assertEquals((int)statement.executeUpdate("CREATE SCHEMA blackhole.blackhole"), (int)0);
            Assert.assertEquals((int)statement.executeUpdate("CREATE TABLE test_table (x bigint)"), (int)0);
            Assert.assertEquals((int)statement.executeUpdate("CREATE TABLE slow_test_table (x bigint) WITH (   split_count = 1,    pages_per_split = 1,    rows_per_page = 1,    page_processing_delay = '1m')"), (int)0);
        }
    }

    @AfterClass(alwaysRun=true)
    public void teardown() throws Exception {
        this.executorService.shutdownNow();
        this.executorService = null;
        this.server.close();
    }

    @Test
    public void testDriverManager() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT   123 _integer,  12300000000 _bigint, 'foo' _varchar, 0.1E0 _double, true _boolean, cast('hello' as varbinary) _varbinary, DECIMAL '1234567890.1234567' _decimal_short, DECIMAL '.12345678901234567890123456789012345678' _decimal_long, approx_set(42) _hll, cast('foo' as char(5)) _char");){
            ResultSetMetaData metadata = rs.getMetaData();
            Assert.assertEquals((int)metadata.getColumnCount(), (int)10);
            Assert.assertEquals((String)metadata.getColumnLabel(1), (String)"_integer");
            Assert.assertEquals((int)metadata.getColumnType(1), (int)4);
            Assert.assertEquals((String)metadata.getColumnLabel(2), (String)"_bigint");
            Assert.assertEquals((int)metadata.getColumnType(2), (int)-5);
            Assert.assertEquals((String)metadata.getColumnLabel(3), (String)"_varchar");
            Assert.assertEquals((int)metadata.getColumnType(3), (int)12);
            Assert.assertEquals((String)metadata.getColumnLabel(4), (String)"_double");
            Assert.assertEquals((int)metadata.getColumnType(4), (int)8);
            Assert.assertEquals((String)metadata.getColumnLabel(5), (String)"_boolean");
            Assert.assertEquals((int)metadata.getColumnType(5), (int)16);
            Assert.assertEquals((String)metadata.getColumnLabel(6), (String)"_varbinary");
            Assert.assertEquals((int)metadata.getColumnType(6), (int)-3);
            Assert.assertEquals((String)metadata.getColumnLabel(7), (String)"_decimal_short");
            Assert.assertEquals((int)metadata.getColumnType(7), (int)3);
            Assert.assertEquals((String)metadata.getColumnLabel(8), (String)"_decimal_long");
            Assert.assertEquals((int)metadata.getColumnType(8), (int)3);
            Assert.assertEquals((String)metadata.getColumnLabel(9), (String)"_hll");
            Assert.assertEquals((int)metadata.getColumnType(9), (int)2000);
            Assert.assertEquals((String)metadata.getColumnLabel(10), (String)"_char");
            Assert.assertEquals((int)metadata.getColumnType(10), (int)1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getObject(1), (Object)123);
            Assert.assertEquals((Object)rs.getObject("_integer"), (Object)123);
            Assert.assertEquals((int)rs.getInt(1), (int)123);
            Assert.assertEquals((int)rs.getInt("_integer"), (int)123);
            Assert.assertEquals((long)rs.getLong(1), (long)123L);
            Assert.assertEquals((long)rs.getLong("_integer"), (long)123L);
            Assert.assertEquals((Object)rs.getObject(2), (Object)12300000000L);
            Assert.assertEquals((Object)rs.getObject("_bigint"), (Object)12300000000L);
            Assert.assertEquals((long)rs.getLong(2), (long)12300000000L);
            Assert.assertEquals((long)rs.getLong("_bigint"), (long)12300000000L);
            Assert.assertEquals((Object)rs.getObject(3), (Object)"foo");
            Assert.assertEquals((Object)rs.getObject("_varchar"), (Object)"foo");
            Assert.assertEquals((String)rs.getString(3), (String)"foo");
            Assert.assertEquals((String)rs.getString("_varchar"), (String)"foo");
            Assert.assertEquals((Object)rs.getObject(4), (Object)0.1);
            Assert.assertEquals((Object)rs.getObject("_double"), (Object)0.1);
            Assert.assertEquals((Object)rs.getDouble(4), (Object)0.1);
            Assert.assertEquals((Object)rs.getDouble("_double"), (Object)0.1);
            Assert.assertEquals((Object)rs.getObject(5), (Object)true);
            Assert.assertEquals((Object)rs.getObject("_boolean"), (Object)true);
            Assert.assertEquals((boolean)rs.getBoolean(5), (boolean)true);
            Assert.assertEquals((boolean)rs.getBoolean("_boolean"), (boolean)true);
            Assert.assertEquals((int)rs.getByte("_boolean"), (int)1);
            Assert.assertEquals((int)rs.getShort("_boolean"), (int)1);
            Assert.assertEquals((int)rs.getInt("_boolean"), (int)1);
            Assert.assertEquals((long)rs.getLong("_boolean"), (long)1L);
            Assert.assertEquals((Object)Float.valueOf(rs.getFloat("_boolean")), (Object)Float.valueOf(1.0f));
            Assert.assertEquals((Object)rs.getDouble("_boolean"), (Object)1.0);
            Assert.assertEquals((Object)rs.getObject(6), (Object)"hello".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((Object)rs.getObject("_varbinary"), (Object)"hello".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((Object)rs.getBytes(6), (Object)"hello".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((Object)rs.getBytes("_varbinary"), (Object)"hello".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((Object)rs.getObject(7), (Object)new BigDecimal("1234567890.1234567"));
            Assert.assertEquals((Object)rs.getObject("_decimal_short"), (Object)new BigDecimal("1234567890.1234567"));
            Assert.assertEquals((Object)rs.getBigDecimal(7), (Object)new BigDecimal("1234567890.1234567"));
            Assert.assertEquals((Object)rs.getBigDecimal("_decimal_short"), (Object)new BigDecimal("1234567890.1234567"));
            Assert.assertEquals((Object)rs.getBigDecimal(7, 1), (Object)new BigDecimal("1234567890.1"));
            Assert.assertEquals((Object)rs.getBigDecimal("_decimal_short", 1), (Object)new BigDecimal("1234567890.1"));
            Assert.assertEquals((Object)rs.getObject(8), (Object)new BigDecimal(".12345678901234567890123456789012345678"));
            Assert.assertEquals((Object)rs.getObject("_decimal_long"), (Object)new BigDecimal(".12345678901234567890123456789012345678"));
            Assert.assertEquals((Object)rs.getBigDecimal(8), (Object)new BigDecimal(".12345678901234567890123456789012345678"));
            Assert.assertEquals((Object)rs.getBigDecimal("_decimal_long"), (Object)new BigDecimal(".12345678901234567890123456789012345678"));
            Assert.assertEquals((Object)rs.getBigDecimal(8, 6), (Object)new BigDecimal(".123457"));
            Assert.assertEquals((Object)rs.getBigDecimal("_decimal_long", 6), (Object)new BigDecimal(".123457"));
            io.airlift.testing.Assertions.assertInstanceOf((Object)rs.getObject(9), byte[].class);
            io.airlift.testing.Assertions.assertInstanceOf((Object)rs.getObject("_hll"), byte[].class);
            io.airlift.testing.Assertions.assertInstanceOf((Object)rs.getBytes(9), byte[].class);
            io.airlift.testing.Assertions.assertInstanceOf((Object)rs.getBytes("_hll"), byte[].class);
            Assert.assertEquals((Object)rs.getObject(10), (Object)"foo  ");
            Assert.assertEquals((Object)rs.getObject("_char"), (Object)"foo  ");
            Assert.assertEquals((String)rs.getString(10), (String)"foo  ");
            Assert.assertEquals((String)rs.getString("_char"), (String)"foo  ");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testTypes() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT   TIME '3:04:05' as a, TIME '6:07:08 +06:17' as b, TIME '9:10:11 +02:00' as c, TIMESTAMP '2001-02-03 3:04:05' as d, TIMESTAMP '2004-05-06 6:07:08 +06:17' as e, TIMESTAMP '2007-08-09 9:10:11 Europe/Berlin' as f, DATE '2013-03-22' as g, INTERVAL '123-11' YEAR TO MONTH as h, INTERVAL '11 22:33:44.555' DAY TO SECOND as i, REAL '123.45' as j, REAL 'Infinity' as k");){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getTime(1), (Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5).getMillis()));
            Assert.assertEquals((Object)rs.getTime(1, (Calendar)ASIA_ORAL_CALENDAR), (Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5, ASIA_ORAL_ZONE).getMillis()));
            Assert.assertEquals((Object)rs.getObject(1), (Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5).getMillis()));
            Assert.assertEquals((Object)rs.getTime("a"), (Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5).getMillis()));
            Assert.assertEquals((Object)rs.getTime("a", (Calendar)ASIA_ORAL_CALENDAR), (Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5, ASIA_ORAL_ZONE).getMillis()));
            Assert.assertEquals((Object)rs.getObject("a"), (Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5).getMillis()));
            Assert.assertEquals((Object)rs.getTime(2), (Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getTime(2, (Calendar)ASIA_ORAL_CALENDAR), (Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getObject(2), (Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getTime("b"), (Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getTime("b", (Calendar)ASIA_ORAL_CALENDAR), (Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getObject("b"), (Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getTime(3), (Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assert.assertEquals((Object)rs.getTime(3, (Calendar)ASIA_ORAL_CALENDAR), (Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assert.assertEquals((Object)rs.getObject(3), (Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assert.assertEquals((Object)rs.getTime("c"), (Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assert.assertEquals((Object)rs.getTime("c", (Calendar)ASIA_ORAL_CALENDAR), (Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assert.assertEquals((Object)rs.getObject("c"), (Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assert.assertEquals((Object)rs.getTimestamp(4), (Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5).getMillis()));
            Assert.assertEquals((Object)rs.getTimestamp(4, (Calendar)ASIA_ORAL_CALENDAR), (Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, ASIA_ORAL_ZONE).getMillis()));
            Assert.assertEquals((Object)rs.getObject(4), (Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5).getMillis()));
            Assert.assertEquals((Object)rs.getTimestamp("d"), (Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5).getMillis()));
            Assert.assertEquals((Object)rs.getTimestamp("d", (Calendar)ASIA_ORAL_CALENDAR), (Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, ASIA_ORAL_ZONE).getMillis()));
            Assert.assertEquals((Object)rs.getObject("d"), (Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5).getMillis()));
            Assert.assertEquals((Object)rs.getTimestamp(5), (Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getTimestamp(5, (Calendar)ASIA_ORAL_CALENDAR), (Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getObject(5), (Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getObject(5, ZonedDateTime.class), (Object)ZonedDateTime.of(2004, 5, 6, 6, 7, 8, 0, ZoneOffset.ofHoursMinutes(6, 17)));
            Assert.assertEquals((Object)rs.getTimestamp("e"), (Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getTimestamp("e", (Calendar)ASIA_ORAL_CALENDAR), (Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getObject("e"), (Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assert.assertEquals((Object)rs.getObject("e", ZonedDateTime.class), (Object)ZonedDateTime.of(2004, 5, 6, 6, 7, 8, 0, ZoneOffset.ofHoursMinutes(6, 17)));
            Assert.assertEquals((Object)rs.getTimestamp(6), (Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assert.assertEquals((Object)rs.getTimestamp(6, (Calendar)ASIA_ORAL_CALENDAR), (Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assert.assertEquals((Object)rs.getObject(6), (Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assert.assertEquals((Object)rs.getObject(6, ZonedDateTime.class), (Object)ZonedDateTime.of(2007, 8, 9, 9, 10, 11, 0, ZoneId.of("Europe/Berlin")));
            Assert.assertEquals((Object)rs.getTimestamp("f"), (Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assert.assertEquals((Object)rs.getTimestamp("f", (Calendar)ASIA_ORAL_CALENDAR), (Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assert.assertEquals((Object)rs.getObject("f"), (Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assert.assertEquals((Object)rs.getObject("f", ZonedDateTime.class), (Object)ZonedDateTime.of(2007, 8, 9, 9, 10, 11, 0, ZoneId.of("Europe/Berlin")));
            Assert.assertEquals((Object)rs.getDate(7), (Object)new Date(new DateTime(2013, 3, 22, 0, 0).getMillis()));
            Assert.assertEquals((Object)rs.getDate(7, (Calendar)ASIA_ORAL_CALENDAR), (Object)new Date(new DateTime(2013, 3, 22, 0, 0, ASIA_ORAL_ZONE).getMillis()));
            Assert.assertEquals((Object)rs.getObject(7), (Object)new Date(new DateTime(2013, 3, 22, 0, 0).getMillis()));
            Assert.assertEquals((Object)rs.getDate("g"), (Object)new Date(new DateTime(2013, 3, 22, 0, 0).getMillis()));
            Assert.assertEquals((Object)rs.getDate("g", (Calendar)ASIA_ORAL_CALENDAR), (Object)new Date(new DateTime(2013, 3, 22, 0, 0, ASIA_ORAL_ZONE).getMillis()));
            Assert.assertEquals((Object)rs.getObject("g"), (Object)new Date(new DateTime(2013, 3, 22, 0, 0).getMillis()));
            Assert.assertEquals((Object)rs.getObject(8), (Object)new PrestoIntervalYearMonth(123, 11));
            Assert.assertEquals((Object)rs.getObject("h"), (Object)new PrestoIntervalYearMonth(123, 11));
            Assert.assertEquals((Object)rs.getObject(9), (Object)new PrestoIntervalDayTime(11, 22, 33, 44, 555));
            Assert.assertEquals((Object)rs.getObject("i"), (Object)new PrestoIntervalDayTime(11, 22, 33, 44, 555));
            Assert.assertEquals((Object)Float.valueOf(rs.getFloat(10)), (Object)Float.valueOf(123.45f));
            Assert.assertEquals((Object)rs.getObject(10), (Object)Float.valueOf(123.45f));
            Assert.assertEquals((Object)Float.valueOf(rs.getFloat("j")), (Object)Float.valueOf(123.45f));
            Assert.assertEquals((Object)rs.getObject("j"), (Object)Float.valueOf(123.45f));
            Assert.assertEquals((Object)Float.valueOf(rs.getFloat(11)), (Object)Float.valueOf(Float.POSITIVE_INFINITY));
            Assert.assertEquals((Object)rs.getObject(11), (Object)Float.valueOf(Float.POSITIVE_INFINITY));
            Assert.assertEquals((Object)Float.valueOf(rs.getFloat("k")), (Object)Float.valueOf(Float.POSITIVE_INFINITY));
            Assert.assertEquals((Object)rs.getObject("k"), (Object)Float.valueOf(Float.POSITIVE_INFINITY));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetDriverVersion() throws Exception {
        Driver driver = DriverManager.getDriver("jdbc:presto:");
        Assert.assertEquals((int)driver.getMajorVersion(), (int)0);
        Assert.assertEquals((int)driver.getMajorVersion(), (int)0);
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertEquals((String)metaData.getDriverName(), (String)"Presto JDBC Driver");
            Assert.assertEquals((String)metaData.getDriverVersion(), (String)"unknown");
            Assert.assertEquals((int)metaData.getDriverMajorVersion(), (int)0);
            Assert.assertEquals((int)metaData.getDriverMinorVersion(), (int)0);
        }
    }

    @Test
    public void testExecuteWithQuery() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123 x, 'foo' y, CAST(NULL AS bigint) z"));
            ResultSet rs = statement.getResultSet();
            Assert.assertEquals((int)statement.getUpdateCount(), (int)-1);
            Assert.assertEquals((long)statement.getLargeUpdateCount(), (long)-1L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rs.getLong(1), (long)123L);
            Assert.assertFalse((boolean)rs.wasNull());
            Assert.assertEquals((long)rs.getLong("x"), (long)123L);
            Assert.assertFalse((boolean)rs.wasNull());
            Assert.assertEquals((long)rs.getLong(3), (long)0L);
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)rs.getLong("z"), (long)0L);
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertNull((Object)rs.getObject("z"));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((String)rs.getString(2), (String)"foo");
            Assert.assertFalse((boolean)rs.wasNull());
            Assert.assertEquals((String)rs.getString("y"), (String)"foo");
            Assert.assertFalse((boolean)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testExecuteUpdateWithInsert() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Assert.assertEquals((int)statement.executeUpdate("INSERT INTO test_table VALUES (1), (2)"), (int)2);
            Assert.assertNull((Object)statement.getResultSet());
            Assert.assertEquals((int)statement.getUpdateCount(), (int)2);
            Assert.assertEquals((long)statement.getLargeUpdateCount(), (long)2L);
        }
    }

    @Test
    public void testExecuteUpdateWithCreateTable() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Assert.assertEquals((int)statement.executeUpdate("CREATE TABLE test_execute_create (x bigint)"), (int)0);
            Assert.assertNull((Object)statement.getResultSet());
            Assert.assertEquals((int)statement.getUpdateCount(), (int)0);
            Assert.assertEquals((long)statement.getLargeUpdateCount(), (long)0L);
        }
    }

    @Test
    public void testExecuteUpdateWithQuery() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            String sql = "SELECT 123 x, 'foo' y, CAST(NULL AS bigint) z";
            try {
                statement.executeUpdate(sql);
                Assert.fail((String)"expected exception");
            }
            catch (SQLException e) {
                Assert.assertEquals((String)e.getMessage(), (String)("SQL is not an update statement: " + sql));
            }
        }
    }

    @Test
    public void testExecuteQueryWithInsert() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            String sql = "INSERT INTO test_table VALUES (1)";
            try {
                statement.executeQuery(sql);
                Assert.fail((String)"expected exception");
            }
            catch (SQLException e) {
                Assert.assertEquals((String)e.getMessage(), (String)("SQL statement is not a query: " + sql));
            }
        }
    }

    @Test
    public void testStatementReuse() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Assert.assertFalse((boolean)statement.execute("INSERT INTO test_table VALUES (1), (2)"));
            Assert.assertNull((Object)statement.getResultSet());
            Assert.assertEquals((int)statement.getUpdateCount(), (int)2);
            Assert.assertEquals((long)statement.getLargeUpdateCount(), (long)2L);
            Assert.assertTrue((boolean)statement.execute("SELECT 123 x, 'foo' y, CAST(NULL AS bigint) z"));
            ResultSet resultSet = statement.getResultSet();
            Assert.assertNotNull((Object)resultSet);
            Assert.assertEquals((int)statement.getUpdateCount(), (int)-1);
            Assert.assertEquals((long)statement.getLargeUpdateCount(), (long)-1L);
            resultSet.close();
            Assert.assertFalse((boolean)statement.execute("INSERT INTO test_table VALUES (1), (2), (3)"));
            Assert.assertNull((Object)statement.getResultSet());
            Assert.assertEquals((int)statement.getUpdateCount(), (int)3);
            Assert.assertEquals((long)statement.getLargeUpdateCount(), (long)3L);
        }
    }

    @Test
    public void testGetUpdateCount() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123 x, 'foo' y"));
            Assert.assertEquals((int)statement.getUpdateCount(), (int)-1);
            Assert.assertEquals((long)statement.getLargeUpdateCount(), (long)-1L);
        }
    }

    @Test
    public void testResultSetClose() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123 x, 'foo' y"));
            ResultSet result = statement.getResultSet();
            Assert.assertFalse((boolean)result.isClosed());
            result.close();
            Assert.assertTrue((boolean)result.isClosed());
        }
    }

    @Test
    public void testGetResultSet() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123 x, 'foo' y"));
            ResultSet result = statement.getResultSet();
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.isClosed());
            statement.getMoreResults();
            Assert.assertTrue((boolean)result.isClosed());
            Assert.assertTrue((boolean)statement.execute("SELECT 123 x, 'foo' y"));
            result = statement.getResultSet();
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.isClosed());
            Assert.assertTrue((boolean)statement.execute("SELECT 123 x, 'foo' y"));
            Assert.assertFalse((boolean)statement.getMoreResults(1));
        }
    }

    @Test(expectedExceptions={SQLFeatureNotSupportedException.class}, expectedExceptionsMessageRegExp="Multiple open results not supported")
    public void testGetMoreResultsException() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123 x, 'foo' y"));
            statement.getMoreResults(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMoreResultsClearsUpdateCount() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "default");){
            Object statement;
            try {
                statement = connection.createStatement().unwrap(PrestoStatement.class);
                try {
                    Assert.assertFalse((boolean)statement.execute("CREATE TABLE test_more_results_clears_update_count (id bigint)"));
                    Assert.assertEquals((int)statement.getUpdateCount(), (int)0);
                    Assert.assertEquals((String)statement.getUpdateType(), (String)"CREATE TABLE");
                    Assert.assertFalse((boolean)statement.getMoreResults());
                    Assert.assertEquals((int)statement.getUpdateCount(), (int)-1);
                    Assert.assertNull((Object)statement.getUpdateType());
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                statement = connection.createStatement();
                try {
                    statement.execute("DROP TABLE test_more_results_clears_update_count");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }
    }

    @Test
    public void testSetTimeZoneId() throws Exception {
        TimeZoneKey defaultZoneKey = TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID());
        DateTimeZone defaultZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault());
        String sql = "SELECT current_timezone() zone, TIMESTAMP '2001-02-03 3:04:05' ts";
        try (Connection connection = this.createConnection();){
            ResultSet rs;
            try (Statement statement = connection.createStatement();){
                rs = statement.executeQuery(sql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((String)rs.getString("zone"), (String)defaultZoneKey.getId());
                    Assert.assertEquals((Object)rs.getTimestamp("ts"), (Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, defaultZone).getMillis()));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            connection.unwrap(PrestoConnection.class).setTimeZoneId("UTC");
            statement = connection.createStatement();
            try {
                rs = statement.executeQuery(sql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((String)rs.getString("zone"), (String)"UTC");
                    Assert.assertEquals((Object)rs.getTimestamp("ts"), (Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, defaultZone).getMillis()));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testConnectionStringWithCatalogAndSchema() throws Exception {
        String prefix = String.format("jdbc:presto://%s", this.server.getAddress());
        Connection connection = DriverManager.getConnection(prefix + "/a/b/", "test", null);
        Assert.assertEquals((String)connection.getCatalog(), (String)"a");
        Assert.assertEquals((String)connection.getSchema(), (String)"b");
        connection = DriverManager.getConnection(prefix + "/a/b", "test", null);
        Assert.assertEquals((String)connection.getCatalog(), (String)"a");
        Assert.assertEquals((String)connection.getSchema(), (String)"b");
        connection = DriverManager.getConnection(prefix + "/a/", "test", null);
        Assert.assertEquals((String)connection.getCatalog(), (String)"a");
        Assert.assertNull((Object)connection.getSchema());
        connection = DriverManager.getConnection(prefix + "/a", "test", null);
        Assert.assertEquals((String)connection.getCatalog(), (String)"a");
        Assert.assertNull((Object)connection.getSchema());
        connection = DriverManager.getConnection(prefix + "/", "test", null);
        Assert.assertNull((Object)connection.getCatalog());
        Assert.assertNull((Object)connection.getSchema());
        connection = DriverManager.getConnection(prefix, "test", null);
        Assert.assertNull((Object)connection.getCatalog());
        Assert.assertNull((Object)connection.getSchema());
    }

    @Test
    public void testConnectionWithCatalogAndSchema() throws Exception {
        try (Connection connection = this.createConnection(TEST_CATALOG, "information_schema");
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT table_catalog, table_schema FROM tables WHERE table_schema = 'information_schema'   AND table_name = 'tables'");){
            ResultSetMetaData metadata = rs.getMetaData();
            Assert.assertEquals((int)metadata.getColumnCount(), (int)2);
            Assert.assertEquals((String)metadata.getColumnLabel(1), (String)"table_catalog");
            Assert.assertEquals((String)metadata.getColumnLabel(2), (String)"table_schema");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((String)rs.getString("table_catalog"), (String)TEST_CATALOG);
        }
    }

    @Test
    public void testConnectionWithCatalog() throws Exception {
        try (Connection connection = this.createConnection(TEST_CATALOG);
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT table_catalog, table_schema FROM information_schema.tables WHERE table_schema = 'information_schema'   AND table_name = 'tables'");){
            ResultSetMetaData metadata = rs.getMetaData();
            Assert.assertEquals((int)metadata.getColumnCount(), (int)2);
            Assert.assertEquals((String)metadata.getColumnLabel(1), (String)"table_catalog");
            Assert.assertEquals((String)metadata.getColumnLabel(2), (String)"table_schema");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((String)rs.getString("table_catalog"), (String)TEST_CATALOG);
        }
    }

    @Test
    public void testConnectionResourceHandling() throws Exception {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (int i = 0; i < 100; ++i) {
            Connection connection = this.createConnection();
            connections.add(connection);
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery("SELECT 123");){
                Assert.assertTrue((boolean)rs.next());
                continue;
            }
        }
        for (Connection connection : connections) {
            connection.close();
        }
    }

    @Test(expectedExceptions={SQLException.class}, expectedExceptionsMessageRegExp=".* does not exist")
    public void testBadQuery() throws Exception {
        try (Connection connection = this.createConnection("test", "tiny");
             Statement statement = connection.createStatement();
             ResultSet ignored = statement.executeQuery("SELECT * FROM bad_table");){
            Assert.fail((String)"expected exception");
        }
    }

    @Test(expectedExceptions={SQLException.class}, expectedExceptionsMessageRegExp="Connection property 'user' is required")
    public void testUserIsRequired() throws Exception {
        try (Connection ignored = DriverManager.getConnection(String.format("jdbc:presto://%s", this.server.getAddress()));){
            Assert.fail((String)"expected exception");
        }
    }

    @Test
    public void testSetRole() throws Exception {
        try (PrestoConnection connection = this.createConnection(TEST_CATALOG, "tiny").unwrap(PrestoConnection.class);){
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("SET ROLE ALL");
            }
            Assert.assertEquals((Map)connection.getRoles(), (Map)ImmutableMap.of((Object)TEST_CATALOG, (Object)new ClientSelectedRole(ClientSelectedRole.Type.ALL, Optional.empty())));
            statement = connection.createStatement();
            try {
                statement.executeUpdate("SET ROLE NONE");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            Assert.assertEquals((Map)connection.getRoles(), (Map)ImmutableMap.of((Object)TEST_CATALOG, (Object)new ClientSelectedRole(ClientSelectedRole.Type.NONE, Optional.empty())));
            statement = connection.createStatement();
            try {
                statement.executeUpdate("SET ROLE bar");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            Assert.assertEquals((Map)connection.getRoles(), (Map)ImmutableMap.of((Object)TEST_CATALOG, (Object)new ClientSelectedRole(ClientSelectedRole.Type.ROLE, Optional.of("bar"))));
        }
    }

    @Test(timeOut=10000L)
    public void testQueryCancelByInterrupt() throws Exception {
        CountDownLatch queryStarted = new CountDownLatch(1);
        CountDownLatch queryFinished = new CountDownLatch(1);
        AtomicReference queryId = new AtomicReference();
        AtomicReference queryFailure = new AtomicReference();
        Future<Object> queryFuture = this.executorService.submit(() -> {
            try (Connection connection = this.createConnection("blackhole", "blackhole");
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT * FROM slow_test_table");){
                queryId.set(resultSet.unwrap(PrestoResultSet.class).getQueryId());
                queryStarted.countDown();
                try {
                    resultSet.next();
                }
                catch (SQLException t) {
                    queryFailure.set(t);
                }
                finally {
                    queryFinished.countDown();
                }
            }
            return null;
        });
        Assert.assertTrue((boolean)queryStarted.await(10L, TimeUnit.SECONDS));
        Assert.assertNotNull(queryId.get());
        Assert.assertFalse((boolean)this.getQueryState((String)queryId.get()).isDone());
        queryFuture.cancel(true);
        Assert.assertTrue((boolean)queryFinished.await(10L, TimeUnit.SECONDS));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Throwable)queryFailure.get())).isInstanceOf(SQLException.class)).hasMessage("ResultSet thread was interrupted");
        Assert.assertEquals((Object)this.getQueryState((String)queryId.get()), (Object)QueryState.FAILED);
    }

    @Test(timeOut=10000L)
    public void testQueryCancelExplicit() throws Exception {
        CountDownLatch queryStarted = new CountDownLatch(1);
        CountDownLatch queryFinished = new CountDownLatch(1);
        AtomicReference queryId = new AtomicReference();
        AtomicReference queryFailure = new AtomicReference();
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            this.executorService.execute(() -> {
                try (ResultSet resultSet = statement.executeQuery("SELECT * FROM slow_test_table");){
                    queryId.set(resultSet.unwrap(PrestoResultSet.class).getQueryId());
                    queryStarted.countDown();
                    resultSet.next();
                }
                catch (SQLException t) {
                    queryFailure.set(t);
                }
                finally {
                    queryFinished.countDown();
                }
            });
            queryStarted.await(10L, TimeUnit.SECONDS);
            Assert.assertNotNull(queryId.get());
            Assert.assertFalse((boolean)this.getQueryState((String)queryId.get()).isDone());
            statement.cancel();
            queryFinished.await(10L, TimeUnit.SECONDS);
            Assert.assertNotNull(queryFailure.get());
            Assert.assertEquals((Object)this.getQueryState((String)queryId.get()), (Object)QueryState.FAILED);
        }
    }

    @Test(timeOut=10000L)
    public void testUpdateCancelExplicit() throws Exception {
        CountDownLatch queryFinished = new CountDownLatch(1);
        AtomicReference queryFailure = new AtomicReference();
        String queryUuid = "/* " + UUID.randomUUID().toString() + " */";
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Optional<QueryState> state;
            this.executorService.execute(() -> {
                try {
                    statement.executeUpdate("CREATE TABLE test_cancel_create AS SELECT * FROM slow_test_table " + queryUuid);
                }
                catch (SQLException t) {
                    queryFailure.set(t);
                }
                finally {
                    queryFinished.countDown();
                }
            });
            while (true) {
                if ((state = this.findQueryState(queryUuid)).isPresent()) break;
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            Assert.assertFalse((boolean)state.get().isDone());
            statement.cancel();
            queryFinished.await(10L, TimeUnit.SECONDS);
            Assert.assertNotNull(queryFailure.get());
            Assert.assertEquals(this.findQueryState(queryUuid), Optional.of(QueryState.FAILED));
        }
    }

    @Test(timeOut=10000L)
    public void testQueryTimeout() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE test_query_timeout (key BIGINT) WITH (   split_count = 1,    pages_per_split = 1,    rows_per_page = 1,    page_processing_delay = '1m')");
        }
        CountDownLatch queryFinished = new CountDownLatch(1);
        AtomicReference queryFailure = new AtomicReference();
        this.executorService.submit(() -> {
            try (Connection connection = this.createConnection("blackhole", "blackhole");
                 Statement statement = connection.createStatement();){
                statement.setQueryTimeout(1);
                try (ResultSet resultSet = statement.executeQuery("SELECT * FROM test_query_timeout");){
                    try {
                        resultSet.next();
                    }
                    catch (SQLException t) {
                        queryFailure.set(t);
                    }
                    finally {
                        queryFinished.countDown();
                    }
                }
            }
            return null;
        });
        queryFinished.await();
        Assert.assertNotNull(queryFailure.get());
        io.airlift.testing.Assertions.assertContains((String)((Throwable)queryFailure.get()).getMessage(), (String)"Query exceeded maximum time limit of 1.00s");
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            statement.executeUpdate("DROP TABLE test_query_timeout");
        }
    }

    @Test(timeOut=10000L)
    public void testQueryPartialCancel() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT count(*) FROM slow_test_table");){
            statement.unwrap(PrestoStatement.class).partialCancel();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)resultSet.getLong(1), (long)0L);
        }
    }

    @Test(timeOut=10000L)
    public void testUpdatePartialCancel() throws Exception {
        CountDownLatch queryRunning = new CountDownLatch(1);
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Future<Integer> future = this.executorService.submit(() -> statement.executeUpdate("INSERT INTO test_table SELECT count(*) x FROM slow_test_table"));
            statement.unwrap(PrestoStatement.class).setProgressMonitor(stats -> {
                if (stats.getState().equals(QueryState.RUNNING.toString())) {
                    queryRunning.countDown();
                }
            });
            queryRunning.await(10L, TimeUnit.SECONDS);
            statement.unwrap(PrestoStatement.class).partialCancel();
            Assert.assertEquals((Object)future.get(10L, TimeUnit.SECONDS), (Object)1);
        }
    }

    /*
     * Exception decompiling
     */
    private QueryState getQueryState(String queryId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Optional<QueryState> findQueryState(String text) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Connection createConnection() throws SQLException {
        String url = String.format("jdbc:presto://%s", this.server.getAddress());
        return DriverManager.getConnection(url, "test", null);
    }

    private Connection createConnection(String catalog) throws SQLException {
        String url = String.format("jdbc:presto://%s/%s", this.server.getAddress(), catalog);
        return DriverManager.getConnection(url, "test", null);
    }

    private Connection createConnection(String catalog, String schema) throws SQLException {
        String url = String.format("jdbc:presto://%s/%s/%s", this.server.getAddress(), catalog, schema);
        return DriverManager.getConnection(url, "test", null);
    }
}

