/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import io.airlift.log.Logging;
import io.airlift.security.pem.PemReader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPrestoDriverAuth {
    private static final String TEST_CATALOG = "test_catalog";
    private TestingPrestoServer server;
    private byte[] defaultKey;
    private byte[] hmac222;
    private PrivateKey privateKey33;

    @BeforeClass
    public void setup() throws Exception {
        Logging.initialize();
        URL resource = this.getClass().getClassLoader().getResource("33.privateKey");
        Assert.assertNotNull((Object)resource, (String)"key directory not found");
        File keyDir = new File(resource.getFile()).getAbsoluteFile().getParentFile();
        this.defaultKey = Base64.getMimeDecoder().decode(Files.asCharSource((File)new File(keyDir, "default-key.key"), (Charset)StandardCharsets.US_ASCII).read().getBytes(StandardCharsets.US_ASCII));
        this.hmac222 = Base64.getMimeDecoder().decode(Files.asCharSource((File)new File(keyDir, "222.key"), (Charset)StandardCharsets.US_ASCII).read().getBytes(StandardCharsets.US_ASCII));
        this.privateKey33 = PemReader.loadPrivateKey((File)new File(keyDir, "33.privateKey"), Optional.empty());
        this.server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"http-server.authentication.type", (Object)"JWT").put((Object)"http.authentication.jwt.key-file", (Object)new File(keyDir, "${KID}.key").getPath()).put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)Resources.getResource((String)"localhost.keystore").getPath()).put((Object)"http-server.https.keystore.key", (Object)"changeit").build()).build();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog(TEST_CATALOG, "tpch");
        this.server.waitForNodeRefresh(Duration.ofSeconds(10L));
    }

    @AfterClass(alwaysRun=true)
    public void teardown() throws Exception {
        this.server.close();
    }

    @Test
    public void testSuccessDefaultKey() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").signWith(SignatureAlgorithm.HS512, this.defaultKey).compact();
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of((Object)"accessToken", (Object)accessToken));
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123"));
            ResultSet rs = statement.getResultSet();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rs.getLong(1), (long)123L);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSuccessHmac() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"222").signWith(SignatureAlgorithm.HS512, this.hmac222).compact();
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of((Object)"accessToken", (Object)accessToken));
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123"));
            ResultSet rs = statement.getResultSet();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rs.getLong(1), (long)123L);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSuccessPublicKey() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"33").signWith(SignatureAlgorithm.RS256, (Key)this.privateKey33).compact();
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of((Object)"accessToken", (Object)accessToken));
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123"));
            ResultSet rs = statement.getResultSet();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rs.getLong(1), (long)123L);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test(expectedExceptions={SQLException.class}, expectedExceptionsMessageRegExp="Authentication failed: Unauthorized")
    public void testFailedNoToken() throws Exception {
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of());
             Statement statement = connection.createStatement();){
            statement.execute("SELECT 123");
        }
    }

    @Test(expectedExceptions={SQLException.class}, expectedExceptionsMessageRegExp="Authentication failed: Unsigned Claims JWTs are not supported.")
    public void testFailedUnsigned() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").compact();
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of((Object)"accessToken", (Object)accessToken));
             Statement statement = connection.createStatement();){
            statement.execute("SELECT 123");
        }
    }

    @Test(expectedExceptions={SQLException.class}, expectedExceptionsMessageRegExp="Authentication failed: JWT signature does not match.*")
    public void testFailedBadHmacSignature() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").signWith(SignatureAlgorithm.HS512, Base64.getEncoder().encodeToString("bad-key".getBytes(StandardCharsets.US_ASCII))).compact();
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of((Object)"accessToken", (Object)accessToken));
             Statement statement = connection.createStatement();){
            statement.execute("SELECT 123");
        }
    }

    @Test(expectedExceptions={SQLException.class}, expectedExceptionsMessageRegExp="Authentication failed: JWT signature does not match.*")
    public void testFailedWrongPublicKey() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"42").signWith(SignatureAlgorithm.RS256, (Key)this.privateKey33).compact();
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of((Object)"accessToken", (Object)accessToken));
             Statement statement = connection.createStatement();){
            statement.execute("SELECT 123");
        }
    }

    @Test(expectedExceptions={SQLException.class}, expectedExceptionsMessageRegExp="Authentication failed: Unknown signing key ID")
    public void testFailedUnknownPublicKey() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"unknown").signWith(SignatureAlgorithm.RS256, (Key)this.privateKey33).compact();
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of((Object)"accessToken", (Object)accessToken));
             Statement statement = connection.createStatement();){
            statement.execute("SELECT 123");
        }
    }

    @Test
    public void testSuccessFullSslVerification() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"33").signWith(SignatureAlgorithm.RS256, (Key)this.privateKey33).compact();
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of((Object)"accessToken", (Object)accessToken, (Object)"SSLVerification", (Object)"FULL"));
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123"));
            ResultSet rs = statement.getResultSet();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rs.getLong(1), (long)123L);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSuccessCaSslVerification() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"33").signWith(SignatureAlgorithm.RS256, (Key)this.privateKey33).compact();
        try (Connection connection = this.createConnection((Map<String, String>)ImmutableMap.of((Object)"accessToken", (Object)accessToken, (Object)"SSLVerification", (Object)"CA"));
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("SELECT 123"));
            ResultSet rs = statement.getResultSet();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rs.getLong(1), (long)123L);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testFailedFullSslVerificationWithoutSSL() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createBasicConnection((Map<String, String>)ImmutableMap.of((Object)"SSLVerification", (Object)"FULL"))).isInstanceOf(SQLException.class)).hasMessage("Connection property 'SSLVerification' is not allowed");
    }

    @Test
    public void testFailedCaSslVerificationWithoutSSL() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createBasicConnection((Map<String, String>)ImmutableMap.of((Object)"SSLVerification", (Object)"CA"))).isInstanceOf(SQLException.class)).hasMessage("Connection property 'SSLVerification' is not allowed");
    }

    @Test
    public void testFailedNoneSslVerificationWithSSL() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createConnection((Map<String, String>)ImmutableMap.of((Object)"SSLVerification", (Object)"NONE"))).isInstanceOf(SQLException.class)).hasMessage("Connection property 'SSLTrustStorePath' is not allowed");
    }

    @Test
    public void testFailedNoneSslVerificationWithSSLUnsigned() throws Exception {
        Connection connection = this.createBasicConnection((Map<String, String>)ImmutableMap.of((Object)"SSL", (Object)"true", (Object)"SSLVerification", (Object)"NONE"));
        Statement statement = connection.createStatement();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> statement.execute("SELECT 123")).isInstanceOf(SQLException.class)).hasMessage("Authentication failed: Unauthorized");
    }

    private Connection createConnection(Map<String, String> additionalProperties) throws SQLException {
        String url = String.format("jdbc:presto://localhost:%s", this.server.getHttpsAddress().getPort());
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        properties.setProperty("SSL", "true");
        properties.setProperty("SSLTrustStorePath", Resources.getResource((String)"localhost.truststore").getPath());
        properties.setProperty("SSLTrustStorePassword", "changeit");
        additionalProperties.forEach(properties::setProperty);
        return DriverManager.getConnection(url, properties);
    }

    private Connection createBasicConnection(Map<String, String> additionalProperties) throws SQLException {
        String url = String.format("jdbc:presto://localhost:%s", this.server.getHttpsAddress().getPort());
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        additionalProperties.forEach(properties::setProperty);
        return DriverManager.getConnection(url, properties);
    }
}

