/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.prestosql.client.NodeVersion;
import io.prestosql.client.ServerInfo;
import io.prestosql.jdbc.QueryExecutor;
import java.io.IOException;
import java.util.Optional;
import okhttp3.OkHttpClient;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestQueryExecutor {
    private static final JsonCodec<ServerInfo> SERVER_INFO_CODEC = JsonCodec.jsonCodec(ServerInfo.class);
    private MockWebServer server;

    @BeforeMethod
    public void setup() throws IOException {
        this.server = new MockWebServer();
        this.server.start();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws IOException {
        this.server.close();
    }

    @Test
    public void testGetServerInfo() throws Exception {
        ServerInfo expected = new ServerInfo(NodeVersion.UNKNOWN, "test", true, false, Optional.of(Duration.valueOf((String)"2m")));
        this.server.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json").setBody(SERVER_INFO_CODEC.toJson((Object)expected)));
        QueryExecutor executor = new QueryExecutor(new OkHttpClient());
        ServerInfo actual = executor.getServerInfo(this.server.url("/v1/info").uri());
        Assert.assertEquals((String)actual.getEnvironment(), (String)"test");
        Assert.assertEquals((Object)actual.getUptime(), Optional.of(Duration.valueOf((String)"2m")));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        Assert.assertEquals((String)this.server.takeRequest().getPath(), (String)"/v1/info");
    }
}

