/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;

public final class TestingJdbcUtils {
    private TestingJdbcUtils() {
    }

    public static List<List<Object>> readRows(ResultSet rs) throws SQLException {
        ImmutableList.Builder rows = ImmutableList.builder();
        int columnCount = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 1; i <= columnCount; ++i) {
                row.add(rs.getObject(i));
            }
            rows.add(row);
        }
        return rows.build();
    }

    public static List<List<Object>> readRows(ResultSet rs, List<String> columns) throws SQLException {
        ImmutableList.Builder rows = ImmutableList.builder();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (String column : columns) {
                row.add(rs.getObject(column));
            }
            rows.add(row);
        }
        return rows.build();
    }

    @SafeVarargs
    public static <T> List<T> list(T ... elements) {
        return Arrays.asList(elements);
    }

    @SafeVarargs
    public static <T> T[] array(T ... elements) {
        return elements;
    }

    public static ResultSetAssert assertResultSet(ResultSet resultSet) {
        return new ResultSetAssert(resultSet);
    }

    public static class ResultSetAssert {
        private final ResultSet resultSet;

        public ResultSetAssert(ResultSet resultSet) {
            this.resultSet = Objects.requireNonNull(resultSet, "resultSet is null");
        }

        public ResultSetAssert hasColumnCount(int expectedColumnCount) throws SQLException {
            Assertions.assertThat((int)this.resultSet.getMetaData().getColumnCount()).isEqualTo(expectedColumnCount);
            return this;
        }

        public ResultSetAssert hasColumn(int columnIndex, String name, int sqlType) throws SQLException {
            Assertions.assertThat((String)this.resultSet.getMetaData().getColumnName(columnIndex)).isEqualTo(name);
            Assertions.assertThat((int)this.resultSet.getMetaData().getColumnType(columnIndex)).isEqualTo(sqlType);
            return this;
        }

        public ResultSetAssert hasRows(List<List<?>> expected) throws SQLException {
            Assertions.assertThat(TestingJdbcUtils.readRows(this.resultSet)).isEqualTo(expected);
            return this;
        }
    }
}

