/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import io.prestosql.spi.HostAddress;
import java.io.File;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class KafkaConfig {
    private static final int KAFKA_DEFAULT_PORT = 9092;
    private Set<HostAddress> nodes = ImmutableSet.of();
    private Duration kafkaConnectTimeout = Duration.valueOf((String)"10s");
    private DataSize kafkaBufferSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private String defaultSchema = "default";
    private Set<String> tableNames = ImmutableSet.of();
    private File tableDescriptionDir = new File("etc/kafka/");
    private boolean hideInternalColumns = true;
    private int messagesPerSplit = 100000;

    @Size(min=1)
    public @Size(min=1) Set<HostAddress> getNodes() {
        return this.nodes;
    }

    @Config(value="kafka.nodes")
    @ConfigDescription(value="Seed nodes for Kafka cluster. At least one must exist")
    public KafkaConfig setNodes(String nodes) {
        this.nodes = nodes == null ? null : KafkaConfig.parseNodes(nodes);
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getKafkaConnectTimeout() {
        return this.kafkaConnectTimeout;
    }

    @Config(value="kafka.connect-timeout")
    @ConfigDescription(value="Kafka connection timeout")
    public KafkaConfig setKafkaConnectTimeout(String kafkaConnectTimeout) {
        this.kafkaConnectTimeout = Duration.valueOf((String)kafkaConnectTimeout);
        return this;
    }

    public DataSize getKafkaBufferSize() {
        return this.kafkaBufferSize;
    }

    @Config(value="kafka.buffer-size")
    @ConfigDescription(value="Kafka message consumer buffer size")
    public KafkaConfig setKafkaBufferSize(String kafkaBufferSize) {
        this.kafkaBufferSize = DataSize.valueOf((String)kafkaBufferSize);
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="kafka.default-schema")
    @ConfigDescription(value="Schema name to use in the connector")
    public KafkaConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @NotNull
    public Set<String> getTableNames() {
        return this.tableNames;
    }

    @Config(value="kafka.table-names")
    @ConfigDescription(value="Set of tables known to this connector")
    public KafkaConfig setTableNames(String tableNames) {
        this.tableNames = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)tableNames));
        return this;
    }

    public boolean isHideInternalColumns() {
        return this.hideInternalColumns;
    }

    @Config(value="kafka.hide-internal-columns")
    @ConfigDescription(value="Whether internal columns are shown in table metadata or not. Default is no")
    public KafkaConfig setHideInternalColumns(boolean hideInternalColumns) {
        this.hideInternalColumns = hideInternalColumns;
        return this;
    }

    @NotNull
    public File getTableDescriptionDir() {
        return this.tableDescriptionDir;
    }

    @Config(value="kafka.table-description-dir")
    @ConfigDescription(value="Folder holding JSON description files for Kafka topics")
    public KafkaConfig setTableDescriptionDir(File tableDescriptionDir) {
        this.tableDescriptionDir = tableDescriptionDir;
        return this;
    }

    private static ImmutableSet<HostAddress> parseNodes(String nodes) {
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        return (ImmutableSet)StreamSupport.stream(splitter.split((CharSequence)nodes).spliterator(), false).map(KafkaConfig::toHostAddress).collect(ImmutableSet.toImmutableSet());
    }

    private static HostAddress toHostAddress(String value) {
        return HostAddress.fromString((String)value).withDefaultPort(9092);
    }

    @Min(value=1L)
    public @Min(value=1L) int getMessagesPerSplit() {
        return this.messagesPerSplit;
    }

    @Config(value="kafka.messages-per-split")
    @ConfigDescription(value="Count of Kafka messages to be processed by single Presto Kafka connector split")
    public KafkaConfig setMessagesPerSplit(int messagesPerSplit) {
        this.messagesPerSplit = messagesPerSplit;
        return this;
    }
}

