/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.kafka.KafkaConnector;
import io.prestosql.plugin.kafka.KafkaConnectorModule;
import io.prestosql.plugin.kafka.KafkaHandleResolver;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;

public class KafkaConnectorFactory
implements ConnectorFactory {
    private final Module extension;

    public KafkaConnectorFactory(Module extension) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
    }

    public String getName() {
        return "kafka";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new KafkaHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new KafkaConnectorModule(), this.extension, binder -> {
            binder.bind(ClassLoader.class).toInstance((Object)KafkaConnectorFactory.class.getClassLoader());
            binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(KafkaConnector.class);
    }
}

