/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.google.common.base.Preconditions;
import io.prestosql.plugin.kafka.KafkaColumnHandle;
import io.prestosql.plugin.kafka.KafkaSplit;
import io.prestosql.plugin.kafka.KafkaTableHandle;
import io.prestosql.plugin.kafka.KafkaTransactionHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public class KafkaHandleResolver
implements ConnectorHandleResolver {
    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return KafkaTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return KafkaColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return KafkaSplit.class;
    }

    public Class<? extends ConnectorTransactionHandle> getTransactionHandleClass() {
        return KafkaTransactionHandle.class;
    }

    static KafkaTableHandle convertTableHandle(ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof KafkaTableHandle), (Object)"tableHandle is not an instance of KafkaTableHandle");
        return (KafkaTableHandle)tableHandle;
    }

    static KafkaColumnHandle convertColumnHandle(ColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        Preconditions.checkArgument((boolean)(columnHandle instanceof KafkaColumnHandle), (Object)"columnHandle is not an instance of KafkaColumnHandle");
        return (KafkaColumnHandle)columnHandle;
    }

    static KafkaSplit convertSplit(ConnectorSplit split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)(split instanceof KafkaSplit), (Object)"split is not an instance of KafkaSplit");
        return (KafkaSplit)split;
    }
}

