/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.kafka.KafkaConfig;
import io.prestosql.plugin.kafka.KafkaHandleResolver;
import io.prestosql.plugin.kafka.KafkaInternalFieldDescription;
import io.prestosql.plugin.kafka.KafkaTableHandle;
import io.prestosql.plugin.kafka.KafkaTopicDescription;
import io.prestosql.plugin.kafka.KafkaTopicFieldDescription;
import io.prestosql.plugin.kafka.KafkaTopicFieldGroup;
import io.prestosql.plugin.kafka.TableDescriptionSupplier;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.TableNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;

public class KafkaMetadata
implements ConnectorMetadata {
    private final boolean hideInternalColumns;
    private final Set<TableDescriptionSupplier> tableDescriptions;

    @Inject
    public KafkaMetadata(KafkaConfig kafkaConfig, Set<TableDescriptionSupplier> tableDescriptions) {
        Objects.requireNonNull(kafkaConfig, "kafkaConfig is null");
        this.hideInternalColumns = kafkaConfig.isHideInternalColumns();
        this.tableDescriptions = Objects.requireNonNull(tableDescriptions, "tableDescriptions is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.tableDescriptions.stream().map(TableDescriptionSupplier::listTables).flatMap(Collection::stream).map(SchemaTableName::getSchemaName).collect(ImmutableList.toImmutableList());
    }

    public KafkaTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.getTopicDescription(schemaTableName).map(kafkaTopicDescription -> new KafkaTableHandle(schemaTableName.getSchemaName(), schemaTableName.getTableName(), kafkaTopicDescription.getTopicName(), KafkaMetadata.getDataFormat(kafkaTopicDescription.getKey()), KafkaMetadata.getDataFormat(kafkaTopicDescription.getMessage()), kafkaTopicDescription.getKey().flatMap(KafkaTopicFieldGroup::getDataSchema), kafkaTopicDescription.getMessage().flatMap(KafkaTopicFieldGroup::getDataSchema))).orElse(null);
    }

    private static String getDataFormat(Optional<KafkaTopicFieldGroup> fieldGroup) {
        return fieldGroup.map(KafkaTopicFieldGroup::getDataFormat).orElse("dummy");
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getTableMetadata(KafkaHandleResolver.convertTableHandle(tableHandle).toSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return (List)this.tableDescriptions.stream().map(TableDescriptionSupplier::listTables).flatMap(Collection::stream).filter(tableName -> schemaName.map(tableName.getSchemaName()::equals).orElse(true)).collect(ImmutableList.toImmutableList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        KafkaTableHandle kafkaTableHandle = KafkaHandleResolver.convertTableHandle(tableHandle);
        SchemaTableName schemaTableName = kafkaTableHandle.toSchemaTableName();
        KafkaTopicDescription kafkaTopicDescription = this.getRequiredTopicDescription(schemaTableName);
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        AtomicInteger index = new AtomicInteger(0);
        kafkaTopicDescription.getKey().ifPresent(key -> {
            List<KafkaTopicFieldDescription> fields = key.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields) {
                    columnHandles.put((Object)kafkaTopicFieldDescription.getName(), (Object)kafkaTopicFieldDescription.getColumnHandle(true, index.getAndIncrement()));
                }
            }
        });
        kafkaTopicDescription.getMessage().ifPresent(message -> {
            List<KafkaTopicFieldDescription> fields = message.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields) {
                    columnHandles.put((Object)kafkaTopicFieldDescription.getName(), (Object)kafkaTopicFieldDescription.getColumnHandle(false, index.getAndIncrement()));
                }
            }
        });
        for (KafkaInternalFieldDescription kafkaInternalFieldDescription : KafkaInternalFieldDescription.values()) {
            columnHandles.put((Object)kafkaInternalFieldDescription.getColumnName(), (Object)kafkaInternalFieldDescription.getColumnHandle(index.getAndIncrement(), this.hideInternalColumns));
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        Object tableNames = prefix.getTable().isEmpty() ? this.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)prefix.toSchemaTableName());
        for (SchemaTableName tableName : tableNames) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        KafkaHandleResolver.convertTableHandle(tableHandle);
        return KafkaHandleResolver.convertColumnHandle(columnHandle).getColumnMetadata();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        KafkaTopicDescription table = this.getRequiredTopicDescription(schemaTableName);
        ImmutableList.Builder builder = ImmutableList.builder();
        table.getKey().ifPresent(key -> {
            List<KafkaTopicFieldDescription> fields = key.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription fieldDescription : fields) {
                    builder.add((Object)fieldDescription.getColumnMetadata());
                }
            }
        });
        table.getMessage().ifPresent(message -> {
            List<KafkaTopicFieldDescription> fields = message.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription fieldDescription : fields) {
                    builder.add((Object)fieldDescription.getColumnMetadata());
                }
            }
        });
        for (KafkaInternalFieldDescription fieldDescription : KafkaInternalFieldDescription.values()) {
            builder.add((Object)fieldDescription.getColumnMetadata(this.hideInternalColumns));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    private KafkaTopicDescription getRequiredTopicDescription(SchemaTableName schemaTableName) {
        return this.getTopicDescription(schemaTableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
    }

    private Optional<KafkaTopicDescription> getTopicDescription(SchemaTableName schemaTableName) {
        return this.tableDescriptions.stream().map(kafkaTableDescriptionSupplier -> kafkaTableDescriptionSupplier.getTopicDescription(schemaTableName)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

