/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.decoder.FieldValueProviders;
import io.prestosql.decoder.RowDecoder;
import io.prestosql.plugin.kafka.KafkaColumnHandle;
import io.prestosql.plugin.kafka.KafkaConsumerFactory;
import io.prestosql.plugin.kafka.KafkaInternalFieldDescription;
import io.prestosql.plugin.kafka.KafkaSplit;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;

public class KafkaRecordSet
implements RecordSet {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int CONSUMER_POLL_TIMEOUT = 100;
    private final KafkaSplit split;
    private final KafkaConsumerFactory consumerFactory;
    private final RowDecoder keyDecoder;
    private final RowDecoder messageDecoder;
    private final List<KafkaColumnHandle> columnHandles;
    private final List<Type> columnTypes;

    KafkaRecordSet(KafkaSplit split, KafkaConsumerFactory consumerFactory, List<KafkaColumnHandle> columnHandles, RowDecoder keyDecoder, RowDecoder messageDecoder) {
        this.split = Objects.requireNonNull(split, "split is null");
        this.consumerFactory = Objects.requireNonNull(consumerFactory, "consumerManager is null");
        this.keyDecoder = Objects.requireNonNull(keyDecoder, "rowDecoder is null");
        this.messageDecoder = Objects.requireNonNull(messageDecoder, "rowDecoder is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (DecoderColumnHandle decoderColumnHandle : columnHandles) {
            typeBuilder.add((Object)decoderColumnHandle.getType());
        }
        this.columnTypes = typeBuilder.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new KafkaRecordCursor();
    }

    private class KafkaRecordCursor
    implements RecordCursor {
        private final TopicPartition topicPartition;
        private final KafkaConsumer<byte[], byte[]> kafkaConsumer;
        private Iterator<ConsumerRecord<byte[], byte[]>> records = Collections.emptyIterator();
        private long completedBytes;
        private final FieldValueProvider[] currentRowValues;

        private KafkaRecordCursor() {
            this.currentRowValues = new FieldValueProvider[KafkaRecordSet.this.columnHandles.size()];
            this.topicPartition = new TopicPartition(KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId());
            this.kafkaConsumer = KafkaRecordSet.this.consumerFactory.create();
            this.kafkaConsumer.assign((Collection)ImmutableList.of((Object)this.topicPartition));
            this.kafkaConsumer.seek(this.topicPartition, KafkaRecordSet.this.split.getMessagesRange().getBegin());
        }

        public long getCompletedBytes() {
            return this.completedBytes;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return KafkaRecordSet.this.columnHandles.get(field).getType();
        }

        public boolean advanceNextPosition() {
            if (!this.records.hasNext()) {
                if (this.kafkaConsumer.position(this.topicPartition) >= KafkaRecordSet.this.split.getMessagesRange().getEnd()) {
                    return false;
                }
                this.records = this.kafkaConsumer.poll(100L).iterator();
                return this.advanceNextPosition();
            }
            return this.nextRow(this.records.next());
        }

        private boolean nextRow(ConsumerRecord<byte[], byte[]> message) {
            Objects.requireNonNull(message, "message is null");
            if (message.offset() >= KafkaRecordSet.this.split.getMessagesRange().getEnd()) {
                return false;
            }
            this.completedBytes += (long)(Math.max(message.serializedKeySize(), 0) + Math.max(message.serializedValueSize(), 0));
            byte[] keyData = EMPTY_BYTE_ARRAY;
            if (message.key() != null) {
                keyData = (byte[])message.key();
            }
            byte[] messageData = EMPTY_BYTE_ARRAY;
            if (message.value() != null) {
                messageData = (byte[])message.value();
            }
            HashMap<DecoderColumnHandle, FieldValueProvider> currentRowValuesMap = new HashMap<DecoderColumnHandle, FieldValueProvider>();
            Optional decodedKey = KafkaRecordSet.this.keyDecoder.decodeRow(keyData, null);
            Optional decodedValue = KafkaRecordSet.this.messageDecoder.decodeRow(messageData, null);
            block10: for (DecoderColumnHandle decoderColumnHandle : KafkaRecordSet.this.columnHandles) {
                if (!decoderColumnHandle.isInternal()) continue;
                KafkaInternalFieldDescription fieldDescription = KafkaInternalFieldDescription.forColumnName(decoderColumnHandle.getName());
                switch (fieldDescription) {
                    case PARTITION_OFFSET_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)message.offset()));
                        continue block10;
                    }
                    case MESSAGE_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])messageData));
                        continue block10;
                    }
                    case MESSAGE_LENGTH_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)messageData.length));
                        continue block10;
                    }
                    case KEY_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])keyData));
                        continue block10;
                    }
                    case KEY_LENGTH_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)keyData.length));
                        continue block10;
                    }
                    case KEY_CORRUPT_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.booleanValueProvider((boolean)decodedKey.isEmpty()));
                        continue block10;
                    }
                    case MESSAGE_CORRUPT_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.booleanValueProvider((boolean)decodedValue.isEmpty()));
                        continue block10;
                    }
                    case PARTITION_ID_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)message.partition()));
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("unknown internal field " + fieldDescription);
            }
            decodedKey.ifPresent(currentRowValuesMap::putAll);
            decodedValue.ifPresent(currentRowValuesMap::putAll);
            for (int i = 0; i < KafkaRecordSet.this.columnHandles.size(); ++i) {
                ColumnHandle columnHandle = (ColumnHandle)KafkaRecordSet.this.columnHandles.get(i);
                this.currentRowValues[i] = (FieldValueProvider)currentRowValuesMap.get(columnHandle);
            }
            return true;
        }

        public boolean getBoolean(int field) {
            return this.getFieldValueProvider(field, Boolean.TYPE).getBoolean();
        }

        public long getLong(int field) {
            return this.getFieldValueProvider(field, Long.TYPE).getLong();
        }

        public double getDouble(int field) {
            return this.getFieldValueProvider(field, Double.TYPE).getDouble();
        }

        public Slice getSlice(int field) {
            return this.getFieldValueProvider(field, Slice.class).getSlice();
        }

        public Object getObject(int field) {
            return this.getFieldValueProvider(field, Block.class).getBlock();
        }

        public boolean isNull(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return this.currentRowValues[field] == null || this.currentRowValues[field].isNull();
        }

        private FieldValueProvider getFieldValueProvider(int field, Class<?> expectedType) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            this.checkFieldType(field, expectedType);
            return this.currentRowValues[field];
        }

        private void checkFieldType(int field, Class<?> expected) {
            Class actual = this.getType(field).getJavaType();
            Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object)field, expected, (Object)actual);
        }

        public void close() {
            this.kafkaConsumer.close();
        }
    }
}

