/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.decoder.DispatchingRowDecoderFactory;
import io.prestosql.decoder.RowDecoder;
import io.prestosql.plugin.kafka.KafkaColumnHandle;
import io.prestosql.plugin.kafka.KafkaConsumerFactory;
import io.prestosql.plugin.kafka.KafkaHandleResolver;
import io.prestosql.plugin.kafka.KafkaRecordSet;
import io.prestosql.plugin.kafka.KafkaSplit;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.RecordSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class KafkaRecordSetProvider
implements ConnectorRecordSetProvider {
    private final DispatchingRowDecoderFactory decoderFactory;
    private final KafkaConsumerFactory consumerFactory;

    @Inject
    public KafkaRecordSetProvider(DispatchingRowDecoderFactory decoderFactory, KafkaConsumerFactory consumerFactory) {
        this.decoderFactory = Objects.requireNonNull(decoderFactory, "decoderFactory is null");
        this.consumerFactory = Objects.requireNonNull(consumerFactory, "consumerManager is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        KafkaSplit kafkaSplit = KafkaHandleResolver.convertSplit(split);
        List kafkaColumns = (List)columns.stream().map(KafkaHandleResolver::convertColumnHandle).collect(ImmutableList.toImmutableList());
        RowDecoder keyDecoder = this.decoderFactory.create(kafkaSplit.getKeyDataFormat(), this.getDecoderParameters(kafkaSplit.getKeyDataSchemaContents()), (Set)kafkaColumns.stream().filter(col -> !col.isInternal()).filter(KafkaColumnHandle::isKeyDecoder).collect(ImmutableSet.toImmutableSet()));
        RowDecoder messageDecoder = this.decoderFactory.create(kafkaSplit.getMessageDataFormat(), this.getDecoderParameters(kafkaSplit.getMessageDataSchemaContents()), (Set)kafkaColumns.stream().filter(col -> !col.isInternal()).filter(col -> !col.isKeyDecoder()).collect(ImmutableSet.toImmutableSet()));
        return new KafkaRecordSet(kafkaSplit, this.consumerFactory, kafkaColumns, keyDecoder, messageDecoder);
    }

    private Map<String, String> getDecoderParameters(Optional<String> dataSchema) {
        ImmutableMap.Builder parameters = ImmutableMap.builder();
        dataSchema.ifPresent(schema -> parameters.put((Object)"dataSchema", schema));
        return parameters.build();
    }
}

