/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import io.prestosql.plugin.kafka.KafkaConfig;
import io.prestosql.plugin.kafka.KafkaConsumerFactory;
import io.prestosql.plugin.kafka.KafkaErrorCode;
import io.prestosql.plugin.kafka.KafkaSplit;
import io.prestosql.plugin.kafka.KafkaTableHandle;
import io.prestosql.plugin.kafka.Range;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedSplitSource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class KafkaSplitManager
implements ConnectorSplitManager {
    private final KafkaConsumerFactory consumerFactory;
    private final int messagesPerSplit;

    @Inject
    public KafkaSplitManager(KafkaConsumerFactory consumerFactory, KafkaConfig kafkaConfig) {
        this.consumerFactory = Objects.requireNonNull(consumerFactory, "consumerManager is null");
        this.messagesPerSplit = Objects.requireNonNull(kafkaConfig, "kafkaConfig is null").getMessagesPerSplit();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        FixedSplitSource fixedSplitSource;
        block10: {
            KafkaTableHandle kafkaTableHandle = (KafkaTableHandle)table;
            KafkaConsumer<byte[], byte[]> kafkaConsumer = this.consumerFactory.create();
            try {
                List partitionInfos = kafkaConsumer.partitionsFor(kafkaTableHandle.getTopicName());
                List topicPartitions = (List)partitionInfos.stream().map(KafkaSplitManager::toTopicPartition).collect(ImmutableList.toImmutableList());
                Map partitionBeginOffsets = kafkaConsumer.beginningOffsets((Collection)topicPartitions);
                Map partitionEndOffsets = kafkaConsumer.endOffsets((Collection)topicPartitions);
                ImmutableList.Builder splits = ImmutableList.builder();
                Optional<String> keyDataSchemaContents = kafkaTableHandle.getKeyDataSchemaLocation().map(KafkaSplitManager::readSchema);
                Optional<String> messageDataSchemaContents = kafkaTableHandle.getMessageDataSchemaLocation().map(KafkaSplitManager::readSchema);
                for (PartitionInfo partitionInfo : partitionInfos) {
                    TopicPartition topicPartition = KafkaSplitManager.toTopicPartition(partitionInfo);
                    HostAddress leader = HostAddress.fromParts((String)partitionInfo.leader().host(), (int)partitionInfo.leader().port());
                    new Range((Long)partitionBeginOffsets.get(topicPartition), (Long)partitionEndOffsets.get(topicPartition)).partition(this.messagesPerSplit).stream().map(range -> new KafkaSplit(kafkaTableHandle.getTopicName(), kafkaTableHandle.getKeyDataFormat(), kafkaTableHandle.getMessageDataFormat(), keyDataSchemaContents, messageDataSchemaContents, partitionInfo.partition(), (Range)range, leader)).forEach(arg_0 -> ((ImmutableList.Builder)splits).add(arg_0));
                }
                fixedSplitSource = new FixedSplitSource((Iterable)splits.build());
                if (kafkaConsumer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (kafkaConsumer != null) {
                        try {
                            kafkaConsumer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof PrestoException) {
                        throw e;
                    }
                    throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SPLIT_ERROR, String.format("Cannot list splits for table '%s' reading topic '%s'", kafkaTableHandle.getTableName(), kafkaTableHandle.getTopicName()), (Throwable)e);
                }
            }
            kafkaConsumer.close();
        }
        return fixedSplitSource;
    }

    private static TopicPartition toTopicPartition(PartitionInfo partitionInfo) {
        return new TopicPartition(partitionInfo.topic(), partitionInfo.partition());
    }

    private static String readSchema(String dataSchemaLocation) {
        InputStream inputStream = null;
        try {
            if (KafkaSplitManager.isURI(dataSchemaLocation.trim().toLowerCase(Locale.ENGLISH))) {
                try {
                    inputStream = new URL(dataSchemaLocation).openStream();
                }
                catch (MalformedURLException e) {
                    inputStream = new FileInputStream(dataSchemaLocation);
                }
            } else {
                inputStream = new FileInputStream(dataSchemaLocation);
            }
            String e = CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            try {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Could not parse the Avro schema at: " + dataSchemaLocation, (Throwable)e);
            }
            catch (Throwable throwable) {
                KafkaSplitManager.closeQuietly(inputStream);
                throw throwable;
            }
        }
        KafkaSplitManager.closeQuietly(inputStream);
        return e;
    }

    private static void closeQuietly(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isURI(String location) {
        try {
            URI.create(location);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

