/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.prestosql.plugin.kafka.KafkaTopicFieldGroup;
import java.util.Objects;
import java.util.Optional;

public class KafkaTopicDescription {
    private final String tableName;
    private final String topicName;
    private final Optional<String> schemaName;
    private final Optional<KafkaTopicFieldGroup> key;
    private final Optional<KafkaTopicFieldGroup> message;

    @JsonCreator
    public KafkaTopicDescription(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="schemaName") Optional<String> schemaName, @JsonProperty(value="topicName") String topicName, @JsonProperty(value="key") Optional<KafkaTopicFieldGroup> key, @JsonProperty(value="message") Optional<KafkaTopicFieldGroup> message) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (Object)"tableName is null or is empty");
        this.tableName = tableName;
        this.topicName = Objects.requireNonNull(topicName, "topicName is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.key = Objects.requireNonNull(key, "key is null");
        this.message = Objects.requireNonNull(message, "message is null");
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty
    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public Optional<KafkaTopicFieldGroup> getKey() {
        return this.key;
    }

    @JsonProperty
    public Optional<KafkaTopicFieldGroup> getMessage() {
        return this.message;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("topicName", (Object)this.topicName).add("schemaName", this.schemaName).add("key", this.key).add("message", this.message).toString();
    }
}

