/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.prestosql.plugin.kafka.KafkaColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public final class KafkaTopicFieldDescription {
    private final String name;
    private final Type type;
    private final String mapping;
    private final String comment;
    private final String dataFormat;
    private final String formatHint;
    private final boolean hidden;

    @JsonCreator
    public KafkaTopicFieldDescription(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="mapping") String mapping, @JsonProperty(value="comment") String comment, @JsonProperty(value="dataFormat") String dataFormat, @JsonProperty(value="formatHint") String formatHint, @JsonProperty(value="hidden") boolean hidden) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.type = Objects.requireNonNull(type, "type is null");
        this.mapping = mapping;
        this.comment = comment;
        this.dataFormat = dataFormat;
        this.formatHint = formatHint;
        this.hidden = hidden;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public String getMapping() {
        return this.mapping;
    }

    @JsonProperty
    public String getComment() {
        return this.comment;
    }

    @JsonProperty
    public String getDataFormat() {
        return this.dataFormat;
    }

    @JsonProperty
    public String getFormatHint() {
        return this.formatHint;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    KafkaColumnHandle getColumnHandle(boolean keyDecoder, int index) {
        return new KafkaColumnHandle(index, this.getName(), this.getType(), this.getMapping(), this.getDataFormat(), this.getFormatHint(), keyDecoder, this.isHidden(), false);
    }

    ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.getName()).setType(this.getType()).setComment(Optional.ofNullable(this.getComment())).setHidden(this.isHidden()).build();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.mapping, this.dataFormat, this.formatHint, this.hidden);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaTopicFieldDescription other = (KafkaTopicFieldDescription)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.mapping, other.mapping) && Objects.equals(this.dataFormat, other.dataFormat) && Objects.equals(this.formatHint, other.formatHint) && Objects.equals(this.hidden, other.hidden);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("mapping", (Object)this.mapping).add("dataFormat", (Object)this.dataFormat).add("formatHint", (Object)this.formatHint).add("hidden", this.hidden).toString();
    }
}

