/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import io.airlift.units.DataSize;
import io.prestosql.plugin.kafka.KafkaConfig;
import io.prestosql.plugin.kafka.KafkaConsumerFactory;
import io.prestosql.spi.HostAddress;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

public class PlainTextKafkaConsumerFactory
implements KafkaConsumerFactory {
    private final Set<HostAddress> nodes;
    private final DataSize kafkaBufferSize;

    @Inject
    public PlainTextKafkaConsumerFactory(KafkaConfig kafkaConfig) {
        Objects.requireNonNull(kafkaConfig, "kafkaConfig is null");
        this.nodes = kafkaConfig.getNodes();
        this.kafkaBufferSize = kafkaConfig.getKafkaBufferSize();
    }

    @Override
    public Properties configure() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.nodes.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
        properties.put("key.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("receive.buffer.bytes", Long.toString(this.kafkaBufferSize.toBytes()));
        properties.put("enable.auto.commit", Boolean.toString(false));
        return properties;
    }
}

