/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class Range {
    private final long begin;
    private final long end;

    @JsonCreator
    public Range(@JsonProperty long begin, @JsonProperty long end) {
        this.begin = begin;
        this.end = end;
    }

    @JsonProperty
    public long getBegin() {
        return this.begin;
    }

    @JsonProperty
    public long getEnd() {
        return this.end;
    }

    public List<Range> partition(int partitionSize) {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (long position = this.begin; position <= this.end; position += (long)partitionSize) {
            partitions.add((Object)new Range(position, Math.min(position + (long)partitionSize, this.end)));
        }
        return partitions.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("begin", this.begin).add("end", this.end).toString();
    }
}

