/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.classloader;

import io.prestosql.plugin.base.classloader.ForClassLoaderSafe;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.eventlistener.EventListener;
import io.prestosql.spi.eventlistener.QueryCompletedEvent;
import io.prestosql.spi.eventlistener.QueryCreatedEvent;
import io.prestosql.spi.eventlistener.SplitCompletedEvent;
import java.util.Objects;

public class ClassLoaderSafeEventListener
implements EventListener {
    private final EventListener delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeEventListener(@ForClassLoaderSafe EventListener delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.queryCreated(queryCreatedEvent);
        }
    }

    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.queryCompleted(queryCompletedEvent);
        }
    }

    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.splitCompleted(splitCompletedEvent);
        }
    }
}

