/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.DictionaryId;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.type.TypeRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public abstract class AbstractTestBlock {
    private static final TypeManager TYPE_MANAGER = new TypeRegistry();
    private static final BlockEncodingSerde BLOCK_ENCODING_SERDE = new BlockEncodingManager(TYPE_MANAGER, new BlockEncoding[0]);

    protected <T> void assertBlock(Block block, Supplier<BlockBuilder> newBlockBuilder, T[] expectedValues) {
        this.assertBlockPositions(block, newBlockBuilder, expectedValues);
        this.assertBlockPositions(AbstractTestBlock.copyBlockViaBlockSerde(block), newBlockBuilder, expectedValues);
        this.assertBlockPositions(AbstractTestBlock.copyBlockViaWritePositionTo(block, newBlockBuilder), newBlockBuilder, expectedValues);
        if (expectedValues.getClass().getComponentType().isArray() || expectedValues.getClass().getComponentType() == List.class || expectedValues.getClass().getComponentType() == Map.class) {
            this.assertBlockPositions(AbstractTestBlock.copyBlockViaWriteStructure(block, newBlockBuilder), newBlockBuilder, expectedValues);
        }
        this.assertBlockSize(block);
        this.assertRetainedSize(block);
        try {
            block.isNull(-1);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            block.isNull(block.getPositionCount());
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertRetainedSize(Block block) {
        long retainedSize = ClassLayout.parseClass(block.getClass()).instanceSize();
        Field[] fields = block.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                Class<?> type;
                if (Modifier.isStatic(field.getModifiers()) || (type = field.getType()).isPrimitive()) continue;
                field.setAccessible(true);
                if (type == Slice.class) {
                    Slice slice = (Slice)field.get(block);
                    if (slice == null) continue;
                    retainedSize += slice.getRetainedSize();
                    continue;
                }
                if (type == BlockBuilderStatus.class) {
                    if (field.get(block) == null) continue;
                    retainedSize += (long)BlockBuilderStatus.INSTANCE_SIZE;
                    continue;
                }
                if (type == BlockBuilder.class || type == Block.class) {
                    retainedSize += ((Block)field.get(block)).getRetainedSizeInBytes();
                    continue;
                }
                if (type == BlockBuilder[].class || type == Block[].class) {
                    Block[] blocks;
                    for (Block innerBlock : blocks = (Block[])field.get(block)) {
                        this.assertRetainedSize(innerBlock);
                        retainedSize += innerBlock.getRetainedSizeInBytes();
                    }
                    continue;
                }
                if (type == SliceOutput.class) {
                    retainedSize += ((SliceOutput)field.get(block)).getRetainedSize();
                    continue;
                }
                if (type == int[].class) {
                    retainedSize += SizeOf.sizeOf((int[])((int[])field.get(block)));
                    continue;
                }
                if (type == boolean[].class) {
                    retainedSize += SizeOf.sizeOf((boolean[])((boolean[])field.get(block)));
                    continue;
                }
                if (type == byte[].class) {
                    retainedSize += SizeOf.sizeOf((byte[])((byte[])field.get(block)));
                    continue;
                }
                if (type == long[].class) {
                    retainedSize += SizeOf.sizeOf((long[])((long[])field.get(block)));
                    continue;
                }
                if (type == short[].class) {
                    retainedSize += SizeOf.sizeOf((short[])((short[])field.get(block)));
                    continue;
                }
                if (type == DictionaryId.class) {
                    retainedSize += (long)ClassLayout.parseClass(DictionaryId.class).instanceSize();
                    continue;
                }
                if (type == MethodHandle.class) continue;
                throw new IllegalArgumentException(String.format("Unknown type encountered: %s", type));
            }
        }
        catch (IllegalAccessException t) {
            throw new RuntimeException(t);
        }
        Assert.assertEquals((long)block.getRetainedSizeInBytes(), (long)retainedSize);
    }

    protected <T> void assertBlockFilteredPositions(T[] expectedValues, Block block, Supplier<BlockBuilder> newBlockBuilder, int ... positions) {
        Block filteredBlock = block.copyPositions(positions, 0, positions.length);
        T[] filteredExpectedValues = AbstractTestBlock.filter(expectedValues, positions);
        Assert.assertEquals((int)filteredBlock.getPositionCount(), (int)positions.length);
        this.assertBlock(filteredBlock, newBlockBuilder, filteredExpectedValues);
    }

    private static <T> T[] filter(T[] expectedValues, int[] positions) {
        Object[] prunedExpectedValues = (Object[])Array.newInstance(expectedValues.getClass().getComponentType(), positions.length);
        for (int i = 0; i < prunedExpectedValues.length; ++i) {
            prunedExpectedValues[i] = expectedValues[positions[i]];
        }
        return prunedExpectedValues;
    }

    private <T> void assertBlockPositions(Block block, Supplier<BlockBuilder> newBlockBuilder, T[] expectedValues) {
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.assertBlockPosition(block, newBlockBuilder, position, expectedValues[position], expectedValues.getClass().getComponentType());
        }
    }

    protected List<Block> splitBlock(Block block, int count) {
        double sizePerSplit = (double)block.getPositionCount() * 1.0 / (double)count;
        ImmutableList.Builder result = ImmutableList.builder();
        for (int i = 0; i < count; ++i) {
            int startPosition = Math.toIntExact(Math.round(sizePerSplit * (double)i));
            int endPosition = Math.toIntExact(Math.round(sizePerSplit * (double)(i + 1)));
            result.add((Object)block.getRegion(startPosition, endPosition - startPosition));
        }
        return result.build();
    }

    private void assertBlockSize(Block block) {
        long expectedBlockSize = AbstractTestBlock.copyBlockViaBlockSerde(block).getSizeInBytes();
        Assert.assertEquals((long)block.getSizeInBytes(), (long)expectedBlockSize);
        Assert.assertEquals((long)block.getRegionSizeInBytes(0, block.getPositionCount()), (long)expectedBlockSize);
        List<Block> splitBlock = this.splitBlock(block, 2);
        Block firstHalf = splitBlock.get(0);
        long expectedFirstHalfSize = AbstractTestBlock.copyBlockViaBlockSerde(firstHalf).getSizeInBytes();
        Assert.assertEquals((long)firstHalf.getSizeInBytes(), (long)expectedFirstHalfSize);
        Assert.assertEquals((long)block.getRegionSizeInBytes(0, firstHalf.getPositionCount()), (long)expectedFirstHalfSize);
        Block secondHalf = splitBlock.get(1);
        long expectedSecondHalfSize = AbstractTestBlock.copyBlockViaBlockSerde(secondHalf).getSizeInBytes();
        Assert.assertEquals((long)secondHalf.getSizeInBytes(), (long)expectedSecondHalfSize);
        Assert.assertEquals((long)block.getRegionSizeInBytes(firstHalf.getPositionCount(), secondHalf.getPositionCount()), (long)expectedSecondHalfSize);
        boolean[] positions = new boolean[block.getPositionCount()];
        Arrays.fill(positions, 0, firstHalf.getPositionCount(), true);
        Assert.assertEquals((long)block.getPositionsSizeInBytes(positions), (long)expectedFirstHalfSize);
        Arrays.fill(positions, true);
        Assert.assertEquals((long)block.getPositionsSizeInBytes(positions), (long)expectedBlockSize);
        Arrays.fill(positions, 0, firstHalf.getPositionCount(), false);
        Assert.assertEquals((long)block.getPositionsSizeInBytes(positions), (long)expectedSecondHalfSize);
    }

    protected <T> void assertBlockPosition(Block block, Supplier<BlockBuilder> newBlockBuilder, int position, T expectedValue, Class<?> expectedValueType) {
        this.assertPositionValue(block, position, expectedValue);
        this.assertPositionValue(block.getSingleValueBlock(position), 0, expectedValue);
        this.assertPositionValue(block.getRegion(position, 1), 0, expectedValue);
        this.assertPositionValue(block.getRegion(0, position + 1), position, expectedValue);
        this.assertPositionValue(block.getRegion(position, block.getPositionCount() - position), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaBlockSerde(block.getRegion(position, 1)), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaBlockSerde(block.getRegion(0, position + 1)), position, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaBlockSerde(block.getRegion(position, block.getPositionCount() - position)), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaWritePositionTo(block.getRegion(position, 1), newBlockBuilder), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaWritePositionTo(block.getRegion(0, position + 1), newBlockBuilder), position, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaWritePositionTo(block.getRegion(position, block.getPositionCount() - position), newBlockBuilder), 0, expectedValue);
        if (expectedValueType.isArray() || expectedValueType == List.class || expectedValueType == Map.class) {
            this.assertPositionValue(AbstractTestBlock.copyBlockViaWriteStructure(block.getRegion(position, 1), newBlockBuilder), 0, expectedValue);
            this.assertPositionValue(AbstractTestBlock.copyBlockViaWriteStructure(block.getRegion(0, position + 1), newBlockBuilder), position, expectedValue);
            this.assertPositionValue(AbstractTestBlock.copyBlockViaWriteStructure(block.getRegion(position, block.getPositionCount() - position), newBlockBuilder), 0, expectedValue);
        }
        this.assertPositionValue(block.copyRegion(position, 1), 0, expectedValue);
        this.assertPositionValue(block.copyRegion(0, position + 1), position, expectedValue);
        this.assertPositionValue(block.copyRegion(position, block.getPositionCount() - position), 0, expectedValue);
        this.assertPositionValue(block.copyPositions(new int[]{position}, 0, 1), 0, expectedValue);
    }

    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assert.assertTrue((boolean)block.isNull(position));
            return;
        }
        Assert.assertFalse((boolean)block.isNull(position));
        if (expectedValue instanceof Slice) {
            int offset;
            Slice expectedSliceValue = (Slice)expectedValue;
            if (this.isByteAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 1; ++offset) {
                    Assert.assertEquals((byte)block.getByte(position, offset), (byte)expectedSliceValue.getByte(offset));
                }
            }
            if (this.isShortAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 2; ++offset) {
                    Assert.assertEquals((short)block.getShort(position, offset), (short)expectedSliceValue.getShort(offset));
                }
            }
            if (this.isIntAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 4; ++offset) {
                    Assert.assertEquals((int)block.getInt(position, offset), (int)expectedSliceValue.getInt(offset));
                }
            }
            if (this.isLongAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 8; ++offset) {
                    Assert.assertEquals((long)block.getLong(position, offset), (long)expectedSliceValue.getLong(offset));
                }
            }
            if (this.isAlignedLongAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 8; offset += 8) {
                    Assert.assertEquals((long)block.getLong(position, offset), (long)expectedSliceValue.getLong(offset));
                }
            }
            if (this.isSliceAccessSupported()) {
                Assert.assertEquals((int)block.getSliceLength(position), (int)expectedSliceValue.length());
                this.assertSlicePosition(block, position, expectedSliceValue);
            }
        } else if (expectedValue instanceof long[]) {
            Block actual = (Block)block.getObject(position, Block.class);
            long[] expected = (long[])expectedValue;
            Assert.assertEquals((int)actual.getPositionCount(), (int)expected.length);
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertEquals((long)BigintType.BIGINT.getLong(actual, i), (long)expected[i]);
            }
        } else if (expectedValue instanceof Slice[]) {
            Block actual = (Block)block.getObject(position, Block.class);
            Slice[] expected = (Slice[])expectedValue;
            Assert.assertEquals((int)actual.getPositionCount(), (int)expected.length);
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice(actual, i), (Object)expected[i]);
            }
        } else if (expectedValue instanceof long[][]) {
            Block actual = (Block)block.getObject(position, Block.class);
            long[][] expected = (long[][])expectedValue;
            Assert.assertEquals((int)actual.getPositionCount(), (int)expected.length);
            for (int i = 0; i < expected.length; ++i) {
                this.assertPositionValue(actual, i, expected[i]);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void assertSlicePosition(Block block, int position, Slice expectedSliceValue) {
        int length = block.getSliceLength(position);
        Assert.assertEquals((int)length, (int)expectedSliceValue.length());
        Block expectedBlock = AbstractTestBlock.toSingeValuedBlock(expectedSliceValue);
        for (int offset = 0; offset < length - 3; ++offset) {
            Assert.assertEquals((Object)block.getSlice(position, offset, 3), (Object)expectedSliceValue.slice(offset, 3));
            Assert.assertTrue((boolean)block.bytesEqual(position, offset, expectedSliceValue, offset, 3));
            Assert.assertFalse((boolean)block.bytesEqual(position, offset, Slices.utf8Slice((String)"XXX"), 0, 3));
            Assert.assertEquals((int)block.bytesCompare(position, offset, 3, expectedSliceValue, offset, 3), (int)0);
            Assert.assertTrue((block.bytesCompare(position, offset, 3, expectedSliceValue, offset, 2) > 0 ? 1 : 0) != 0);
            Slice greaterSlice = AbstractTestBlock.createGreaterValue(expectedSliceValue, offset, 3);
            Assert.assertTrue((block.bytesCompare(position, offset, 3, greaterSlice, 0, greaterSlice.length()) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)block.equals(position, offset, expectedBlock, 0, offset, 3));
            Assert.assertEquals((int)block.compareTo(position, offset, 3, expectedBlock, 0, offset, 3), (int)0);
            BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
            block.writeBytesTo(position, offset, 3, blockBuilder);
            blockBuilder.closeEntry();
            Block segment = blockBuilder.build();
            Assert.assertTrue((boolean)block.equals(position, offset, segment, 0, 0, 3));
        }
    }

    protected boolean isByteAccessSupported() {
        return true;
    }

    protected boolean isShortAccessSupported() {
        return true;
    }

    protected boolean isIntAccessSupported() {
        return true;
    }

    protected boolean isLongAccessSupported() {
        return true;
    }

    protected boolean isAlignedLongAccessSupported() {
        return false;
    }

    protected boolean isSliceAccessSupported() {
        return true;
    }

    private static Block copyBlockViaBlockSerde(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        BLOCK_ENCODING_SERDE.writeBlock((SliceOutput)sliceOutput, block);
        return BLOCK_ENCODING_SERDE.readBlock((SliceInput)sliceOutput.slice().getInput());
    }

    private static Block copyBlockViaWritePositionTo(Block block, Supplier<BlockBuilder> newBlockBuilder) {
        BlockBuilder blockBuilder = newBlockBuilder.get();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                blockBuilder.appendNull();
                continue;
            }
            block.writePositionTo(i, blockBuilder);
        }
        return blockBuilder.build();
    }

    private static Block copyBlockViaWriteStructure(Block block, Supplier<BlockBuilder> newBlockBuilder) {
        BlockBuilder blockBuilder = newBlockBuilder.get();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.appendStructure((Block)block.getObject(i, Block.class));
        }
        return blockBuilder.build();
    }

    private static Block toSingeValuedBlock(Slice expectedValue) {
        BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1, expectedValue.length());
        VarbinaryType.VARBINARY.writeSlice(blockBuilder, expectedValue);
        return blockBuilder.build();
    }

    private static Slice createGreaterValue(Slice expectedValue, int offset, int length) {
        DynamicSliceOutput greaterOutput = new DynamicSliceOutput(length + 1);
        greaterOutput.writeBytes(expectedValue, offset, length);
        greaterOutput.writeByte(95);
        return greaterOutput.slice();
    }

    protected static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = AbstractTestBlock.createExpectedValue(position);
        }
        return expectedValues;
    }

    protected static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }

    protected static <T> T[] alternatingNullValues(T[] objects) {
        T[] objectsWithNulls = Arrays.copyOf(objects, objects.length * 2 + 1);
        for (int i = 0; i < objects.length; ++i) {
            objectsWithNulls[i * 2] = null;
            objectsWithNulls[i * 2 + 1] = objects[i];
        }
        objectsWithNulls[objectsWithNulls.length - 1] = null;
        return objectsWithNulls;
    }

    protected static Slice[] createExpectedUniqueValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = Slices.copyOf((Slice)AbstractTestBlock.createExpectedValue(position));
        }
        return expectedValues;
    }

    protected static void assertEstimatedDataSizeForStats(BlockBuilder blockBuilder, Slice[] expectedSliceValues) {
        Block block = blockBuilder.build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedSliceValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = expectedSliceValues[i] == null ? 0 : expectedSliceValues[i].length();
            Assert.assertEquals((long)blockBuilder.getEstimatedDataSizeForStats(i), (long)expectedSize);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
        BlockBuilder nullValueBlockBuilder = blockBuilder.newBlockBuilderLike(null).appendNull();
        Assert.assertEquals((long)nullValueBlockBuilder.getEstimatedDataSizeForStats(0), (long)0L);
        Assert.assertEquals((long)nullValueBlockBuilder.build().getEstimatedDataSizeForStats(0), (long)0L);
    }

    protected static void testCopyRegionCompactness(Block block) {
        AbstractTestBlock.assertCompact(block.copyRegion(0, block.getPositionCount()));
        if (block.getPositionCount() > 0) {
            AbstractTestBlock.assertCompact(block.copyRegion(0, block.getPositionCount() - 1));
            AbstractTestBlock.assertCompact(block.copyRegion(1, block.getPositionCount() - 1));
        }
    }

    protected static void assertCompact(Block block) {
        Assert.assertSame((Object)block.copyRegion(0, block.getPositionCount()), (Object)block);
    }

    protected static void assertNotCompact(Block block) {
        Assert.assertNotSame((Object)block.copyRegion(0, block.getPositionCount()), (Object)block);
    }

    protected static void testCompactBlock(Block block) {
        AbstractTestBlock.assertCompact(block);
        AbstractTestBlock.testCopyRegionCompactness(block);
    }

    protected static void testIncompactBlock(Block block) {
        AbstractTestBlock.assertNotCompact(block);
        AbstractTestBlock.testCopyRegionCompactness(block);
    }

    static {
        new FunctionRegistry(TYPE_MANAGER, (BlockEncodingSerde)new BlockEncodingManager(TYPE_MANAGER, new BlockEncoding[0]), new FeaturesConfig());
    }
}

