/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.block.ColumnarTestUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.ColumnarMap;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.MapBlockBuilder;
import io.prestosql.spi.block.MethodHandleUtil;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColumnarMap {
    private static final int[] MAP_SIZES = new int[]{16, 0, 13, 1, 2, 11, 4, 7};

    @Test
    public void test() {
        Slice[][][] expectedValues = new Slice[MAP_SIZES.length][][];
        for (int mapIndex = 0; mapIndex < MAP_SIZES.length; ++mapIndex) {
            expectedValues[mapIndex] = new Slice[MAP_SIZES[mapIndex]][];
            for (int entryIndex = 0; entryIndex < MAP_SIZES[mapIndex]; ++entryIndex) {
                Slice[] entry = new Slice[2];
                entry[0] = Slices.utf8Slice((String)String.format("key.%d.%d", mapIndex, entryIndex));
                if (entryIndex % 3 != 1) {
                    entry[1] = Slices.utf8Slice((String)String.format("value.%d.%d", mapIndex, entryIndex));
                }
                expectedValues[mapIndex][entryIndex] = entry;
            }
        }
        BlockBuilder blockBuilder = TestColumnarMap.createBlockBuilderWithValues(expectedValues);
        TestColumnarMap.verifyBlock((Block)blockBuilder, expectedValues);
        TestColumnarMap.verifyBlock(blockBuilder.build(), expectedValues);
        Slice[][][] expectedValuesWithNull = (Slice[][][])ColumnarTestUtils.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestColumnarMap.createBlockBuilderWithValues(expectedValuesWithNull);
        TestColumnarMap.verifyBlock((Block)blockBuilderWithNull, expectedValuesWithNull);
        TestColumnarMap.verifyBlock(blockBuilderWithNull.build(), expectedValuesWithNull);
    }

    private static void verifyBlock(Block block, Slice[][][] expectedValues) {
        ColumnarTestUtils.assertBlock(block, expectedValues);
        TestColumnarMap.assertColumnarMap(block, expectedValues);
        TestColumnarMap.assertDictionaryBlock(block, expectedValues);
        TestColumnarMap.assertRunLengthEncodedBlock(block, expectedValues);
        int offset = 1;
        int length = expectedValues.length - 2;
        Block blockRegion = block.getRegion(offset, length);
        Slice[][][] expectedValuesRegion = (Slice[][][])Arrays.copyOfRange(expectedValues, offset, offset + length);
        ColumnarTestUtils.assertBlock(blockRegion, expectedValuesRegion);
        TestColumnarMap.assertColumnarMap(blockRegion, expectedValuesRegion);
        TestColumnarMap.assertDictionaryBlock(blockRegion, expectedValuesRegion);
        TestColumnarMap.assertRunLengthEncodedBlock(blockRegion, expectedValuesRegion);
    }

    private static void assertDictionaryBlock(Block block, Slice[][][] expectedValues) {
        DictionaryBlock dictionaryBlock = ColumnarTestUtils.createTestDictionaryBlock(block);
        Slice[][][] expectedDictionaryValues = (Slice[][][])ColumnarTestUtils.createTestDictionaryExpectedValues(expectedValues);
        ColumnarTestUtils.assertBlock((Block)dictionaryBlock, expectedDictionaryValues);
        TestColumnarMap.assertColumnarMap((Block)dictionaryBlock, expectedDictionaryValues);
        TestColumnarMap.assertRunLengthEncodedBlock((Block)dictionaryBlock, expectedDictionaryValues);
    }

    private static void assertRunLengthEncodedBlock(Block block, Slice[][][] expectedValues) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            RunLengthEncodedBlock runLengthEncodedBlock = ColumnarTestUtils.createTestRleBlock(block, position);
            Slice[][][] expectedDictionaryValues = (Slice[][][])ColumnarTestUtils.createTestRleExpectedValues(expectedValues, position);
            ColumnarTestUtils.assertBlock((Block)runLengthEncodedBlock, expectedDictionaryValues);
            TestColumnarMap.assertColumnarMap((Block)runLengthEncodedBlock, expectedDictionaryValues);
        }
    }

    private static void assertColumnarMap(Block block, Slice[][][] expectedValues) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        Assert.assertEquals((int)columnarMap.getPositionCount(), (int)expectedValues.length);
        Block keysBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        int keysPosition = 0;
        int valuesPosition = 0;
        for (int position = 0; position < expectedValues.length; ++position) {
            Slice[][] expectedMap = expectedValues[position];
            Assert.assertEquals((boolean)columnarMap.isNull(position), (expectedMap == null ? 1 : 0) != 0);
            if (expectedMap == null) {
                Assert.assertEquals((int)columnarMap.getEntryCount(position), (int)0);
                continue;
            }
            Assert.assertEquals((int)columnarMap.getEntryCount(position), (int)expectedMap.length);
            for (int i = 0; i < columnarMap.getEntryCount(position); ++i) {
                Slice[] expectedEntry = expectedMap[i];
                Slice expectedKey = expectedEntry[0];
                ColumnarTestUtils.assertBlockPosition(keysBlock, keysPosition, expectedKey);
                ++keysPosition;
                Slice expectedValue = expectedEntry[1];
                ColumnarTestUtils.assertBlockPosition(valuesBlock, valuesPosition, expectedValue);
                ++valuesPosition;
            }
        }
    }

    public static BlockBuilder createBlockBuilderWithValues(Slice[][][] expectedValues) {
        BlockBuilder blockBuilder = TestColumnarMap.createMapBuilder(100);
        for (Slice[][] expectedMap : expectedValues) {
            if (expectedMap == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
            VarcharType.VARCHAR.createBlockBuilder(null, expectedMap.length);
            for (Slice[] entry : expectedMap) {
                Slice key = entry[0];
                Assert.assertNotNull((Object)key);
                VarcharType.VARCHAR.writeSlice(entryBuilder, key);
                Slice value = entry[1];
                if (value == null) {
                    entryBuilder.appendNull();
                    continue;
                }
                VarcharType.VARCHAR.writeSlice(entryBuilder, value);
            }
            blockBuilder.closeEntry();
        }
        return blockBuilder;
    }

    private static BlockBuilder createMapBuilder(int expectedEntries) {
        MethodHandle varcharNativeEquals = MethodHandleUtil.methodHandle(Slice.class, (String)"equals", (Class[])new Class[]{Object.class}).asType(MethodType.methodType(Boolean.TYPE, Slice.class, Slice.class));
        MethodHandle varcharBlockNativeEquals = MethodHandleUtil.compose((MethodHandle)varcharNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)VarcharType.VARCHAR));
        MethodHandle varcharBlockEquals = MethodHandleUtil.compose((MethodHandle)varcharNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)VarcharType.VARCHAR), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)VarcharType.VARCHAR));
        return new MapBlockBuilder((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, varcharBlockNativeEquals, varcharBlockEquals, MethodHandleUtil.methodHandle(Slice.class, (String)"hashCode", (Class[])new Class[0]).asType(MethodType.methodType(Long.TYPE, Slice.class)), MethodHandleUtil.methodHandle(TestColumnarMap.class, (String)"blockVarcharHashCode", (Class[])new Class[]{Block.class, Integer.TYPE}), null, expectedEntries);
    }

    public static long blockVarcharHashCode(Block block, int position) {
        return block.hash(position, 0, block.getSliceLength(position));
    }
}

