/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.prestosql.block.AbstractTestBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.ByteArrayBlock;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.block.RowBlockBuilder;
import io.prestosql.spi.block.SingleRowBlock;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowBlock
extends AbstractTestBlock {
    @Test
    void testWithVarcharBigint() {
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        List<Object>[] testRows = this.generateTestRows((List<Type>)fieldTypes, 100);
        this.testWith((List<Type>)fieldTypes, testRows);
        this.testWith((List<Type>)fieldTypes, TestRowBlock.alternatingNullValues(testRows));
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        List<Object>[] expectedValues = TestRowBlock.alternatingNullValues(this.generateTestRows((List<Type>)fieldTypes, 100));
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues((List<Type>)fieldTypes, expectedValues);
        Block block = blockBuilder.build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = this.getExpectedEstimatedDataSize(expectedValues[i]);
            Assert.assertEquals((long)blockBuilder.getEstimatedDataSizeForStats(i), (long)expectedSize);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
    }

    private int getExpectedEstimatedDataSize(List<Object> row) {
        if (row == null) {
            return 0;
        }
        int size = 0;
        size += row.get(0) == null ? 0 : ((String)row.get(0)).length();
        return size += row.get(1) == null ? 0 : 8;
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactFieldBlock1 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(5).getBytes());
        ByteArrayBlock compactFieldBlock2 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(5).getBytes());
        ByteArrayBlock incompactFiledBlock1 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(6).getBytes());
        ByteArrayBlock incompactFiledBlock2 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(6).getBytes());
        boolean[] rowIsNull = new boolean[]{false, true, false, false, false, false};
        TestRowBlock.assertCompact(RowBlock.fromFieldBlocks((int)0, Optional.empty(), (Block[])new Block[]{emptyBlock, emptyBlock}));
        TestRowBlock.assertCompact(RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{compactFieldBlock1, compactFieldBlock2}));
        TestRowBlock.testIncompactBlock(RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{incompactFiledBlock1, incompactFiledBlock2}));
        TestRowBlock.testIncompactBlock(RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{incompactFiledBlock1, incompactFiledBlock2}));
    }

    private void testWith(List<Type> fieldTypes, List<Object>[] expectedValues) {
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(fieldTypes, expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        IntArrayList positionList = this.generatePositionList(expectedValues.length, expectedValues.length / 2);
        this.assertBlockFilteredPositions(expectedValues, (Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), positionList.toIntArray());
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), positionList.toIntArray());
    }

    private BlockBuilder createBlockBuilderWithValues(List<Type> fieldTypes, List<Object>[] rows) {
        RowBlockBuilder rowBlockBuilder = new RowBlockBuilder(fieldTypes, null, 1);
        for (List<Object> row : rows) {
            if (row == null) {
                rowBlockBuilder.appendNull();
                continue;
            }
            BlockBuilder singleRowBlockWriter = rowBlockBuilder.beginBlockEntry();
            for (Object fieldValue : row) {
                if (fieldValue == null) {
                    singleRowBlockWriter.appendNull();
                    continue;
                }
                if (fieldValue instanceof Long) {
                    BigintType.BIGINT.writeLong(singleRowBlockWriter, ((Long)fieldValue).longValue());
                    continue;
                }
                if (fieldValue instanceof String) {
                    VarcharType.VARCHAR.writeSlice(singleRowBlockWriter, Slices.utf8Slice((String)((String)fieldValue)));
                    continue;
                }
                throw new IllegalArgumentException();
            }
            rowBlockBuilder.closeEntry();
        }
        return rowBlockBuilder;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue instanceof List) {
            this.assertValue(block, position, (List)expectedValue);
            return;
        }
        super.assertPositionValue(block, position, expectedValue);
    }

    private void assertValue(Block rowBlock, int position, List<Object> row) {
        Objects.requireNonNull(row, "row is null");
        Assert.assertFalse((boolean)rowBlock.isNull(position));
        SingleRowBlock singleRowBlock = (SingleRowBlock)rowBlock.getObject(position, Block.class);
        Assert.assertEquals((int)singleRowBlock.getPositionCount(), (int)row.size());
        for (int i = 0; i < row.size(); ++i) {
            Object fieldValue = row.get(i);
            if (fieldValue == null) {
                Assert.assertTrue((boolean)singleRowBlock.isNull(i));
                continue;
            }
            if (fieldValue instanceof Long) {
                Assert.assertEquals((long)BigintType.BIGINT.getLong((Block)singleRowBlock, i), (long)((Long)fieldValue));
                continue;
            }
            if (fieldValue instanceof String) {
                Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice((Block)singleRowBlock, i), (Object)Slices.utf8Slice((String)((String)fieldValue)));
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private List<Object>[] generateTestRows(List<Type> fieldTypes, int numRows) {
        List[] testRows = new List[numRows];
        for (int i = 0; i < numRows; ++i) {
            ArrayList<Object> testRow = new ArrayList<Object>(fieldTypes.size());
            for (int j = 0; j < fieldTypes.size(); ++j) {
                int cellId = i * fieldTypes.size() + j;
                if (cellId % 7 == 3) {
                    testRow.add(null);
                    continue;
                }
                if (fieldTypes.get(j) == BigintType.BIGINT) {
                    testRow.add((long)i * 100L + (long)j);
                    continue;
                }
                if (fieldTypes.get(j) == VarcharType.VARCHAR) {
                    testRow.add(String.format("field(%s, %s)", i, j));
                    continue;
                }
                throw new IllegalArgumentException();
            }
            testRows[i] = testRow;
        }
        return testRows;
    }

    private IntArrayList generatePositionList(int numRows, int numPositions) {
        IntArrayList positions = new IntArrayList(numPositions);
        for (int i = 0; i < numPositions; ++i) {
            positions.add((7 * i + 3) % numRows);
        }
        Collections.sort(positions);
        return positions;
    }
}

