/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchHandleResolver;
import io.prestosql.plugin.tpch.TpchRecordSetProvider;
import io.prestosql.plugin.tpch.TpchSplitManager;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTableLayoutResult;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.transaction.IsolationLevel;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.TestingHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;

public class MockConnectorFactory
implements ConnectorFactory {
    private final Function<ConnectorSession, List<String>> listSchemaNames;
    private final BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
    private final BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles;

    private MockConnectorFactory(Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles) {
        this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
        this.listTables = Objects.requireNonNull(listTables, "listTables is null");
        this.getViews = Objects.requireNonNull(getViews, "getViews is null");
        this.getColumnHandles = Objects.requireNonNull(getColumnHandles, "getColumnHandles is null");
    }

    public String getName() {
        return "mock";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpchHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        return new MockConnector(context, this.listSchemaNames, this.listTables, this.getViews, this.getColumnHandles);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Function<ConnectorSession, List<String>> listSchemaNames = session -> ImmutableList.of();
        private BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables = (session, schemaName) -> ImmutableList.of();
        private BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews = (session, schemaTablePrefix) -> ImmutableMap.of();
        private BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles = (session, tableHandle) -> (Map)Builder.notSupported();

        public Builder withListSchemaNames(Function<ConnectorSession, List<String>> listSchemaNames) {
            this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
            return this;
        }

        public Builder withListTables(BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables) {
            this.listTables = Objects.requireNonNull(listTables, "listTables is null");
            return this;
        }

        public Builder withGetViews(BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews) {
            this.getViews = Objects.requireNonNull(getViews, "getViews is null");
            return this;
        }

        public Builder withGetColumnHandles(BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles) {
            this.getColumnHandles = Objects.requireNonNull(getColumnHandles, "getColumnHandles is null");
            return this;
        }

        public MockConnectorFactory build() {
            return new MockConnectorFactory(this.listSchemaNames, this.listTables, this.getViews, this.getColumnHandles);
        }

        private static <T> T notSupported() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MockConnector
    implements Connector {
        private final ConnectorContext context;
        private final Function<ConnectorSession, List<String>> listSchemaNames;
        private final BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables;
        private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
        private final BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles;

        public MockConnector(ConnectorContext context, Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, BiFunction<ConnectorSession, ConnectorTableHandle, Map<String, TpchColumnHandle>> getColumnHandles) {
            this.context = Objects.requireNonNull(context, "context is null");
            this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
            this.listTables = Objects.requireNonNull(listTables, "listTables is null");
            this.getViews = Objects.requireNonNull(getViews, "getViews is null");
            this.getColumnHandles = Objects.requireNonNull(getColumnHandles, "getColumnHandles is null");
        }

        public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
            return new ConnectorTransactionHandle(){};
        }

        public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
            return new MockConnectorMetadata();
        }

        public ConnectorSplitManager getSplitManager() {
            return new TpchSplitManager(this.context.getNodeManager(), 1);
        }

        public ConnectorRecordSetProvider getRecordSetProvider() {
            return new TpchRecordSetProvider();
        }

        private class MockConnectorMetadata
        implements ConnectorMetadata {
            private MockConnectorMetadata() {
            }

            public List<String> listSchemaNames(ConnectorSession session) {
                return (List)MockConnector.this.listSchemaNames.apply(session);
            }

            public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
                return new ConnectorTableHandle(){};
            }

            public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
                return null;
            }

            public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
                return (List)MockConnector.this.listTables.apply(session, schemaName.orElse(null));
            }

            public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
                return (Map)MockConnector.this.getColumnHandles.apply(session, tableHandle);
            }

            public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
                TpchColumnHandle tpchColumnHandle = (TpchColumnHandle)columnHandle;
                return new ColumnMetadata(tpchColumnHandle.getColumnName(), tpchColumnHandle.getType());
            }

            public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
                return (Map)this.listTables(session, prefix.getSchema()).stream().collect(ImmutableMap.toImmutableMap(table -> table, table -> (ImmutableList)IntStream.range(0, 100).boxed().map(i -> new ColumnMetadata("column_" + i, (Type)VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList())));
            }

            public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
                return ImmutableList.of((Object)new ConnectorTableLayoutResult(new ConnectorTableLayout((ConnectorTableLayoutHandle)TestingHandle.INSTANCE), TupleDomain.all()));
            }

            public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
                throw new UnsupportedOperationException();
            }

            public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
                return (Map)MockConnector.this.getViews.apply(session, prefix);
            }
        }
    }
}

