/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.prestosql.cost.EstimateAssertion;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.SymbolStatsAssertion;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.sql.planner.Symbol;
import java.util.Set;
import java.util.function.Consumer;
import org.testng.Assert;

public class PlanNodeStatsAssertion {
    private final PlanNodeStatsEstimate actual;

    private PlanNodeStatsAssertion(PlanNodeStatsEstimate actual) {
        this.actual = actual;
    }

    public static PlanNodeStatsAssertion assertThat(PlanNodeStatsEstimate actual) {
        return new PlanNodeStatsAssertion(actual);
    }

    public PlanNodeStatsAssertion outputRowsCount(double expected) {
        EstimateAssertion.assertEstimateEquals(this.actual.getOutputRowCount(), expected, "outputRowsCount mismatch", new Object[0]);
        return this;
    }

    public PlanNodeStatsAssertion outputRowsCountUnknown() {
        Assert.assertTrue((boolean)Double.isNaN(this.actual.getOutputRowCount()), (String)("expected unknown outputRowsCount but got " + this.actual.getOutputRowCount()));
        return this;
    }

    public PlanNodeStatsAssertion symbolStats(String symbolName, Consumer<SymbolStatsAssertion> symbolStatsAssertionConsumer) {
        return this.symbolStats(new Symbol(symbolName), symbolStatsAssertionConsumer);
    }

    public PlanNodeStatsAssertion symbolStats(Symbol symbol, Consumer<SymbolStatsAssertion> columnAssertionConsumer) {
        SymbolStatsAssertion columnAssertion = SymbolStatsAssertion.assertThat(this.actual.getSymbolStatistics(symbol));
        columnAssertionConsumer.accept(columnAssertion);
        return this;
    }

    public PlanNodeStatsAssertion symbolStatsUnknown(String symbolName) {
        return this.symbolStatsUnknown(new Symbol(symbolName));
    }

    public PlanNodeStatsAssertion symbolStatsUnknown(Symbol symbol) {
        return this.symbolStats(symbol, (SymbolStatsAssertion columnStats) -> columnStats.lowValueUnknown().highValueUnknown().nullsFractionUnknown().distinctValuesCountUnknown());
    }

    public PlanNodeStatsAssertion symbolsWithKnownStats(Symbol ... symbols) {
        Assert.assertEquals((Set)this.actual.getSymbolsWithKnownStatistics(), (Set)ImmutableSet.copyOf((Object[])symbols), (String)"symbols with known stats");
        return this;
    }

    public PlanNodeStatsAssertion equalTo(PlanNodeStatsEstimate expected) {
        EstimateAssertion.assertEstimateEquals(this.actual.getOutputRowCount(), expected.getOutputRowCount(), "outputRowCount mismatch", new Object[0]);
        for (Symbol symbol : Sets.union((Set)expected.getSymbolsWithKnownStatistics(), (Set)this.actual.getSymbolsWithKnownStatistics())) {
            this.assertSymbolStatsEqual(symbol, this.actual.getSymbolStatistics(symbol), expected.getSymbolStatistics(symbol));
        }
        return this;
    }

    private void assertSymbolStatsEqual(Symbol symbol, SymbolStatsEstimate actual, SymbolStatsEstimate expected) {
        EstimateAssertion.assertEstimateEquals(actual.getNullsFraction(), expected.getNullsFraction(), "nullsFraction mismatch for %s", symbol.getName());
        EstimateAssertion.assertEstimateEquals(actual.getLowValue(), expected.getLowValue(), "lowValue mismatch for %s", symbol.getName());
        EstimateAssertion.assertEstimateEquals(actual.getHighValue(), expected.getHighValue(), "highValue mismatch for %s", symbol.getName());
        EstimateAssertion.assertEstimateEquals(actual.getDistinctValuesCount(), expected.getDistinctValuesCount(), "distinct values count mismatch for %s", symbol.getName());
        EstimateAssertion.assertEstimateEquals(actual.getAverageRowSize(), expected.getAverageRowSize(), "average row size mismatch for %s", symbol.getName());
    }
}

