/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.cost.StatsCalculatorAssertion;
import io.prestosql.metadata.Metadata;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import java.util.Map;
import java.util.function.Function;

public class StatsCalculatorTester
implements AutoCloseable {
    private final StatsCalculator statsCalculator;
    private final Metadata metadata;
    private final Session session;
    private final LocalQueryRunner queryRunner;

    public StatsCalculatorTester() {
        this(TestingSession.testSessionBuilder().build());
    }

    public StatsCalculatorTester(Session session) {
        this(StatsCalculatorTester.createQueryRunner(session));
    }

    private StatsCalculatorTester(LocalQueryRunner queryRunner) {
        this.statsCalculator = queryRunner.getStatsCalculator();
        this.session = queryRunner.getDefaultSession();
        this.metadata = queryRunner.getMetadata();
        this.queryRunner = queryRunner;
    }

    private static LocalQueryRunner createQueryRunner(Session session) {
        LocalQueryRunner queryRunner = new LocalQueryRunner(session);
        queryRunner.createCatalog((String)session.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return queryRunner;
    }

    public StatsCalculatorAssertion assertStatsFor(Function<PlanBuilder, PlanNode> planProvider) {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), this.metadata);
        PlanNode planNode = planProvider.apply(planBuilder);
        return new StatsCalculatorAssertion(this.statsCalculator, this.session, planNode, planBuilder.getTypes());
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }
}

