/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.cost.PlanNodeStatsAssertion;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.StatsUtil;
import io.prestosql.cost.SymbolStatsAssertion;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.type.TypeRegistry;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.testng.annotations.Test;

public class TestStatsNormalizer {
    private final TypeManager typeManager = new TypeRegistry();
    private final FunctionRegistry functionRegistry = new FunctionRegistry(this.typeManager, (BlockEncodingSerde)new BlockEncodingManager(this.typeManager, new BlockEncoding[0]), new FeaturesConfig());
    private final ConnectorSession session = new TestingConnectorSession(Collections.emptyList());
    private final StatsNormalizer normalizer = new StatsNormalizer();

    @Test
    public void testNoCapping() {
        Symbol a = new Symbol("a");
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().setOutputRowCount(30.0).addSymbolStatistics(a, SymbolStatsEstimate.builder().setDistinctValuesCount(20.0).build()).build();
        this.assertNormalized(estimate).symbolStats(a, symbolAssert -> symbolAssert.distinctValuesCount(20.0));
    }

    @Test
    public void testDropNonOutputSymbols() {
        Symbol a = new Symbol("a");
        Symbol b = new Symbol("b");
        Symbol c = new Symbol("c");
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().setOutputRowCount(40.0).addSymbolStatistics(a, SymbolStatsEstimate.builder().setDistinctValuesCount(20.0).build()).addSymbolStatistics(b, SymbolStatsEstimate.builder().setDistinctValuesCount(30.0).build()).addSymbolStatistics(c, SymbolStatsEstimate.unknown()).build();
        PlanNodeStatsAssertion.assertThat(this.normalizer.normalize(estimate, (Collection)ImmutableList.of((Object)b, (Object)c), TypeProvider.copyOf((Map)ImmutableMap.of((Object)b, (Object)BigintType.BIGINT, (Object)c, (Object)BigintType.BIGINT)))).symbolsWithKnownStats(b).symbolStats(b, symbolAssert -> symbolAssert.distinctValuesCount(30.0));
    }

    @Test
    public void tesCapDistinctValuesByOutputRowCount() {
        Symbol a = new Symbol("a");
        Symbol b = new Symbol("b");
        Symbol c = new Symbol("c");
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().addSymbolStatistics(a, SymbolStatsEstimate.builder().setNullsFraction(0.0).setDistinctValuesCount(20.0).build()).addSymbolStatistics(b, SymbolStatsEstimate.builder().setNullsFraction(0.4).setDistinctValuesCount(20.0).build()).addSymbolStatistics(c, SymbolStatsEstimate.unknown()).setOutputRowCount(10.0).build();
        this.assertNormalized(estimate).symbolStats(a, symbolAssert -> symbolAssert.distinctValuesCount(10.0)).symbolStats(b, symbolAssert -> symbolAssert.distinctValuesCount(8.0)).symbolStats(c, SymbolStatsAssertion::distinctValuesCountUnknown);
    }

    @Test
    public void testCapDistinctValuesByToDomainRangeLength() {
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, 2.0E10, 1, 1000000000, 1.0E9);
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, 3.0, 1, 5, 3.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, Double.NaN, 1, 5, Double.NaN);
        this.testCapDistinctValuesByToDomainRangeLength((Type)BigintType.BIGINT, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)SmallintType.SMALLINT, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)TinyintType.TINYINT, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DecimalType.createDecimalType((int)10, (int)2), 11.0, 1, 1, 1.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DecimalType.createDecimalType((int)10, (int)2), 13.0, 101, 103, 3.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DecimalType.createDecimalType((int)10, (int)2), 10.0, 100, 200, 10.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DoubleType.DOUBLE, 42.0, 10.1, 10.2, 42.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DoubleType.DOUBLE, 42.0, 10.1, 10.1, 1.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)BooleanType.BOOLEAN, 11.0, true, true, 1.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)BooleanType.BOOLEAN, 12.0, false, true, 2.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DateType.DATE, 12.0, LocalDate.of(2017, 8, 31).toEpochDay(), LocalDate.of(2017, 9, 2).toEpochDay(), 3.0);
    }

    private void testCapDistinctValuesByToDomainRangeLength(Type type, double ndv, Object low, Object high, double expectedNormalizedNdv) {
        Symbol symbol = new Symbol("x");
        SymbolStatsEstimate symbolStats = SymbolStatsEstimate.builder().setNullsFraction(0.0).setDistinctValuesCount(ndv).setLowValue(this.asStatsValue(low, type)).setHighValue(this.asStatsValue(high, type)).build();
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().setOutputRowCount(1.0E10).addSymbolStatistics(symbol, symbolStats).build();
        this.assertNormalized(estimate, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)type))).symbolStats(symbol, symbolAssert -> symbolAssert.distinctValuesCount(expectedNormalizedNdv));
    }

    private PlanNodeStatsAssertion assertNormalized(PlanNodeStatsEstimate estimate) {
        TypeProvider types = TypeProvider.copyOf((Map)((Map)estimate.getSymbolsWithKnownStatistics().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), symbol -> BigintType.BIGINT))));
        return this.assertNormalized(estimate, types);
    }

    private PlanNodeStatsAssertion assertNormalized(PlanNodeStatsEstimate estimate, TypeProvider types) {
        PlanNodeStatsEstimate normalized = this.normalizer.normalize(estimate, (Collection)estimate.getSymbolsWithKnownStatistics(), types);
        return PlanNodeStatsAssertion.assertThat(normalized);
    }

    private double asStatsValue(Object value, Type type) {
        return StatsUtil.toStatsRepresentation((FunctionRegistry)this.functionRegistry, (ConnectorSession)this.session, (Type)type, (Object)value).orElse(Double.NaN);
    }
}

