/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.ObjectMapperProvider;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.connector.CatalogName;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.event.SplitMonitor;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.execution.Lifespan;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.ScheduledSplit;
import io.prestosql.execution.SqlTask;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.TaskSource;
import io.prestosql.execution.TestSqlTaskManager;
import io.prestosql.execution.TestingPageSourceProvider;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.scheduler.LegacyNetworkTopology;
import io.prestosql.execution.scheduler.NetworkTopology;
import io.prestosql.execution.scheduler.NodeScheduler;
import io.prestosql.execution.scheduler.NodeSchedulerConfig;
import io.prestosql.index.IndexManager;
import io.prestosql.metadata.InMemoryNodeManager;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Split;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.ExchangeClientSupplier;
import io.prestosql.operator.LookupJoinOperators;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.StageExecutionDescriptor;
import io.prestosql.operator.index.IndexJoinLookupStats;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.TestingTypeManager;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spiller.GenericSpillerFactory;
import io.prestosql.spiller.SpillerFactory;
import io.prestosql.split.PageSinkManager;
import io.prestosql.split.PageSourceManager;
import io.prestosql.split.PageSourceProvider;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.gen.JoinFilterFunctionCompiler;
import io.prestosql.sql.gen.OrderingCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.LocalExecutionPlanner;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.sql.planner.Partitioning;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.testing.TestingHandles;
import io.prestosql.testing.TestingMetadata;
import io.prestosql.testing.TestingSplit;
import io.prestosql.util.FinalizerService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public final class TaskTestUtils {
    public static final PlanNodeId TABLE_SCAN_NODE_ID = new PlanNodeId("tableScan");
    private static final CatalogName CONNECTOR_ID = TestingHandles.TEST_TABLE_HANDLE.getCatalogName();
    public static final ScheduledSplit SPLIT = new ScheduledSplit(0L, TABLE_SCAN_NODE_ID, new Split(CONNECTOR_ID, (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide()));
    public static final ImmutableList<TaskSource> EMPTY_SOURCES = ImmutableList.of();
    public static final Symbol SYMBOL = new Symbol("column");
    public static final PlanFragment PLAN_FRAGMENT = new PlanFragment(new PlanFragmentId("fragment"), (PlanNode)TableScanNode.newInstance((PlanNodeId)TABLE_SCAN_NODE_ID, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)SYMBOL), (Map)ImmutableMap.of((Object)SYMBOL, (Object)new TestingMetadata.TestingColumnHandle("column", 0, (Type)BigintType.BIGINT))), (Map)ImmutableMap.of((Object)SYMBOL, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)TABLE_SCAN_NODE_ID), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)SYMBOL)).withBucketToPartition(Optional.of(new int[1])), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());

    private TaskTestUtils() {
    }

    public static LocalExecutionPlanner createTestingPlanner() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        PageSourceManager pageSourceManager = new PageSourceManager();
        pageSourceManager.addConnectorPageSourceProvider(CONNECTOR_ID, (ConnectorPageSourceProvider)new TestingPageSourceProvider());
        FinalizerService finalizerService = new FinalizerService();
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)new InMemoryNodeManager(), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(finalizerService));
        NodePartitioningManager nodePartitioningManager = new NodePartitioningManager(nodeScheduler);
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        return new LocalExecutionPlanner((Metadata)metadata, new TypeAnalyzer(new SqlParser(), (Metadata)metadata), Optional.empty(), (PageSourceProvider)pageSourceManager, new IndexManager(), nodePartitioningManager, new PageSinkManager(), (ExchangeClientSupplier)new TestSqlTaskManager.MockExchangeClientSupplier(), new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler), pageFunctionCompiler, new JoinFilterFunctionCompiler((Metadata)metadata), new IndexJoinLookupStats(), new TaskManagerConfig(), (SpillerFactory)new GenericSpillerFactory((types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }), (types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (types, partitionFunction, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TestingTypeManager(), new BlockEncoding[0]), (PagesIndex.Factory)new PagesIndex.TestingFactory(false), new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager()), new LookupJoinOperators(), new OrderingCompiler());
    }

    public static TaskInfo updateTask(SqlTask sqlTask, List<TaskSource> taskSources, OutputBuffers outputBuffers) {
        return sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(PLAN_FRAGMENT), taskSources, outputBuffers, OptionalInt.empty());
    }

    public static SplitMonitor createTestSplitMonitor() {
        return new SplitMonitor(new EventListenerManager(), new ObjectMapperProvider().get());
    }
}

