/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.DeallocateTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.sql.tree.Deallocate;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestDeallocateTask {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testDeallocate() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT bar, baz FROM foo").build();
        Set<String> statements = this.executeDeallocate("my_query", "DEALLOCATE PREPARE my_query", session);
        Assert.assertEquals(statements, (Set)ImmutableSet.of((Object)"my_query"));
    }

    @Test
    public void testDeallocateNoSuchStatement() {
        try {
            this.executeDeallocate("my_query", "DEALLOCATE PREPARE my_query", SessionTestUtils.TEST_SESSION);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_FOUND.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)"Prepared statement not found: my_query");
        }
    }

    private Set<String> executeDeallocate(String statementName, String sqlString, Session session) {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControl = new AccessControlManager(transactionManager);
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)sqlString, (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
        Deallocate deallocate = new Deallocate(new Identifier(statementName));
        new DeallocateTask().execute(deallocate, transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList());
        return stateMachine.getDeallocatedPreparedStatements();
    }
}

