/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.prestosql.execution.scheduler.NodeSchedulerConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNodeSchedulerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeSchedulerConfig)ConfigAssertions.recordDefaults(NodeSchedulerConfig.class)).setNetworkTopology("legacy").setMinCandidates(10).setMaxSplitsPerNode(100).setMaxPendingSplitsPerTask(10).setIncludeCoordinator(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node-scheduler.network-topology", (Object)"flat").put((Object)"node-scheduler.min-candidates", (Object)"11").put((Object)"node-scheduler.include-coordinator", (Object)"false").put((Object)"node-scheduler.max-pending-splits-per-task", (Object)"11").put((Object)"node-scheduler.max-splits-per-node", (Object)"101").build();
        NodeSchedulerConfig expected = new NodeSchedulerConfig().setNetworkTopology("flat").setIncludeCoordinator(false).setMaxSplitsPerNode(101).setMaxPendingSplitsPerTask(11).setMinCandidates(11);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

