/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.prestosql.SequencePageBuilder;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.buffer.PageSplitterUtil;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.assertions.Assert;
import java.util.List;
import org.testng.annotations.Test;

public class TestPageSplitterUtil {
    @Test
    public void testSplitPage() {
        int positionCount = 10;
        int maxPageSizeInBytes = 100;
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        Page largePage = SequencePageBuilder.createSequencePage((List<? extends Type>)types, positionCount, 0, 1, 1);
        List pages = PageSplitterUtil.splitPage((Page)largePage, (long)maxPageSizeInBytes);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(pages.size()), (Comparable)Integer.valueOf(1));
        TestPageSplitterUtil.assertPageSize(pages, maxPageSizeInBytes);
        TestPageSplitterUtil.assertPositionCount(pages, positionCount);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, pages);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, (List<Page>)ImmutableList.of((Object)largePage));
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    private static void assertPageSize(List<Page> pages, long maxPageSizeInBytes) {
        for (Page page : pages) {
            Assertions.assertLessThanOrEqual((Comparable)Long.valueOf(page.getSizeInBytes()), (Comparable)Long.valueOf(maxPageSizeInBytes));
        }
    }

    private static void assertPositionCount(List<Page> pages, int positionCount) {
        int totalPositionCount = 0;
        for (Page page : pages) {
            totalPositionCount += page.getPositionCount();
        }
        Assert.assertEquals((int)totalPositionCount, (int)positionCount);
    }

    @Test
    private void testSplitPageNonDecreasingPageSize() {
        int positionCount = 100;
        int maxPageSizeInBytes = 1;
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        Slice expectedValue = Slices.wrappedBuffer((byte[])"test".getBytes());
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1, expectedValue.length());
        blockBuilder.writeBytes(expectedValue, 0, expectedValue.length()).closeEntry();
        RunLengthEncodedBlock rleBlock = new RunLengthEncodedBlock(blockBuilder.build(), positionCount);
        Page initialPage = new Page(new Block[]{rleBlock});
        List pages = PageSplitterUtil.splitPage((Page)initialPage, (long)maxPageSizeInBytes);
        Assert.assertEquals((int)pages.size(), (int)2);
        Page first = (Page)pages.get(0);
        Page second = (Page)pages.get(1);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf((int)first.getSizeInBytes()), (Comparable)Integer.valueOf(maxPageSizeInBytes));
        Assertions.assertGreaterThan((Comparable)Integer.valueOf((int)second.getSizeInBytes()), (Comparable)Integer.valueOf(maxPageSizeInBytes));
        TestPageSplitterUtil.assertPositionCount(pages, positionCount);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, pages);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, (List<Page>)ImmutableList.of((Object)initialPage));
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }
}

