/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.execution.warnings.DefaultWarningCollector;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.execution.warnings.WarningCollectorConfig;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.PrestoWarning;
import io.prestosql.spi.WarningCode;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.planner.LogicalPlanner;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.RuleStatsRecorder;
import io.prestosql.sql.planner.iterative.IterativeOptimizer;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPlannerWarnings {
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        this.queryRunner = new LocalQueryRunner(TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").build());
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.queryRunner.close();
    }

    @Test
    public void testWarning() {
        List<PrestoWarning> warnings = TestPlannerWarnings.createTestWarnings(3);
        List warningCodes = (List)warnings.stream().map(PrestoWarning::getWarningCode).collect(ImmutableList.toImmutableList());
        TestPlannerWarnings.assertPlannerWarnings(this.queryRunner, "SELECT * FROM NATION", (Map<String, String>)ImmutableMap.of(), warningCodes, Optional.of(ImmutableList.of((Object)new TestWarningsRule(warnings))));
    }

    public static void assertPlannerWarnings(LocalQueryRunner queryRunner, @Language(value="SQL") String sql, Map<String, String> sessionProperties, List<WarningCode> expectedWarnings, Optional<List<Rule<?>>> rules) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog((String)queryRunner.getDefaultSession().getCatalog().get()).setSchema((String)queryRunner.getDefaultSession().getSchema().get());
        sessionProperties.forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig());
        try {
            queryRunner.inTransaction(sessionBuilder.build(), arg_0 -> TestPlannerWarnings.lambda$assertPlannerWarnings$0(rules, queryRunner, sql, (WarningCollector)warningCollector, arg_0));
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        Set warnings = (Set)warningCollector.getWarnings().stream().map(PrestoWarning::getWarningCode).collect(ImmutableSet.toImmutableSet());
        for (WarningCode expectedWarning : expectedWarnings) {
            if (warnings.contains(expectedWarning)) continue;
            Assert.fail((String)("Expected warning: " + expectedWarning));
        }
    }

    private static Plan createPlan(LocalQueryRunner queryRunner, Session session, String sql, WarningCollector warningCollector, List<Rule<?>> rules) {
        IterativeOptimizer optimizer = new IterativeOptimizer(new RuleStatsRecorder(), queryRunner.getStatsCalculator(), queryRunner.getCostCalculator(), (Set)ImmutableSet.copyOf(rules));
        return queryRunner.createPlan(session, sql, (List)ImmutableList.of((Object)optimizer), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, warningCollector);
    }

    public static List<PrestoWarning> createTestWarnings(int numberOfWarnings) {
        Preconditions.checkArgument((numberOfWarnings > 0 ? 1 : 0) != 0, (Object)"numberOfWarnings must be > 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        IntStream.range(1, numberOfWarnings).mapToObj(code -> new PrestoWarning(new WarningCode(code, "testWarning"), "Test warning " + code)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private static /* synthetic */ Object lambda$assertPlannerWarnings$0(Optional rules, LocalQueryRunner queryRunner, String sql, WarningCollector warningCollector, Session transactionSession) {
        if (rules.isPresent()) {
            TestPlannerWarnings.createPlan(queryRunner, transactionSession, sql, warningCollector, (List)rules.get());
        } else {
            queryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.CREATED, false, warningCollector);
        }
        return null;
    }

    public static class TestWarningsRule
    implements Rule<ProjectNode> {
        private final List<PrestoWarning> warnings;

        public TestWarningsRule(List<PrestoWarning> warnings) {
            this.warnings = ImmutableList.copyOf((Collection)Objects.requireNonNull(warnings, "warnings is null"));
        }

        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
            this.warnings.stream().forEach(arg_0 -> ((WarningCollector)context.getWarningCollector()).add(arg_0));
            return Rule.Result.empty();
        }
    }
}

