/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.PrepareTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.sql.QueryUtil;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.AllColumns;
import io.prestosql.sql.tree.Execute;
import io.prestosql.sql.tree.Prepare;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.Select;
import io.prestosql.sql.tree.SelectItem;
import io.prestosql.sql.tree.Statement;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestPrepareTask {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testPrepare() {
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")));
        String sqlString = "PREPARE my_query FROM SELECT * FROM foo";
        Map<String, String> statements = this.executePrepare("my_query", (Statement)query, sqlString, SessionTestUtils.TEST_SESSION);
        Assert.assertEquals(statements, (Map)ImmutableMap.of((Object)"my_query", (Object)"SELECT *\nFROM\n  foo\n"));
    }

    @Test
    public void testPrepareNameExists() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT bar, baz from foo").build();
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")));
        String sqlString = "PREPARE my_query FROM SELECT * FROM foo";
        Map<String, String> statements = this.executePrepare("my_query", (Statement)query, sqlString, session);
        Assert.assertEquals(statements, (Map)ImmutableMap.of((Object)"my_query", (Object)"SELECT *\nFROM\n  foo\n"));
    }

    @Test
    public void testPrepareInvalidStatement() {
        Execute statement = new Execute(QueryUtil.identifier((String)"foo"), Collections.emptyList());
        String sqlString = "PREPARE my_query FROM EXECUTE foo";
        try {
            this.executePrepare("my_query", (Statement)statement, sqlString, SessionTestUtils.TEST_SESSION);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid statement type for prepared statement: EXECUTE");
        }
    }

    private Map<String, String> executePrepare(String statementName, Statement statement, String sqlString, Session session) {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)sqlString, (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)new AccessControlManager(transactionManager), (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
        Prepare prepare = new Prepare(QueryUtil.identifier((String)statementName), statement);
        new PrepareTask(new SqlParser()).execute(prepare, transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList());
        return stateMachine.getAddedPreparedStatements();
    }
}

