/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.QueryPreparer;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.QueryUtil;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.AllColumns;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.Select;
import io.prestosql.sql.tree.SelectItem;
import io.prestosql.testing.TestingSession;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryPreparer {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final QueryPreparer QUERY_PREPARER = new QueryPreparer(SQL_PARSER);

    @Test
    public void testSelectStatement() {
        QueryPreparer.PreparedQuery preparedQuery = QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "SELECT * FROM foo");
        Assert.assertEquals((Object)preparedQuery.getStatement(), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatement() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo").build();
        QueryPreparer.PreparedQuery preparedQuery = QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query");
        Assert.assertEquals((Object)preparedQuery.getStatement(), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatementDoesNotExist() {
        try {
            QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "execute my_query");
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_FOUND.toErrorCode());
        }
    }

    @Test
    public void testTooManyParameters() {
        try {
            Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo where col1 = ?").build();
            QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1,2");
            Assert.fail((String)"expected exception");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_PARAMETER_USAGE);
        }
    }

    @Test
    public void testTooFewParameters() {
        try {
            Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo where col1 = ?").build();
            QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1");
            Assert.fail((String)"expected exception");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_PARAMETER_USAGE);
        }
    }
}

