/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.RollbackTask;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.sql.tree.Rollback;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestRollbackTask {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testRollback() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestRollbackTask.sessionBuilder().setTransactionId(transactionManager.beginTransaction(false)).build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("ROLLBACK", session, transactionManager);
        Assert.assertTrue((boolean)stateMachine.getSession().getTransactionId().isPresent());
        Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
        MoreFutures.getFutureValue((Future)new RollbackTask().execute(new Rollback(), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
    }

    @Test
    public void testNoTransactionRollback() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestRollbackTask.sessionBuilder().build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("ROLLBACK", session, transactionManager);
        try {
            MoreFutures.getFutureValue((Future)new RollbackTask().execute(new Rollback(), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_IN_TRANSACTION.toErrorCode());
        }
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
    }

    @Test
    public void testUnknownTransactionRollback() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestRollbackTask.sessionBuilder().setTransactionId(TransactionId.create()).build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("ROLLBACK", session, transactionManager);
        MoreFutures.getFutureValue((Future)new RollbackTask().execute(new Rollback(), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
    }

    private QueryStateMachine createQueryStateMachine(String query, Session session, TransactionManager transactionManager) {
        return QueryStateMachine.begin((String)query, (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)true, (TransactionManager)transactionManager, (AccessControl)new AllowAllAccessControl(), (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
    }

    private static Session.SessionBuilder sessionBuilder() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny");
    }
}

