/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.SetPathTask;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.AnalyzePropertyManager;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.ColumnPropertyManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.SchemaPropertyManager;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.metadata.TablePropertyManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.PathElement;
import io.prestosql.sql.tree.PathSpecification;
import io.prestosql.sql.tree.SetPath;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.type.TypeRegistry;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSetPathTask {
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final MetadataManager metadata;
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    public TestSetPathTask() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = new MetadataManager(new FeaturesConfig(), (TypeManager)new TypeRegistry(), (BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]), new SessionPropertyManager(), new SchemaPropertyManager(), new TablePropertyManager(), new ColumnPropertyManager(), new AnalyzePropertyManager(), this.transactionManager);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSetPath() {
        PathSpecification pathSpecification = new PathSpecification(Optional.empty(), (List)ImmutableList.of((Object)new PathElement(Optional.empty(), new Identifier("foo"))));
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET PATH foo");
        this.executeSetPathTask(pathSpecification, stateMachine);
        Assert.assertEquals((String)stateMachine.getSetPath(), (String)"foo");
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Catalog does not exist: .*")
    public void testSetPathInvalidCatalog() {
        PathSpecification invalidPathSpecification = new PathSpecification(Optional.empty(), (List)ImmutableList.of((Object)new PathElement(Optional.of(new Identifier("invalidCatalog")), new Identifier("thisDoesNotMatter"))));
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET PATH invalidCatalog.thisDoesNotMatter");
        this.executeSetPathTask(invalidPathSpecification, stateMachine);
    }

    private QueryStateMachine createQueryStateMachine(String query) {
        return QueryStateMachine.begin((String)query, (Session)SessionTestUtils.TEST_SESSION, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
    }

    private void executeSetPathTask(PathSpecification pathSpecification, QueryStateMachine stateMachine) {
        MoreFutures.getFutureValue((Future)new SetPathTask().execute(new SetPath(pathSpecification), this.transactionManager, (Metadata)this.metadata, this.accessControl, stateMachine, Collections.emptyList()));
    }
}

