/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.SetSessionTask;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.AnalyzePropertyManager;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.ColumnPropertyManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.SchemaPropertyManager;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.metadata.TablePropertyManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SetSession;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.type.TypeRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSetSessionTask {
    private static final String CATALOG_NAME = "foo";
    private static final String MUST_BE_POSITIVE = "property must be positive";
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final MetadataManager metadata;
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    public TestSetSessionTask() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = new MetadataManager(new FeaturesConfig(), (TypeManager)new TypeRegistry(), (BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]), new SessionPropertyManager(), new SchemaPropertyManager(), new TablePropertyManager(), new ColumnPropertyManager(), new AnalyzePropertyManager(), this.transactionManager);
        this.metadata.getSessionPropertyManager().addSystemSessionProperty(PropertyMetadata.stringProperty((String)CATALOG_NAME, (String)"test property", null, (boolean)false));
        Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        ImmutableList sessionProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"bar", (String)"test property", null, (boolean)false), (Object)new PropertyMetadata("positive_property", "property that should be positive", (Type)IntegerType.INTEGER, Integer.class, null, false, value -> TestSetSessionTask.validatePositive(value), value -> value));
        this.metadata.getSessionPropertyManager().addConnectorSessionProperties(bogusTestingCatalog.getConnectorCatalogName(), (List)sessionProperties);
        catalogManager.registerCatalog(bogusTestingCatalog);
    }

    private static int validatePositive(Object value) {
        int intValue = ((Number)value).intValue();
        if (intValue < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, MUST_BE_POSITIVE);
        }
        return intValue;
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSetSession() {
        this.testSetSession((Expression)new StringLiteral("baz"), "baz");
        this.testSetSession((Expression)new FunctionCall(QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral("ban"), (Object)new StringLiteral("ana"))), "banana");
    }

    @Test
    public void testSetSessionWithValidation() {
        this.testSetSessionWithValidation((Expression)new LongLiteral("0"), "0");
        this.testSetSessionWithValidation((Expression)new LongLiteral("2"), "2");
        try {
            this.testSetSessionWithValidation((Expression)new LongLiteral("-1"), "-1");
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((String)e.getMessage(), (String)MUST_BE_POSITIVE);
        }
    }

    @Test
    public void testSetSessionWithParameters() {
        ArrayList<Object> expressionList = new ArrayList<Object>();
        expressionList.add(new StringLiteral("ban"));
        expressionList.add(new Parameter(0));
        this.testSetSessionWithParameters("bar", (Expression)new FunctionCall(QualifiedName.of((String)"concat"), expressionList), "banana", (List<Expression>)ImmutableList.of((Object)new StringLiteral("ana")));
    }

    private void testSetSession(Expression expression, String expectedValue) {
        this.testSetSessionWithParameters("bar", expression, expectedValue, Collections.emptyList());
    }

    private void testSetSessionWithValidation(Expression expression, String expectedValue) {
        this.testSetSessionWithParameters("positive_property", expression, expectedValue, Collections.emptyList());
    }

    private void testSetSessionWithParameters(String property, Expression expression, String expectedValue, List<Expression> parameters) {
        QualifiedName qualifiedPropName = QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{property});
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)String.format("set %s = 'old_value'", qualifiedPropName), (Session)SessionTestUtils.TEST_SESSION, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
        MoreFutures.getFutureValue((Future)new SetSessionTask().execute(new SetSession(qualifiedPropName, expression), this.transactionManager, (Metadata)this.metadata, this.accessControl, stateMachine, parameters));
        Map sessionProperties = stateMachine.getSetSessionProperties();
        Assert.assertEquals((Map)sessionProperties, (Map)ImmutableMap.of((Object)qualifiedPropName.toString(), (Object)expectedValue));
    }
}

