/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.client.NodeVersion;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.execution.MockRemoteTaskFactory;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.RemoteTaskFactory;
import io.prestosql.execution.SqlStageExecution;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StageInfo;
import io.prestosql.execution.TestSqlTaskManager;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.scheduler.SplitSchedulerStats;
import io.prestosql.failuredetector.FailureDetector;
import io.prestosql.failuredetector.NoOpFailureDetector;
import io.prestosql.metadata.InternalNode;
import io.prestosql.operator.StageExecutionDescriptor;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.Partitioning;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import io.prestosql.util.FinalizerService;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSqlStageExecution {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @Test(timeOut=120000L)
    public void testFinalStageInfo() throws Exception {
        for (int iteration = 0; iteration < 10; ++iteration) {
            this.testFinalStageInfoInternal();
        }
    }

    private void testFinalStageInfoInternal() throws Exception {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(new FinalizerService());
        StageId stageId = new StageId(new QueryId("query"), 0);
        SqlStageExecution stage = SqlStageExecution.createSqlStageExecution((StageId)stageId, (URI)new TestSqlTaskManager.MockLocationFactory().createStageLocation(stageId), (PlanFragment)TestSqlStageExecution.createExchangePlanFragment(), (RemoteTaskFactory)new MockRemoteTaskFactory(this.executor, this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)nodeTaskMap, (ExecutorService)this.executor, (FailureDetector)new NoOpFailureDetector(), (SplitSchedulerStats)new SplitSchedulerStats());
        stage.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY));
        SettableFuture finalStageInfo = SettableFuture.create();
        stage.addFinalStageInfoListener(arg_0 -> ((SettableFuture)finalStageInfo).set(arg_0));
        CountDownLatch latch = new CountDownLatch(1000);
        Future<?> addTasksTask = this.executor.submit(() -> {
            try {
                for (int i = 0; i < 1000000; ++i) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    InternalNode node = new InternalNode("source" + i, URI.create("http://10.0.0." + i / 10000 + ":" + i % 10000), NodeVersion.UNKNOWN, false);
                    stage.scheduleTask(node, i, OptionalInt.empty());
                    latch.countDown();
                }
            }
            finally {
                while (latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
        });
        latch.await(1L, TimeUnit.MINUTES);
        Assert.assertFalse((boolean)stage.getStageInfo().getTasks().isEmpty());
        stage.abort();
        StageInfo stageInfo = (StageInfo)finalStageInfo.get(1L, TimeUnit.MINUTES);
        Assert.assertFalse((boolean)stageInfo.getTasks().isEmpty());
        Assert.assertTrue((boolean)stageInfo.isCompleteInfo());
        Assert.assertSame((Object)stage.getStageInfo(), (Object)stageInfo);
        addTasksTask.cancel(true);
    }

    private static PlanFragment createExchangePlanFragment() {
        RemoteSourceNode planNode = new RemoteSourceNode(new PlanNodeId("exchange"), (List)ImmutableList.of((Object)new PlanFragmentId("source")), (List)ImmutableList.of((Object)new Symbol("column")), Optional.empty(), ExchangeNode.Type.REPARTITION);
        ImmutableMap.Builder types = ImmutableMap.builder();
        for (Symbol symbol : planNode.getOutputSymbols()) {
            types.put((Object)symbol, (Object)VarcharType.VARCHAR);
        }
        return new PlanFragment(new PlanFragmentId("exchange_fragment_id"), (PlanNode)planNode, (Map)types.build(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)planNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), planNode.getOutputSymbols()), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());
    }
}

