/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockAssertions;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.connector.CatalogName;
import io.prestosql.event.SplitMonitor;
import io.prestosql.execution.Lifespan;
import io.prestosql.execution.ScheduledSplit;
import io.prestosql.execution.SqlTaskExecution;
import io.prestosql.execution.StateMachine;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskSource;
import io.prestosql.execution.TaskState;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.execution.TaskTestUtils;
import io.prestosql.execution.buffer.BufferResult;
import io.prestosql.execution.buffer.BufferState;
import io.prestosql.execution.buffer.OutputBuffer;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.buffer.PagesSerdeFactory;
import io.prestosql.execution.buffer.PartitionedOutputBuffer;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.execution.executor.TaskExecutor;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContext;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.SimpleLocalMemoryContext;
import io.prestosql.metadata.Split;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DriverFactory;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PipelineExecutionStrategy;
import io.prestosql.operator.SourceOperator;
import io.prestosql.operator.SourceOperatorFactory;
import io.prestosql.operator.StageExecutionDescriptor;
import io.prestosql.operator.TaskContext;
import io.prestosql.operator.TaskOutputOperator;
import io.prestosql.operator.ValuesOperator;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.Page;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.spi.memory.MemoryPoolId;
import io.prestosql.spi.type.TestingTypeManager;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spiller.SpillSpaceTracker;
import io.prestosql.sql.planner.LocalExecutionPlanner;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSqlTaskExecution {
    private static final OutputBuffers.OutputBufferId OUTPUT_BUFFER_ID = new OutputBuffers.OutputBufferId(0);
    private static final CatalogName CONNECTOR_ID = new CatalogName("test");
    private static final Duration ASSERT_WAIT_TIMEOUT = new Duration(1.0, TimeUnit.HOURS);

    @DataProvider
    public static Object[][] executionStrategies() {
        return new Object[][]{{PipelineExecutionStrategy.UNGROUPED_EXECUTION}, {PipelineExecutionStrategy.GROUPED_EXECUTION}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="executionStrategies", timeOut=20000L)
    public void testSimple(PipelineExecutionStrategy executionStrategy) throws Exception {
        ScheduledExecutorService taskNotificationExecutor = Executors.newScheduledThreadPool(10, Threads.threadsNamed((String)"task-notification-%s"));
        ScheduledExecutorService driverYieldExecutor = Executors.newScheduledThreadPool(2, Threads.threadsNamed((String)"driver-yield-%s"));
        TaskExecutor taskExecutor = new TaskExecutor(5, 10, 3, 4, Ticker.systemTicker());
        taskExecutor.start();
        try {
            TaskStateMachine taskStateMachine = new TaskStateMachine(TaskId.valueOf((String)"task-id"), (Executor)taskNotificationExecutor);
            PartitionedOutputBuffer outputBuffer = this.newTestingOutputBuffer(taskNotificationExecutor);
            OutputBufferConsumer outputBufferConsumer = new OutputBufferConsumer((OutputBuffer)outputBuffer, OUTPUT_BUFFER_ID);
            TestingScanOperatorFactory testingScanOperatorFactory = new TestingScanOperatorFactory(0, TaskTestUtils.TABLE_SCAN_NODE_ID, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
            TaskOutputOperator.TaskOutputOperatorFactory taskOutputOperatorFactory = new TaskOutputOperator.TaskOutputOperatorFactory(1, TaskTestUtils.TABLE_SCAN_NODE_ID, (OutputBuffer)outputBuffer, Function.identity(), new PagesSerdeFactory((BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TestingTypeManager(), new BlockEncoding[0]), false));
            LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = new LocalExecutionPlanner.LocalExecutionPlan((List)ImmutableList.of((Object)new DriverFactory(0, true, true, (List)ImmutableList.of((Object)testingScanOperatorFactory, (Object)taskOutputOperatorFactory), OptionalInt.empty(), executionStrategy)), (List)ImmutableList.of((Object)TaskTestUtils.TABLE_SCAN_NODE_ID), executionStrategy == PipelineExecutionStrategy.GROUPED_EXECUTION ? StageExecutionDescriptor.groupedExecution((List)ImmutableList.of((Object)TaskTestUtils.TABLE_SCAN_NODE_ID)) : StageExecutionDescriptor.ungroupedExecution());
            TaskContext taskContext = this.newTestingTaskContext(taskNotificationExecutor, driverYieldExecutor, taskStateMachine);
            SqlTaskExecution sqlTaskExecution = SqlTaskExecution.createSqlTaskExecution((TaskStateMachine)taskStateMachine, (TaskContext)taskContext, (OutputBuffer)outputBuffer, (List)ImmutableList.of(), (LocalExecutionPlanner.LocalExecutionPlan)localExecutionPlan, (TaskExecutor)taskExecutor, (Executor)taskNotificationExecutor, (SplitMonitor)TaskTestUtils.createTestSplitMonitor());
            Assert.assertEquals((Object)taskStateMachine.getState(), (Object)TaskState.RUNNING);
            switch (executionStrategy) {
                case UNGROUPED_EXECUTION: {
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)this.newScheduledSplit(0, TaskTestUtils.TABLE_SCAN_NODE_ID, Lifespan.taskWide(), 100000, 123)), false)));
                    outputBufferConsumer.consume(123, ASSERT_WAIT_TIMEOUT);
                    testingScanOperatorFactory.getPauser().pause();
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)this.newScheduledSplit(1, TaskTestUtils.TABLE_SCAN_NODE_ID, Lifespan.taskWide(), 200000, 300), (Object)this.newScheduledSplit(2, TaskTestUtils.TABLE_SCAN_NODE_ID, Lifespan.taskWide(), 300000, 200)), true)));
                    this.waitUntilEquals(testingScanOperatorFactory::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    Assert.assertEquals((Set)taskContext.getCompletedDriverGroups(), (Set)ImmutableSet.of());
                    testingScanOperatorFactory.getPauser().resume();
                    outputBufferConsumer.consume(500, ASSERT_WAIT_TIMEOUT);
                    outputBufferConsumer.assertBufferComplete(ASSERT_WAIT_TIMEOUT);
                    break;
                }
                case GROUPED_EXECUTION: {
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)this.newScheduledSplit(0, TaskTestUtils.TABLE_SCAN_NODE_ID, Lifespan.driverGroup((int)1), 0, 1), (Object)this.newScheduledSplit(1, TaskTestUtils.TABLE_SCAN_NODE_ID, Lifespan.driverGroup((int)5), 100000, 10)), (Set)ImmutableSet.of((Object)Lifespan.driverGroup((int)1)), false)));
                    this.waitUntilEquals(testingScanOperatorFactory::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)1)), ASSERT_WAIT_TIMEOUT);
                    outputBufferConsumer.consume(11, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(() -> ((TaskContext)taskContext).getCompletedDriverGroups(), ImmutableSet.of((Object)Lifespan.driverGroup((int)1)), ASSERT_WAIT_TIMEOUT);
                    testingScanOperatorFactory.getPauser().pause();
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)this.newScheduledSplit(2, TaskTestUtils.TABLE_SCAN_NODE_ID, Lifespan.driverGroup((int)5), 200000, 300)), (Set)ImmutableSet.of((Object)Lifespan.driverGroup((int)5)), false)));
                    this.waitUntilEquals(testingScanOperatorFactory::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)1), (Object)Lifespan.driverGroup((int)5)), ASSERT_WAIT_TIMEOUT);
                    Assert.assertEquals((Set)taskContext.getCompletedDriverGroups(), (Set)ImmutableSet.of((Object)Lifespan.driverGroup((int)1)));
                    testingScanOperatorFactory.getPauser().resume();
                    outputBufferConsumer.consume(300, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(() -> ((TaskContext)taskContext).getCompletedDriverGroups(), ImmutableSet.of((Object)Lifespan.driverGroup((int)1), (Object)Lifespan.driverGroup((int)5)), ASSERT_WAIT_TIMEOUT);
                    testingScanOperatorFactory.getPauser().pause();
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)this.newScheduledSplit(3, TaskTestUtils.TABLE_SCAN_NODE_ID, Lifespan.driverGroup((int)7), 300000, 45), (Object)this.newScheduledSplit(4, TaskTestUtils.TABLE_SCAN_NODE_ID, Lifespan.driverGroup((int)7), 400000, 54)), (Set)ImmutableSet.of(), true)));
                    this.waitUntilEquals(testingScanOperatorFactory::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)1), (Object)Lifespan.driverGroup((int)5), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(testingScanOperatorFactory::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    Assert.assertEquals((Set)taskContext.getCompletedDriverGroups(), (Set)ImmutableSet.of((Object)Lifespan.driverGroup((int)1), (Object)Lifespan.driverGroup((int)5)));
                    testingScanOperatorFactory.getPauser().resume();
                    outputBufferConsumer.consume(99, ASSERT_WAIT_TIMEOUT);
                    outputBufferConsumer.assertBufferComplete(ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(() -> ((TaskContext)taskContext).getCompletedDriverGroups(), ImmutableSet.of((Object)Lifespan.driverGroup((int)1), (Object)Lifespan.driverGroup((int)5), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            outputBufferConsumer.abort();
            TaskState taskState = (TaskState)taskStateMachine.getStateChange(TaskState.RUNNING).get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)taskState, (Object)TaskState.FINISHED);
        }
        finally {
            taskExecutor.stop();
            taskNotificationExecutor.shutdownNow();
            driverYieldExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="executionStrategies", timeOut=20000L)
    public void testComplex(PipelineExecutionStrategy executionStrategy) throws Exception {
        ScheduledExecutorService taskNotificationExecutor = Executors.newScheduledThreadPool(10, Threads.threadsNamed((String)"task-notification-%s"));
        ScheduledExecutorService driverYieldExecutor = Executors.newScheduledThreadPool(2, Threads.threadsNamed((String)"driver-yield-%s"));
        TaskExecutor taskExecutor = new TaskExecutor(5, 10, 3, 4, Ticker.systemTicker());
        taskExecutor.start();
        try {
            TaskStateMachine taskStateMachine = new TaskStateMachine(TaskId.valueOf((String)"task-id"), (Executor)taskNotificationExecutor);
            PartitionedOutputBuffer outputBuffer = this.newTestingOutputBuffer(taskNotificationExecutor);
            OutputBufferConsumer outputBufferConsumer = new OutputBufferConsumer((OutputBuffer)outputBuffer, OUTPUT_BUFFER_ID);
            PlanNodeId scan0NodeId = new PlanNodeId("scan-0");
            PlanNodeId values1NodeId = new PlanNodeId("values-1");
            PlanNodeId scan2NodeId = new PlanNodeId("scan-2");
            PlanNodeId values3NodeId = new PlanNodeId("values-3");
            PlanNodeId joinANodeId = new PlanNodeId("join-a");
            PlanNodeId joinBNodeId = new PlanNodeId("join-b");
            PlanNodeId joinCNodeId = new PlanNodeId("join-c");
            BuildStates buildStatesA = new BuildStates(executionStrategy);
            BuildStates buildStatesB = new BuildStates(executionStrategy);
            BuildStates buildStatesC = new BuildStates(PipelineExecutionStrategy.UNGROUPED_EXECUTION);
            TestingScanOperatorFactory scanOperatorFactory0 = new TestingScanOperatorFactory(1, scan0NodeId, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
            ValuesOperator.ValuesOperatorFactory valuesOperatorFactory1 = new ValuesOperator.ValuesOperatorFactory(101, values1NodeId, (List)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createStringsBlock("multiplier1")})));
            TestingScanOperatorFactory scanOperatorFactory2 = new TestingScanOperatorFactory(201, scan2NodeId, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
            ValuesOperator.ValuesOperatorFactory valuesOperatorFactory3 = new ValuesOperator.ValuesOperatorFactory(301, values3NodeId, (List)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createStringsBlock("x", "y", "multiplier3")})));
            TaskOutputOperator.TaskOutputOperatorFactory taskOutputOperatorFactory = new TaskOutputOperator.TaskOutputOperatorFactory(4, joinCNodeId, (OutputBuffer)outputBuffer, Function.identity(), new PagesSerdeFactory((BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TestingTypeManager(), new BlockEncoding[0]), false));
            TestingCrossJoinOperatorFactory joinOperatorFactoryA = new TestingCrossJoinOperatorFactory(2, joinANodeId, buildStatesA);
            TestingCrossJoinOperatorFactory joinOperatorFactoryB = new TestingCrossJoinOperatorFactory(102, joinBNodeId, buildStatesB);
            TestingCrossJoinOperatorFactory joinOperatorFactoryC = new TestingCrossJoinOperatorFactory(3, joinCNodeId, buildStatesC);
            TestingBuildOperatorFactory buildOperatorFactoryA = new TestingBuildOperatorFactory(103, joinANodeId, buildStatesA);
            TestingBuildOperatorFactory buildOperatorFactoryB = new TestingBuildOperatorFactory(202, joinBNodeId, buildStatesB);
            TestingBuildOperatorFactory buildOperatorFactoryC = new TestingBuildOperatorFactory(302, joinCNodeId, buildStatesC);
            LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = new LocalExecutionPlanner.LocalExecutionPlan((List)ImmutableList.of((Object)new DriverFactory(0, true, true, (List)ImmutableList.of((Object)scanOperatorFactory0, (Object)joinOperatorFactoryA, (Object)joinOperatorFactoryC, (Object)taskOutputOperatorFactory), OptionalInt.empty(), executionStrategy), (Object)new DriverFactory(1, false, false, (List)ImmutableList.of((Object)valuesOperatorFactory1, (Object)joinOperatorFactoryB, (Object)buildOperatorFactoryA), OptionalInt.empty(), executionStrategy), (Object)new DriverFactory(2, true, false, (List)ImmutableList.of((Object)scanOperatorFactory2, (Object)buildOperatorFactoryB), OptionalInt.empty(), executionStrategy), (Object)new DriverFactory(3, false, false, (List)ImmutableList.of((Object)valuesOperatorFactory3, (Object)buildOperatorFactoryC), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION)), (List)ImmutableList.of((Object)scan2NodeId, (Object)scan0NodeId), executionStrategy == PipelineExecutionStrategy.GROUPED_EXECUTION ? StageExecutionDescriptor.groupedExecution((List)ImmutableList.of((Object)scan0NodeId, (Object)scan2NodeId)) : StageExecutionDescriptor.ungroupedExecution());
            TaskContext taskContext = this.newTestingTaskContext(taskNotificationExecutor, driverYieldExecutor, taskStateMachine);
            SqlTaskExecution sqlTaskExecution = SqlTaskExecution.createSqlTaskExecution((TaskStateMachine)taskStateMachine, (TaskContext)taskContext, (OutputBuffer)outputBuffer, (List)ImmutableList.of(), (LocalExecutionPlanner.LocalExecutionPlan)localExecutionPlan, (TaskExecutor)taskExecutor, (Executor)taskNotificationExecutor, (SplitMonitor)TaskTestUtils.createTestSplitMonitor());
            Assert.assertEquals((Object)taskStateMachine.getState(), (Object)TaskState.RUNNING);
            switch (executionStrategy) {
                case UNGROUPED_EXECUTION: {
                    this.waitUntilEquals(joinOperatorFactoryB::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(buildOperatorFactoryA::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(buildOperatorFactoryC::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(scan2NodeId, (Set)ImmutableSet.of((Object)this.newScheduledSplit(0, scan2NodeId, Lifespan.taskWide(), 100000, 1), (Object)this.newScheduledSplit(1, scan2NodeId, Lifespan.taskWide(), 300000, 2)), false)));
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(scan2NodeId, (Set)ImmutableSet.of((Object)this.newScheduledSplit(2, scan2NodeId, Lifespan.taskWide(), 300000, 2)), true)));
                    this.waitUntilEquals(scanOperatorFactory2::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(buildOperatorFactoryB::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    scanOperatorFactory0.getPauser().pause();
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(scan0NodeId, (Set)ImmutableSet.of((Object)this.newScheduledSplit(3, scan0NodeId, Lifespan.taskWide(), 400000, 100)), true)));
                    this.waitUntilEquals(scanOperatorFactory0::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryA::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryC::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    Assert.assertEquals((Set)taskContext.getCompletedDriverGroups(), (Set)ImmutableSet.of());
                    scanOperatorFactory0.getPauser().resume();
                    outputBufferConsumer.consume(1500, ASSERT_WAIT_TIMEOUT);
                    outputBufferConsumer.assertBufferComplete(ASSERT_WAIT_TIMEOUT);
                    break;
                }
                case GROUPED_EXECUTION: {
                    this.waitUntilEquals(buildOperatorFactoryC::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(scan2NodeId, (Set)ImmutableSet.of((Object)this.newScheduledSplit(0, scan2NodeId, Lifespan.driverGroup((int)3), 0, 1), (Object)this.newScheduledSplit(1, scan2NodeId, Lifespan.driverGroup((int)3), 100000, 2)), false)));
                    this.waitUntilEquals(joinOperatorFactoryB::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(buildOperatorFactoryA::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), ASSERT_WAIT_TIMEOUT);
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(scan2NodeId, (Set)ImmutableSet.of((Object)this.newScheduledSplit(2, scan2NodeId, Lifespan.driverGroup((int)3), 200000, 2)), (Set)ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), false)));
                    this.waitUntilEquals(scanOperatorFactory2::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(buildOperatorFactoryB::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), ASSERT_WAIT_TIMEOUT);
                    scanOperatorFactory0.getPauser().pause();
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(scan0NodeId, (Set)ImmutableSet.of((Object)this.newScheduledSplit(3, scan0NodeId, Lifespan.driverGroup((int)3), 300000, 10)), (Set)ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), false)));
                    this.waitUntilEquals(scanOperatorFactory0::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryA::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryC::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), ASSERT_WAIT_TIMEOUT);
                    Assert.assertEquals((Set)taskContext.getCompletedDriverGroups(), (Set)ImmutableSet.of());
                    scanOperatorFactory0.getPauser().resume();
                    outputBufferConsumer.consume(150, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(() -> ((TaskContext)taskContext).getCompletedDriverGroups(), ImmutableSet.of((Object)Lifespan.driverGroup((int)3)), ASSERT_WAIT_TIMEOUT);
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(scan2NodeId, (Set)ImmutableSet.of((Object)this.newScheduledSplit(4, scan2NodeId, Lifespan.driverGroup((int)7), 400000, 2)), (Set)ImmutableSet.of((Object)Lifespan.driverGroup((int)7)), true)));
                    this.waitUntilEquals(scanOperatorFactory2::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(buildOperatorFactoryB::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    scanOperatorFactory0.getPauser().pause();
                    sqlTaskExecution.addSources((List)ImmutableList.of((Object)new TaskSource(scan0NodeId, (Set)ImmutableSet.of((Object)this.newScheduledSplit(5, scan0NodeId, Lifespan.driverGroup((int)7), 500000, 1000)), (Set)ImmutableSet.of((Object)Lifespan.driverGroup((int)7)), true)));
                    this.waitUntilEquals(scanOperatorFactory0::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryA::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryC::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(scanOperatorFactory0::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryA::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryC::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryB::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(buildOperatorFactoryA::getDriverGroupsWithNoMoreOperators, ImmutableSet.of((Object)Lifespan.driverGroup((int)3), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(joinOperatorFactoryB::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(buildOperatorFactoryA::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(scanOperatorFactory2::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(buildOperatorFactoryB::isOverallNoMoreOperators, true, ASSERT_WAIT_TIMEOUT);
                    Assert.assertEquals((Set)taskContext.getCompletedDriverGroups(), (Set)ImmutableSet.of((Object)Lifespan.driverGroup((int)3)));
                    scanOperatorFactory0.getPauser().resume();
                    outputBufferConsumer.consume(6000, ASSERT_WAIT_TIMEOUT);
                    outputBufferConsumer.assertBufferComplete(ASSERT_WAIT_TIMEOUT);
                    this.waitUntilEquals(() -> ((TaskContext)taskContext).getCompletedDriverGroups(), ImmutableSet.of((Object)Lifespan.driverGroup((int)3), (Object)Lifespan.driverGroup((int)7)), ASSERT_WAIT_TIMEOUT);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            outputBufferConsumer.abort();
            TaskState taskState = (TaskState)taskStateMachine.getStateChange(TaskState.RUNNING).get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)taskState, (Object)TaskState.FINISHED);
        }
        finally {
            taskExecutor.stop();
            taskNotificationExecutor.shutdownNow();
            driverYieldExecutor.shutdown();
        }
    }

    private TaskContext newTestingTaskContext(ScheduledExecutorService taskNotificationExecutor, ScheduledExecutorService driverYieldExecutor, TaskStateMachine taskStateMachine) {
        QueryContext queryContext = new QueryContext(new QueryId("queryid"), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(2.0, DataSize.Unit.MEGABYTE), new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)taskNotificationExecutor, driverYieldExecutor, new DataSize(1.0, DataSize.Unit.MEGABYTE), new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE)));
        return queryContext.addTaskContext(taskStateMachine, SessionTestUtils.TEST_SESSION, false, false, OptionalInt.empty());
    }

    private PartitionedOutputBuffer newTestingOutputBuffer(ScheduledExecutorService taskNotificationExecutor) {
        return new PartitionedOutputBuffer("task-id", new StateMachine("bufferState", (Executor)taskNotificationExecutor, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUTPUT_BUFFER_ID, 0).withNoMoreBufferIds(), new DataSize(1.0, DataSize.Unit.MEGABYTE), () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)taskNotificationExecutor);
    }

    private <T> void waitUntilEquals(Supplier<T> actualSupplier, T expected, Duration timeout) {
        long nanoUntil = System.nanoTime() + timeout.toMillis() * 1000000L;
        while (System.nanoTime() - nanoUntil < 0L) {
            if (expected.equals(actualSupplier.get())) {
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assert.assertEquals(actualSupplier.get(), expected);
    }

    private ScheduledSplit newScheduledSplit(int sequenceId, PlanNodeId planNodeId, Lifespan lifespan, int begin, int count) {
        return new ScheduledSplit((long)sequenceId, planNodeId, new Split(CONNECTOR_ID, (ConnectorSplit)new TestingSplit(begin, begin + count), lifespan));
    }

    public static class TestingSplit
    implements ConnectorSplit {
        private final int begin;
        private final int end;

        @JsonCreator
        public TestingSplit(@JsonProperty(value="begin") int begin, @JsonProperty(value="end") int end) {
            this.begin = begin;
            this.end = end;
        }

        public boolean isRemotelyAccessible() {
            return true;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return this;
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }
    }

    private static class BuildStates {
        private final HashMap<Lifespan, BuildState> buildStatesMap = new HashMap();
        private final boolean grouped;

        public BuildStates(PipelineExecutionStrategy executionStrategy) {
            this.grouped = executionStrategy == PipelineExecutionStrategy.GROUPED_EXECUTION;
        }

        public synchronized BuildState get(Lifespan lifespan) {
            if (this.grouped) {
                return this.buildStatesMap.computeIfAbsent(lifespan, ignored -> new BuildState());
            }
            return this.buildStatesMap.computeIfAbsent(Lifespan.taskWide(), ignored -> new BuildState());
        }

        public void setNoNewLookups(Lifespan lifespan) {
            if (this.grouped) {
                this.get(lifespan).setNoNewLookups();
            }
        }

        public void setNoNewLookups() {
            if (!this.grouped) {
                this.get(Lifespan.taskWide()).setNoNewLookups();
            }
        }

        private static class BuildState {
            private final SettableFuture<List<Page>> pagesFuture = SettableFuture.create();
            private final SettableFuture<?> lookupDoneFuture = SettableFuture.create();
            private final List<Page> pages = new ArrayList<Page>();
            private int pendingBuildCount;
            private boolean noNewBuilds;
            private int pendingLookupCount;
            private boolean noNewLookups;

            private BuildState() {
            }

            public synchronized void addBuildResult(List<Page> newPages) {
                Preconditions.checkState((!this.pagesFuture.isDone() ? 1 : 0) != 0);
                this.pages.addAll(newPages);
                --this.pendingBuildCount;
                this.checkAllBuildsDone();
            }

            public synchronized void incrementPendingBuildCount() {
                Preconditions.checkState((!this.noNewBuilds ? 1 : 0) != 0);
                ++this.pendingBuildCount;
            }

            public synchronized void setNoNewBuilds() {
                if (this.noNewBuilds) {
                    return;
                }
                Preconditions.checkState((!this.pagesFuture.isDone() ? 1 : 0) != 0);
                this.noNewBuilds = true;
                this.checkAllBuildsDone();
            }

            public synchronized void checkAllBuildsDone() {
                if (this.pendingBuildCount == 0 && this.noNewBuilds) {
                    this.pagesFuture.set(this.pages);
                }
            }

            public ListenableFuture<List<Page>> getPagesFuture() {
                return this.pagesFuture;
            }

            public synchronized void decrementPendingLookupCount() {
                Preconditions.checkState((!this.lookupDoneFuture.isDone() ? 1 : 0) != 0);
                --this.pendingLookupCount;
                this.checkAllLookupsDone();
            }

            public synchronized void incrementPendingLookupCount() {
                Preconditions.checkState((!this.noNewLookups ? 1 : 0) != 0);
                ++this.pendingLookupCount;
            }

            synchronized void setNoNewLookups() {
                if (this.noNewLookups) {
                    return;
                }
                Preconditions.checkState((!this.lookupDoneFuture.isDone() ? 1 : 0) != 0);
                this.noNewLookups = true;
                this.checkAllLookupsDone();
            }

            public synchronized void checkAllLookupsDone() {
                if (this.pendingLookupCount == 0 && this.noNewLookups) {
                    this.lookupDoneFuture.set(null);
                }
            }

            public ListenableFuture<?> getLookupDoneFuture() {
                return this.lookupDoneFuture;
            }
        }
    }

    public static class TestingCrossJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Pauser pauser = new Pauser();
        private final Set<Lifespan> driverGroupsWithNoMoreOperators = new HashSet<Lifespan>();
        private boolean overallNoMoreOperators;
        private final BuildStates buildStates;

        public TestingCrossJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, BuildStates buildStates) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.buildStates = Objects.requireNonNull(buildStates, "buildStates is null");
        }

        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.overallNoMoreOperators ? 1 : 0) != 0, (Object)"noMoreOperators() has been called");
            Preconditions.checkState((!this.driverGroupsWithNoMoreOperators.contains(driverContext.getLifespan()) ? 1 : 0) != 0, (Object)"noMoreOperators(lifespan) has been called");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TestingCrossJoinOperator.class.getSimpleName());
            this.buildStates.get(driverContext.getLifespan()).incrementPendingLookupCount();
            return new TestingCrossJoinOperator(operatorContext, driverContext.getLifespan());
        }

        public synchronized void noMoreOperators(Lifespan lifespan) {
            Preconditions.checkArgument((!this.driverGroupsWithNoMoreOperators.contains(lifespan) ? 1 : 0) != 0);
            this.buildStates.setNoNewLookups(lifespan);
            this.driverGroupsWithNoMoreOperators.add(lifespan);
        }

        public void noMoreOperators() {
            this.buildStates.setNoNewLookups();
            this.overallNoMoreOperators = true;
        }

        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException();
        }

        public synchronized Set<Lifespan> getDriverGroupsWithNoMoreOperators() {
            return ImmutableSet.copyOf(this.driverGroupsWithNoMoreOperators);
        }

        public boolean isOverallNoMoreOperators() {
            return this.overallNoMoreOperators;
        }

        public Pauser getPauser() {
            return this.pauser;
        }

        public class TestingCrossJoinOperator
        implements Operator {
            private final OperatorContext operatorContext;
            private final Lifespan lifespan;
            private final ListenableFuture<Integer> multiplierFuture;
            private final Queue<Page> pages = new ArrayDeque<Page>();
            private boolean finishing;

            public TestingCrossJoinOperator(OperatorContext operatorContext, Lifespan lifespan) {
                this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
                this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
                this.multiplierFuture = Futures.transform(TestingCrossJoinOperatorFactory.this.buildStates.get(lifespan).getPagesFuture(), buildPages -> {
                    Objects.requireNonNull(buildPages, "buildPages is null");
                    return buildPages.stream().mapToInt(Page::getPositionCount).sum();
                }, (Executor)MoreExecutors.directExecutor());
            }

            public OperatorContext getOperatorContext() {
                return this.operatorContext;
            }

            public void finish() {
                if (this.finishing) {
                    return;
                }
                this.finishing = true;
            }

            public ListenableFuture<?> isBlocked() {
                return this.multiplierFuture;
            }

            public boolean isFinished() {
                return this.finishing && this.pages.isEmpty();
            }

            public boolean needsInput() {
                return !this.finishing && this.multiplierFuture.isDone();
            }

            public void addInput(Page page) {
                int multiplier = (Integer)MoreFutures.getFutureValue(this.multiplierFuture);
                for (int i = 0; i < multiplier; ++i) {
                    this.pages.add(page);
                }
            }

            public Page getOutput() {
                Page result = this.pages.poll();
                if (this.isFinished() && this.pages.isEmpty()) {
                    TestingCrossJoinOperatorFactory.this.buildStates.get(this.lifespan).decrementPendingLookupCount();
                }
                return result;
            }
        }
    }

    public static class TestingBuildOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Pauser pauser = new Pauser();
        private final Set<Lifespan> driverGroupsWithNoMoreOperators = new HashSet<Lifespan>();
        private boolean overallNoMoreOperators;
        private final BuildStates buildStates;

        public TestingBuildOperatorFactory(int operatorId, PlanNodeId planNodeId, BuildStates buildStates) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.buildStates = Objects.requireNonNull(buildStates, "buildStates is null");
        }

        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.overallNoMoreOperators ? 1 : 0) != 0, (Object)"noMoreOperators() has been called");
            Preconditions.checkState((!this.driverGroupsWithNoMoreOperators.contains(driverContext.getLifespan()) ? 1 : 0) != 0, (Object)"noMoreOperators(lifespan) has been called");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TestingBuildOperator.class.getSimpleName());
            this.buildStates.get(driverContext.getLifespan()).incrementPendingBuildCount();
            return new TestingBuildOperator(operatorContext, driverContext.getLifespan());
        }

        public synchronized void noMoreOperators(Lifespan lifespan) {
            Preconditions.checkArgument((!this.driverGroupsWithNoMoreOperators.contains(lifespan) ? 1 : 0) != 0);
            this.buildStates.get(lifespan).setNoNewBuilds();
            this.driverGroupsWithNoMoreOperators.add(lifespan);
        }

        public void noMoreOperators() {
            this.overallNoMoreOperators = true;
        }

        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException();
        }

        public synchronized Set<Lifespan> getDriverGroupsWithNoMoreOperators() {
            return ImmutableSet.copyOf(this.driverGroupsWithNoMoreOperators);
        }

        public boolean isOverallNoMoreOperators() {
            return this.overallNoMoreOperators;
        }

        public Pauser getPauser() {
            return this.pauser;
        }

        public class TestingBuildOperator
        implements Operator {
            private final OperatorContext operatorContext;
            private final Lifespan lifespan;
            private final List<Page> pages = new ArrayList<Page>();
            private boolean finishing;

            public TestingBuildOperator(OperatorContext operatorContext, Lifespan lifespan) {
                this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
                this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
            }

            public OperatorContext getOperatorContext() {
                return this.operatorContext;
            }

            public void finish() {
                if (this.finishing) {
                    return;
                }
                this.finishing = true;
                TestingBuildOperatorFactory.this.buildStates.get(this.lifespan).addBuildResult(this.pages);
            }

            public ListenableFuture<?> isBlocked() {
                if (!this.finishing) {
                    return NOT_BLOCKED;
                }
                return TestingBuildOperatorFactory.this.buildStates.get(this.lifespan).getLookupDoneFuture();
            }

            public boolean isFinished() {
                return this.finishing && TestingBuildOperatorFactory.this.buildStates.get(this.lifespan).getLookupDoneFuture().isDone();
            }

            public boolean needsInput() {
                return !this.finishing;
            }

            public void addInput(Page page) {
                this.pages.add(page);
            }

            public Page getOutput() {
                return null;
            }
        }
    }

    public static class TestingScanOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final Pauser pauser = new Pauser();
        private final Set<Lifespan> driverGroupsWithNoMoreOperators = new HashSet<Lifespan>();
        private boolean overallNoMoreOperators;

        public TestingScanOperatorFactory(int operatorId, PlanNodeId sourceId, List<Type> types) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        }

        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.overallNoMoreOperators ? 1 : 0) != 0, (Object)"noMoreOperators() has been called");
            Preconditions.checkState((!this.driverGroupsWithNoMoreOperators.contains(driverContext.getLifespan()) ? 1 : 0) != 0, (Object)"noMoreOperators(lifespan) has been called");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, TestingScanOperator.class.getSimpleName());
            return new TestingScanOperator(operatorContext, this.sourceId, driverContext.getLifespan());
        }

        public synchronized void noMoreOperators(Lifespan lifespan) {
            Preconditions.checkArgument((!this.driverGroupsWithNoMoreOperators.contains(lifespan) ? 1 : 0) != 0);
            this.driverGroupsWithNoMoreOperators.add(lifespan);
        }

        public void noMoreOperators() {
            this.overallNoMoreOperators = true;
        }

        public synchronized Set<Lifespan> getDriverGroupsWithNoMoreOperators() {
            return ImmutableSet.copyOf(this.driverGroupsWithNoMoreOperators);
        }

        public boolean isOverallNoMoreOperators() {
            return this.overallNoMoreOperators;
        }

        public Pauser getPauser() {
            return this.pauser;
        }

        public class TestingScanOperator
        implements SourceOperator {
            private final OperatorContext operatorContext;
            private final PlanNodeId planNodeId;
            private final Lifespan lifespan;
            private final SettableFuture<?> blocked = SettableFuture.create();
            private TestingSplit split;
            private boolean finished;

            public TestingScanOperator(OperatorContext operatorContext, PlanNodeId planNodeId, Lifespan lifespan) {
                this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
                this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
                this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
            }

            public OperatorContext getOperatorContext() {
                return this.operatorContext;
            }

            public PlanNodeId getSourceId() {
                return this.planNodeId;
            }

            public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
                Objects.requireNonNull(split, "split is null");
                Preconditions.checkState((this.split == null ? 1 : 0) != 0, (Object)"Table scan split already set");
                if (this.finished) {
                    return Optional::empty;
                }
                this.split = (TestingSplit)split.getConnectorSplit();
                this.blocked.set(null);
                return Optional::empty;
            }

            public void noMoreSplits() {
                if (this.split == null) {
                    this.finish();
                }
                this.blocked.set(null);
            }

            public void close() {
                this.finish();
            }

            public void finish() {
                this.finished = true;
            }

            public boolean isFinished() {
                return this.finished;
            }

            public ListenableFuture<?> isBlocked() {
                return this.blocked;
            }

            public boolean needsInput() {
                return false;
            }

            public void addInput(Page page) {
                throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
            }

            public Page getOutput() {
                if (this.split == null) {
                    return null;
                }
                TestingScanOperatorFactory.this.pauser.await();
                Page result = new Page(new Block[]{BlockAssertions.createStringSequenceBlock(this.split.getBegin(), this.split.getEnd())});
                this.finish();
                return result;
            }
        }
    }

    public static class Pauser {
        private volatile SettableFuture<?> future = SettableFuture.create();

        public Pauser() {
            this.future.set(null);
        }

        public void pause() {
            if (!this.future.isDone()) {
                return;
            }
            this.future = SettableFuture.create();
        }

        public void resume() {
            if (this.future.isDone()) {
                return;
            }
            this.future.set(null);
        }

        public void await() {
            try {
                this.future.get();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class OutputBufferConsumer {
        private final OutputBuffer outputBuffer;
        private final OutputBuffers.OutputBufferId outputBufferId;
        private int sequenceId;
        private int surplusPositions;
        private boolean bufferComplete;

        public OutputBufferConsumer(OutputBuffer outputBuffer, OutputBuffers.OutputBufferId outputBufferId) {
            this.outputBuffer = outputBuffer;
            this.outputBufferId = outputBufferId;
        }

        public void consume(int positions, Duration timeout) throws ExecutionException, InterruptedException, TimeoutException {
            long nanoUntil = System.nanoTime() + timeout.toMillis() * 1000000L;
            this.surplusPositions -= positions;
            while (this.surplusPositions < 0) {
                Assert.assertFalse((boolean)this.bufferComplete, (String)"bufferComplete is set before enough positions are consumed");
                BufferResult results = (BufferResult)this.outputBuffer.get(this.outputBufferId, (long)this.sequenceId, new DataSize(1.0, DataSize.Unit.MEGABYTE)).get(nanoUntil - System.nanoTime(), TimeUnit.NANOSECONDS);
                this.bufferComplete = results.isBufferComplete();
                for (SerializedPage serializedPage : results.getSerializedPages()) {
                    this.surplusPositions += serializedPage.getPositionCount();
                }
                this.sequenceId += results.getSerializedPages().size();
            }
        }

        public void assertBufferComplete(Duration timeout) throws InterruptedException, ExecutionException, TimeoutException {
            Assert.assertEquals((int)this.surplusPositions, (int)0);
            long nanoUntil = System.nanoTime() + timeout.toMillis() * 1000000L;
            while (!this.bufferComplete) {
                BufferResult results = (BufferResult)this.outputBuffer.get(this.outputBufferId, (long)this.sequenceId, new DataSize(1.0, DataSize.Unit.MEGABYTE)).get(nanoUntil - System.nanoTime(), TimeUnit.NANOSECONDS);
                this.bufferComplete = results.isBufferComplete();
                for (SerializedPage serializedPage : results.getSerializedPages()) {
                    Assert.assertEquals((int)serializedPage.getPositionCount(), (int)0);
                }
                this.sequenceId += results.getSerializedPages().size();
            }
        }

        public void abort() {
            this.outputBuffer.abort(this.outputBufferId);
            Assert.assertEquals((Object)this.outputBuffer.getInfo().getState(), (Object)BufferState.FINISHED);
        }
    }
}

