/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.executor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.airlift.units.Duration;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.executor.SimulationController;
import io.prestosql.execution.executor.SimulationSplit;
import io.prestosql.execution.executor.SplitSpecification;
import io.prestosql.execution.executor.TaskExecutor;
import io.prestosql.execution.executor.TaskHandle;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class SimulationTask {
    private final SimulationController.TaskSpecification specification;
    private final TaskId taskId;
    private final Set<SimulationSplit> runningSplits = Sets.newConcurrentHashSet();
    private final Set<SimulationSplit> completedSplits = Sets.newConcurrentHashSet();
    private final TaskHandle taskHandle;
    private final AtomicBoolean killed = new AtomicBoolean();

    public SimulationTask(TaskExecutor taskExecutor, SimulationController.TaskSpecification specification, TaskId taskId) {
        this.specification = specification;
        this.taskId = taskId;
        this.taskHandle = taskExecutor.addTask(taskId, () -> 0.0, 10, new Duration(1.0, TimeUnit.SECONDS), OptionalInt.empty());
    }

    public void setKilled() {
        this.killed.set(true);
    }

    public boolean isKilled() {
        return this.killed.get();
    }

    public Set<SimulationSplit> getCompletedSplits() {
        return this.completedSplits;
    }

    TaskId getTaskId() {
        return this.taskId;
    }

    public TaskHandle getTaskHandle() {
        return this.taskHandle;
    }

    public Set<SimulationSplit> getRunningSplits() {
        return this.runningSplits;
    }

    public synchronized void splitComplete(SimulationSplit split) {
        this.runningSplits.remove(split);
        this.completedSplits.add(split);
    }

    public SimulationController.TaskSpecification getSpecification() {
        return this.specification;
    }

    public long getTotalWaitTimeNanos() {
        long runningWaitTime = this.runningSplits.stream().mapToLong(SimulationSplit::getWaitNanos).sum();
        long completedWaitTime = this.completedSplits.stream().mapToLong(SimulationSplit::getWaitNanos).sum();
        return runningWaitTime + completedWaitTime;
    }

    public long getProcessedTimeNanos() {
        long runningProcessedTime = this.runningSplits.stream().mapToLong(SimulationSplit::getCompletedProcessNanos).sum();
        long completedProcessedTime = this.completedSplits.stream().mapToLong(SimulationSplit::getCompletedProcessNanos).sum();
        return runningProcessedTime + completedProcessedTime;
    }

    public long getScheduledTimeNanos() {
        long runningWallTime = this.runningSplits.stream().mapToLong(SimulationSplit::getScheduledTimeNanos).sum();
        long completedWallTime = this.completedSplits.stream().mapToLong(SimulationSplit::getScheduledTimeNanos).sum();
        return runningWallTime + completedWallTime;
    }

    public abstract void schedule(TaskExecutor var1, int var2);

    public static class IntermediateTask
    extends SimulationTask {
        private final SplitSpecification splitSpecification;

        public IntermediateTask(TaskExecutor taskExecutor, SimulationController.TaskSpecification specification, TaskId taskId) {
            super(taskExecutor, specification, taskId);
            this.splitSpecification = specification.nextSpecification();
        }

        @Override
        public void schedule(TaskExecutor taskExecutor, int numSplits) {
            ImmutableList.Builder splits = ImmutableList.builder();
            for (int i = 0; i < numSplits; ++i) {
                splits.add((Object)this.splitSpecification.instantiate(this));
            }
            ((SimulationTask)this).runningSplits.addAll(splits.build());
            taskExecutor.enqueueSplits(this.getTaskHandle(), true, (List)splits.build());
        }
    }

    public static class LeafTask
    extends SimulationTask {
        private final SimulationController.TaskSpecification taskSpecification;

        public LeafTask(TaskExecutor taskExecutor, SimulationController.TaskSpecification specification, TaskId taskId) {
            super(taskExecutor, specification, taskId);
            this.taskSpecification = specification;
        }

        @Override
        public void schedule(TaskExecutor taskExecutor, int numSplits) {
            ImmutableList.Builder splits = ImmutableList.builder();
            for (int i = 0; i < numSplits; ++i) {
                splits.add((Object)this.taskSpecification.nextSpecification().instantiate(this));
            }
            ((SimulationTask)this).runningSplits.addAll(splits.build());
            taskExecutor.enqueueSplits(this.getTaskHandle(), false, (List)splits.build());
        }
    }
}

