/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.resourcegroups;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.execution.ManagedQueryExecution;
import io.prestosql.execution.MockQueryExecution;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.resourcegroups.InternalResourceGroup;
import io.prestosql.server.QueryStateInfo;
import io.prestosql.server.ResourceGroupInfo;
import io.prestosql.spi.resourcegroups.ResourceGroupState;
import io.prestosql.spi.resourcegroups.SchedulingPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestResourceGroups {
    @Test(timeOut=10000L)
    public void testQueueFull() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(1);
        root.setHardConcurrencyLimit(1);
        MockQueryExecution query1 = new MockQueryExecution(0L);
        root.run((ManagedQueryExecution)query1);
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockQueryExecution query2 = new MockQueryExecution(0L);
        root.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query3 = new MockQueryExecution(0L);
        root.run((ManagedQueryExecution)query3);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((String)query3.getThrowable().getMessage(), (String)"Too many queued queries for \"root\"");
    }

    @Test(timeOut=10000L)
    public void testFairEligibility() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(1);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group1.setMaxQueuedQueries(4);
        group1.setHardConcurrencyLimit(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group2.setMaxQueuedQueries(4);
        group2.setHardConcurrencyLimit(1);
        InternalResourceGroup group3 = root.getOrCreateSubGroup("3");
        group3.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group3.setMaxQueuedQueries(4);
        group3.setHardConcurrencyLimit(1);
        MockQueryExecution query1a = new MockQueryExecution(0L);
        group1.run((ManagedQueryExecution)query1a);
        Assert.assertEquals((Object)query1a.getState(), (Object)QueryState.RUNNING);
        MockQueryExecution query1b = new MockQueryExecution(0L);
        group1.run((ManagedQueryExecution)query1b);
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query2a = new MockQueryExecution(0L);
        group2.run((ManagedQueryExecution)query2a);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query2b = new MockQueryExecution(0L);
        group2.run((ManagedQueryExecution)query2b);
        Assert.assertEquals((Object)query2b.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query3a = new MockQueryExecution(0L);
        group3.run((ManagedQueryExecution)query3a);
        Assert.assertEquals((Object)query3a.getState(), (Object)QueryState.QUEUED);
        query1a.complete();
        root.processQueuedQueries();
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query2b.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query3a.getState(), (Object)QueryState.QUEUED);
        query2a.complete();
        root.processQueuedQueries();
        Assert.assertEquals((Object)query3a.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query2b.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        query3a.complete();
        root.processQueuedQueries();
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query2b.getState(), (Object)QueryState.QUEUED);
    }

    @Test
    public void testSetSchedulingPolicy() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(1);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group1.setMaxQueuedQueries(4);
        group1.setHardConcurrencyLimit(2);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group2.setMaxQueuedQueries(4);
        group2.setHardConcurrencyLimit(2);
        MockQueryExecution query1a = new MockQueryExecution(0L);
        group1.run((ManagedQueryExecution)query1a);
        Assert.assertEquals((Object)query1a.getState(), (Object)QueryState.RUNNING);
        MockQueryExecution query1b = new MockQueryExecution(0L);
        group1.run((ManagedQueryExecution)query1b);
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query1c = new MockQueryExecution(0L);
        group1.run((ManagedQueryExecution)query1c);
        Assert.assertEquals((Object)query1c.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query2a = new MockQueryExecution(0L);
        group2.run((ManagedQueryExecution)query2a);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((int)root.getInfo().getNumEligibleSubGroups(), (int)2);
        Assert.assertEquals((int)root.getOrCreateSubGroup("1").getQueuedQueries(), (int)2);
        Assert.assertEquals((int)root.getOrCreateSubGroup("2").getQueuedQueries(), (int)1);
        Assert.assertEquals((Object)root.getSchedulingPolicy(), (Object)SchedulingPolicy.FAIR);
        root.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        Assert.assertEquals((int)root.getInfo().getNumEligibleSubGroups(), (int)2);
        Assert.assertEquals((int)root.getOrCreateSubGroup("1").getQueuedQueries(), (int)2);
        Assert.assertEquals((int)root.getOrCreateSubGroup("2").getQueuedQueries(), (int)1);
        Assert.assertEquals((Object)root.getSchedulingPolicy(), (Object)SchedulingPolicy.QUERY_PRIORITY);
        Assert.assertEquals((Object)root.getOrCreateSubGroup("1").getSchedulingPolicy(), (Object)SchedulingPolicy.QUERY_PRIORITY);
        Assert.assertEquals((Object)root.getOrCreateSubGroup("2").getSchedulingPolicy(), (Object)SchedulingPolicy.QUERY_PRIORITY);
    }

    @Test(timeOut=10000L)
    public void testFairQueuing() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(1);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group1.setMaxQueuedQueries(4);
        group1.setHardConcurrencyLimit(2);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group2.setMaxQueuedQueries(4);
        group2.setHardConcurrencyLimit(2);
        MockQueryExecution query1a = new MockQueryExecution(0L);
        group1.run((ManagedQueryExecution)query1a);
        Assert.assertEquals((Object)query1a.getState(), (Object)QueryState.RUNNING);
        MockQueryExecution query1b = new MockQueryExecution(0L);
        group1.run((ManagedQueryExecution)query1b);
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query1c = new MockQueryExecution(0L);
        group1.run((ManagedQueryExecution)query1c);
        Assert.assertEquals((Object)query1c.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query2a = new MockQueryExecution(0L);
        group2.run((ManagedQueryExecution)query2a);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.QUEUED);
        query1a.complete();
        root.processQueuedQueries();
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query1c.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.QUEUED);
        query1b.complete();
        root.processQueuedQueries();
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query1c.getState(), (Object)QueryState.QUEUED);
    }

    @Test(timeOut=10000L)
    public void testMemoryLimit() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.BYTE));
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(3);
        MockQueryExecution query1 = new MockQueryExecution(2L);
        root.run((ManagedQueryExecution)query1);
        root.processQueuedQueries();
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockQueryExecution query2 = new MockQueryExecution(0L);
        root.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query3 = new MockQueryExecution(0L);
        root.run((ManagedQueryExecution)query3);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.QUEUED);
        query1.complete();
        root.processQueuedQueries();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.RUNNING);
    }

    @Test
    public void testSubgroupMemoryLimit() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(10.0, DataSize.Unit.BYTE));
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(3);
        InternalResourceGroup subgroup = root.getOrCreateSubGroup("subgroup");
        subgroup.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.BYTE));
        subgroup.setMaxQueuedQueries(4);
        subgroup.setHardConcurrencyLimit(3);
        MockQueryExecution query1 = new MockQueryExecution(2L);
        subgroup.run((ManagedQueryExecution)query1);
        root.processQueuedQueries();
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockQueryExecution query2 = new MockQueryExecution(0L);
        subgroup.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        MockQueryExecution query3 = new MockQueryExecution(0L);
        subgroup.run((ManagedQueryExecution)query3);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.QUEUED);
        query1.complete();
        root.processQueuedQueries();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testSoftCpuLimit() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.BYTE));
        root.setSoftCpuLimit(new Duration(1.0, TimeUnit.SECONDS));
        root.setHardCpuLimit(new Duration(2.0, TimeUnit.SECONDS));
        root.setCpuQuotaGenerationMillisPerSecond(2000L);
        root.setMaxQueuedQueries(1);
        root.setHardConcurrencyLimit(2);
        MockQueryExecution query1 = new MockQueryExecution(1L, "query_id", 1, new Duration(1.0, TimeUnit.SECONDS));
        root.run((ManagedQueryExecution)query1);
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockQueryExecution query2 = new MockQueryExecution(0L);
        root.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        MockQueryExecution query3 = new MockQueryExecution(0L);
        root.run((ManagedQueryExecution)query3);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.QUEUED);
        query1.complete();
        root.processQueuedQueries();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        root.processQueuedQueries();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testHardCpuLimit() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.BYTE));
        root.setHardCpuLimit(new Duration(1.0, TimeUnit.SECONDS));
        root.setCpuQuotaGenerationMillisPerSecond(2000L);
        root.setMaxQueuedQueries(1);
        root.setHardConcurrencyLimit(1);
        MockQueryExecution query1 = new MockQueryExecution(1L, "query_id", 1, new Duration(2.0, TimeUnit.SECONDS));
        root.run((ManagedQueryExecution)query1);
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockQueryExecution query2 = new MockQueryExecution(0L);
        root.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        query1.complete();
        root.processQueuedQueries();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        root.processQueuedQueries();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testPriorityScheduling() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(100);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group1.setMaxQueuedQueries(100);
        group1.setHardConcurrencyLimit(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group2.setMaxQueuedQueries(100);
        group2.setHardConcurrencyLimit(1);
        TreeMap<Integer, MockQueryExecution> queries = new TreeMap<Integer, MockQueryExecution>();
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            int priority;
            while (queries.containsKey(priority = random.nextInt(1000000) + 1)) {
            }
            MockQueryExecution query = new MockQueryExecution(0L, "query_id", priority);
            if (random.nextBoolean()) {
                group1.run((ManagedQueryExecution)query);
            } else {
                group2.run((ManagedQueryExecution)query);
            }
            queries.put(priority, query);
        }
        root.setHardConcurrencyLimit(1);
        ArrayList orderedQueries = new ArrayList(queries.values());
        Collections.reverse(orderedQueries);
        for (MockQueryExecution query : orderedQueries) {
            root.processQueuedQueries();
            Assert.assertEquals((Object)query.getState(), (Object)QueryState.RUNNING);
            query.complete();
        }
    }

    @Test(timeOut=10000L)
    public void testWeightedScheduling() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group1.setMaxQueuedQueries(2);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group2.setMaxQueuedQueries(2);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(2);
        Set<MockQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockQueryExecution>)ImmutableSet.of(), 2);
        Set<MockQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockQueryExecution>)ImmutableSet.of(), 2);
        root.setHardConcurrencyLimit(1);
        int group2Ran = 0;
        for (int i = 0; i < 1000; ++i) {
            Iterator<MockQueryExecution> iterator = group1Queries.iterator();
            while (iterator.hasNext()) {
                MockQueryExecution query = iterator.next();
                if (query.getState() != QueryState.RUNNING) continue;
                query.complete();
                iterator.remove();
            }
            group2Ran += TestResourceGroups.completeGroupQueries(group2Queries);
            root.processQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 2);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 2);
        }
        BinomialDistribution binomial = new BinomialDistribution(1000, 0.6666666666666666);
        int lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        int upperBound = binomial.inverseCumulativeProbability(0.999999);
        Assertions.assertLessThan((Comparable)Integer.valueOf(group2Ran), (Comparable)Integer.valueOf(upperBound));
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(group2Ran), (Comparable)Integer.valueOf(lowerBound));
    }

    @Test(timeOut=10000L)
    public void testWeightedFairScheduling() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(50);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED_FAIR);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group1.setMaxQueuedQueries(50);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        group1.setSchedulingWeight(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group2.setMaxQueuedQueries(50);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(2);
        Set<MockQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockQueryExecution>)ImmutableSet.of(), 4);
        Set<MockQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockQueryExecution>)ImmutableSet.of(), 4);
        root.setHardConcurrencyLimit(3);
        int group1Ran = 0;
        int group2Ran = 0;
        for (int i = 0; i < 1000; ++i) {
            group1Ran += TestResourceGroups.completeGroupQueries(group1Queries);
            group2Ran += TestResourceGroups.completeGroupQueries(group2Queries);
            root.processQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 4);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 4);
        }
        Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group1Ran), (Comparable)Integer.valueOf(995), (Comparable)Integer.valueOf(1000));
        Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group2Ran), (Comparable)Integer.valueOf(1995), (Comparable)Integer.valueOf(2000));
    }

    @Test(timeOut=10000L)
    public void testWeightedFairSchedulingEqualWeights() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(50);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED_FAIR);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group1.setMaxQueuedQueries(50);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        group1.setSchedulingWeight(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group2.setMaxQueuedQueries(50);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(1);
        InternalResourceGroup group3 = root.getOrCreateSubGroup("3");
        group3.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group3.setMaxQueuedQueries(50);
        group3.setHardConcurrencyLimit(2);
        group3.setSoftConcurrencyLimit(2);
        group3.setSchedulingWeight(2);
        Set<MockQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockQueryExecution>)ImmutableSet.of(), 4);
        Set<MockQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockQueryExecution>)ImmutableSet.of(), 4);
        Set<MockQueryExecution> group3Queries = TestResourceGroups.fillGroupTo(group3, (Set<MockQueryExecution>)ImmutableSet.of(), 4);
        root.setHardConcurrencyLimit(4);
        int group1Ran = 0;
        int group2Ran = 0;
        int group3Ran = 0;
        for (int i = 0; i < 1000; ++i) {
            group1Ran += TestResourceGroups.completeGroupQueries(group1Queries);
            group2Ran += TestResourceGroups.completeGroupQueries(group2Queries);
            group3Ran += TestResourceGroups.completeGroupQueries(group3Queries);
            root.processQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 4);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 4);
            group3Queries = TestResourceGroups.fillGroupTo(group3, group3Queries, 4);
        }
        BinomialDistribution binomial = new BinomialDistribution(4000, 0.25);
        int lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        int upperBound = binomial.inverseCumulativeProbability(0.999999);
        Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group1Ran), (Comparable)Integer.valueOf(lowerBound), (Comparable)Integer.valueOf(upperBound));
        Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group2Ran), (Comparable)Integer.valueOf(lowerBound), (Comparable)Integer.valueOf(upperBound));
        Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group3Ran), (Comparable)Integer.valueOf(2 * lowerBound), (Comparable)Integer.valueOf(2 * upperBound));
    }

    @Test(timeOut=10000L)
    public void testWeightedFairSchedulingNoStarvation() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(50);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED_FAIR);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group1.setMaxQueuedQueries(50);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        group1.setSchedulingWeight(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        group2.setMaxQueuedQueries(50);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(2);
        Set<MockQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockQueryExecution>)ImmutableSet.of(), 4);
        Set<MockQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockQueryExecution>)ImmutableSet.of(), 4);
        root.setHardConcurrencyLimit(1);
        int group1Ran = 0;
        for (int i = 0; i < 2000; ++i) {
            group1Ran += TestResourceGroups.completeGroupQueries(group1Queries);
            TestResourceGroups.completeGroupQueries(group2Queries);
            root.processQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 4);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 4);
        }
        Assert.assertEquals((int)group1Ran, (int)1000);
        Assert.assertEquals((int)group1Ran, (int)1000);
    }

    @Test
    public void testGetInfo() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(2);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(2);
        rootB.setSchedulingWeight(2);
        rootB.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(10);
        InternalResourceGroup rootBX = rootB.getOrCreateSubGroup("x");
        rootBX.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootBX.setMaxQueuedQueries(10);
        rootBX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootBY = rootB.getOrCreateSubGroup("y");
        rootBY.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootBY.setMaxQueuedQueries(10);
        rootBY.setHardConcurrencyLimit(10);
        Set<MockQueryExecution> queries = TestResourceGroups.fillGroupTo(rootAX, (Set<MockQueryExecution>)ImmutableSet.of(), 10, false);
        queries.addAll(TestResourceGroups.fillGroupTo(rootAY, (Set<MockQueryExecution>)ImmutableSet.of(), 10, false));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBX, (Set<MockQueryExecution>)ImmutableSet.of(), 10, true));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBY, (Set<MockQueryExecution>)ImmutableSet.of(), 10, true));
        ResourceGroupInfo info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)0);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)40);
        root.setHardConcurrencyLimit(4);
        root.processQueuedQueries();
        info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)4);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)36);
        Iterator<MockQueryExecution> iterator = queries.iterator();
        while (iterator.hasNext()) {
            MockQueryExecution query = iterator.next();
            if (query.getState() != QueryState.RUNNING) continue;
            query.complete();
            iterator.remove();
        }
        root.processQueuedQueries();
        info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)4);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)32);
        root.setHardConcurrencyLimit(10);
        root.processQueuedQueries();
        info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)4);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)32);
        rootB.setHardConcurrencyLimit(10);
        root.processQueuedQueries();
        info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)10);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)26);
    }

    @Test
    public void testGetResourceGroupStateInfo() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(10);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimit(new DataSize(10.0, DataSize.Unit.MEGABYTE));
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(0);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimit(new DataSize(5.0, DataSize.Unit.MEGABYTE));
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(1);
        rootB.setSchedulingWeight(2);
        rootB.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(10);
        Set<MockQueryExecution> queries = TestResourceGroups.fillGroupTo(rootAX, (Set<MockQueryExecution>)ImmutableSet.of(), 5, false);
        queries.addAll(TestResourceGroups.fillGroupTo(rootAY, (Set<MockQueryExecution>)ImmutableSet.of(), 5, false));
        queries.addAll(TestResourceGroups.fillGroupTo(rootB, (Set<MockQueryExecution>)ImmutableSet.of(), 10, true));
        ResourceGroupInfo rootInfo = root.getFullInfo();
        Assert.assertEquals((Object)rootInfo.getId(), (Object)root.getId());
        Assert.assertEquals((Object)rootInfo.getState(), (Object)ResourceGroupState.CAN_RUN);
        Assert.assertEquals((Object)rootInfo.getSoftMemoryLimit(), (Object)root.getSoftMemoryLimit());
        Assert.assertEquals((Object)rootInfo.getMemoryUsage(), (Object)new DataSize(0.0, DataSize.Unit.BYTE));
        Assert.assertEquals((int)rootInfo.getSubGroups().size(), (int)2);
        TestResourceGroups.assertGroupInfoEquals((ResourceGroupInfo)rootInfo.getSubGroups().get(0), rootA.getInfo());
        Assert.assertEquals((Object)((ResourceGroupInfo)rootInfo.getSubGroups().get(0)).getId(), (Object)rootA.getId());
        Assert.assertEquals((Object)((ResourceGroupInfo)rootInfo.getSubGroups().get(0)).getState(), (Object)ResourceGroupState.CAN_QUEUE);
        Assert.assertEquals((Object)((ResourceGroupInfo)rootInfo.getSubGroups().get(0)).getSoftMemoryLimit(), (Object)rootA.getSoftMemoryLimit());
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(0)).getHardConcurrencyLimit(), (int)rootA.getHardConcurrencyLimit());
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(0)).getMaxQueuedQueries(), (int)rootA.getMaxQueuedQueries());
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(0)).getNumEligibleSubGroups(), (int)2);
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(0)).getNumRunningQueries(), (int)0);
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(0)).getNumQueuedQueries(), (int)10);
        TestResourceGroups.assertGroupInfoEquals((ResourceGroupInfo)rootInfo.getSubGroups().get(1), rootB.getInfo());
        Assert.assertEquals((Object)((ResourceGroupInfo)rootInfo.getSubGroups().get(1)).getId(), (Object)rootB.getId());
        Assert.assertEquals((Object)((ResourceGroupInfo)rootInfo.getSubGroups().get(1)).getState(), (Object)ResourceGroupState.CAN_QUEUE);
        Assert.assertEquals((Object)((ResourceGroupInfo)rootInfo.getSubGroups().get(1)).getSoftMemoryLimit(), (Object)rootB.getSoftMemoryLimit());
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(1)).getHardConcurrencyLimit(), (int)rootB.getHardConcurrencyLimit());
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(1)).getMaxQueuedQueries(), (int)rootB.getMaxQueuedQueries());
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(1)).getNumEligibleSubGroups(), (int)0);
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(1)).getNumRunningQueries(), (int)1);
        Assert.assertEquals((int)((ResourceGroupInfo)rootInfo.getSubGroups().get(1)).getNumQueuedQueries(), (int)9);
        Assert.assertEquals((int)rootInfo.getSoftConcurrencyLimit(), (int)root.getSoftConcurrencyLimit());
        Assert.assertEquals((int)rootInfo.getHardConcurrencyLimit(), (int)root.getHardConcurrencyLimit());
        Assert.assertEquals((int)rootInfo.getMaxQueuedQueries(), (int)root.getMaxQueuedQueries());
        Assert.assertEquals((int)rootInfo.getNumQueuedQueries(), (int)19);
        Assert.assertEquals((int)rootInfo.getRunningQueries().size(), (int)1);
        QueryStateInfo queryInfo = (QueryStateInfo)rootInfo.getRunningQueries().get(0);
        Assert.assertEquals((Object)queryInfo.getResourceGroupId(), Optional.of(rootB.getId()));
    }

    @Test
    public void testGetBlockedQueuedQueries() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(8);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(8);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(5);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(8);
        InternalResourceGroup rootBX = rootB.getOrCreateSubGroup("x");
        rootBX.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootBX.setMaxQueuedQueries(10);
        rootBX.setHardConcurrencyLimit(8);
        InternalResourceGroup rootBY = rootB.getOrCreateSubGroup("y");
        rootBY.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootBY.setMaxQueuedQueries(10);
        rootBY.setHardConcurrencyLimit(5);
        Set<MockQueryExecution> queries = TestResourceGroups.fillGroupTo(rootAX, (Set<MockQueryExecution>)ImmutableSet.of(), 10, false);
        queries.addAll(TestResourceGroups.fillGroupTo(rootAY, (Set<MockQueryExecution>)ImmutableSet.of(), 10, false));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBX, (Set<MockQueryExecution>)ImmutableSet.of(), 10, true));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBY, (Set<MockQueryExecution>)ImmutableSet.of(), 10, true));
        Assert.assertEquals((int)root.getWaitingQueuedQueries(), (int)16);
        Assert.assertEquals((int)rootA.getWaitingQueuedQueries(), (int)13);
        Assert.assertEquals((int)rootAX.getWaitingQueuedQueries(), (int)10);
        Assert.assertEquals((int)rootAY.getWaitingQueuedQueries(), (int)10);
        Assert.assertEquals((int)rootB.getWaitingQueuedQueries(), (int)13);
        Assert.assertEquals((int)rootBX.getWaitingQueuedQueries(), (int)10);
        Assert.assertEquals((int)rootBY.getWaitingQueuedQueries(), (int)10);
        root.setHardConcurrencyLimit(20);
        root.processQueuedQueries();
        Assert.assertEquals((int)root.getWaitingQueuedQueries(), (int)0);
        Assert.assertEquals((int)rootA.getWaitingQueuedQueries(), (int)5);
        Assert.assertEquals((int)rootAX.getWaitingQueuedQueries(), (int)6);
        Assert.assertEquals((int)rootAY.getWaitingQueuedQueries(), (int)6);
        Assert.assertEquals((int)rootB.getWaitingQueuedQueries(), (int)5);
        Assert.assertEquals((int)rootBX.getWaitingQueuedQueries(), (int)6);
        Assert.assertEquals((int)rootBY.getWaitingQueuedQueries(), (int)6);
    }

    private static int completeGroupQueries(Set<MockQueryExecution> groupQueries) {
        int groupRan = 0;
        Iterator<MockQueryExecution> iterator = groupQueries.iterator();
        while (iterator.hasNext()) {
            MockQueryExecution query = iterator.next();
            if (query.getState() != QueryState.RUNNING) continue;
            query.complete();
            iterator.remove();
            ++groupRan;
        }
        return groupRan;
    }

    private static Set<MockQueryExecution> fillGroupTo(InternalResourceGroup group, Set<MockQueryExecution> existingQueries, int count) {
        return TestResourceGroups.fillGroupTo(group, existingQueries, count, false);
    }

    private static Set<MockQueryExecution> fillGroupTo(InternalResourceGroup group, Set<MockQueryExecution> existingQueries, int count, boolean queryPriority) {
        int existingCount = existingQueries.size();
        HashSet<MockQueryExecution> queries = new HashSet<MockQueryExecution>(existingQueries);
        for (int i = 0; i < count - existingCount; ++i) {
            MockQueryExecution query = new MockQueryExecution(0L, group.getId().toString().replace(".", "") + Integer.toString(i), queryPriority ? i + 1 : 1);
            queries.add(query);
            group.run((ManagedQueryExecution)query);
        }
        return queries;
    }

    private static void assertGroupInfoEquals(ResourceGroupInfo actual, ResourceGroupInfo expected) {
        Assert.assertTrue((actual.getSchedulingWeight() == expected.getSchedulingWeight() && actual.getSoftConcurrencyLimit() == expected.getSoftConcurrencyLimit() && actual.getHardConcurrencyLimit() == expected.getHardConcurrencyLimit() && actual.getMaxQueuedQueries() == expected.getMaxQueuedQueries() && actual.getNumQueuedQueries() == expected.getNumQueuedQueries() && actual.getNumRunningQueries() == expected.getNumRunningQueries() && actual.getNumEligibleSubGroups() == expected.getNumEligibleSubGroups() && Objects.equals(actual.getId(), expected.getId()) && actual.getState() == expected.getState() && actual.getSchedulingPolicy() == expected.getSchedulingPolicy() && Objects.equals(actual.getSoftMemoryLimit(), expected.getSoftMemoryLimit()) && Objects.equals(actual.getMemoryUsage(), expected.getMemoryUsage()) ? 1 : 0) != 0);
    }
}

