/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.client.NodeVersion;
import io.prestosql.connector.CatalogName;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.execution.LocationFactory;
import io.prestosql.execution.MockRemoteTaskFactory;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.RemoteTask;
import io.prestosql.execution.RemoteTaskFactory;
import io.prestosql.execution.SqlStageExecution;
import io.prestosql.execution.StageId;
import io.prestosql.execution.TestSqlTaskManager;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.scheduler.DynamicSplitPlacementPolicy;
import io.prestosql.execution.scheduler.LegacyNetworkTopology;
import io.prestosql.execution.scheduler.NetworkTopology;
import io.prestosql.execution.scheduler.NodeScheduler;
import io.prestosql.execution.scheduler.NodeSchedulerConfig;
import io.prestosql.execution.scheduler.ScheduleResult;
import io.prestosql.execution.scheduler.SourcePartitionedScheduler;
import io.prestosql.execution.scheduler.SplitPlacementPolicy;
import io.prestosql.execution.scheduler.SplitSchedulerStats;
import io.prestosql.execution.scheduler.StageScheduler;
import io.prestosql.failuredetector.FailureDetector;
import io.prestosql.failuredetector.NoOpFailureDetector;
import io.prestosql.metadata.InMemoryNodeManager;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.StageExecutionDescriptor;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.FixedSplitSource;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.split.ConnectorAwareSplitSource;
import io.prestosql.split.SplitSource;
import io.prestosql.sql.planner.Partitioning;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.StageExecutionPlan;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.testing.TestingHandles;
import io.prestosql.testing.TestingMetadata;
import io.prestosql.testing.TestingSplit;
import io.prestosql.util.FinalizerService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSourcePartitionedScheduler {
    public static final OutputBuffers.OutputBufferId OUT = new OutputBuffers.OutputBufferId(0);
    private static final CatalogName CONNECTOR_ID = TestingHandles.TEST_TABLE_HANDLE.getCatalogName();
    private final ExecutorService queryExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stageExecutor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"stageScheduledExecutor-%s"));
    private final LocationFactory locationFactory = new TestSqlTaskManager.MockLocationFactory();
    private final InMemoryNodeManager nodeManager = new InMemoryNodeManager();
    private final FinalizerService finalizerService = new FinalizerService();

    public TestSourcePartitionedScheduler() {
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
    }

    @BeforeClass
    public void setUp() {
        this.finalizerService.start();
    }

    @AfterClass(alwaysRun=true)
    public void destroyExecutor() {
        this.queryExecutor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.finalizerService.destroy();
    }

    @Test
    public void testScheduleNoSplits() {
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(0, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)));
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)1);
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
        stage.abort();
    }

    @Test
    public void testScheduleSplitsOneAtATime() {
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(60, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)));
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        for (int i = 0; i < 60; ++i) {
            ScheduleResult scheduleResult = scheduler.schedule();
            if (i == 59) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assert.assertFalse((boolean)scheduleResult.isFinished());
            }
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)(i < 3 ? 1 : 0));
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)(i < 3 ? i + 1 : 3));
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 1, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSplitsBatched() {
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(60, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)));
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 7);
        for (int i = 0; i <= 8; ++i) {
            ScheduleResult scheduleResult = scheduler.schedule();
            if (i == 8) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assert.assertFalse((boolean)scheduleResult.isFinished());
            }
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)(i == 0 ? 3 : 0));
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min((i + 1) * 7, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSplitsBlock() {
        ScheduleResult scheduleResult;
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(80, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)));
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        for (int i = 0; i <= 60; ++i) {
            scheduleResult = scheduler.schedule();
            Assert.assertFalse((boolean)scheduleResult.isFinished());
            Assert.assertEquals((boolean)scheduleResult.getBlocked().isDone(), (i != 60 ? 1 : 0) != 0);
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)(i < 3 ? 1 : 0));
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)(i < 3 ? i + 1 : 3));
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 1, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        ((MockRemoteTaskFactory.MockRemoteTask)stage.getAllTasks().get(0)).clearSplits();
        for (int i = 0; i < 20; ++i) {
            scheduleResult = scheduler.schedule();
            if (i == 19) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assert.assertFalse((boolean)scheduleResult.isFinished());
            }
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)0);
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 41, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSlowSplitSource() {
        QueuedSplitSource queuedSplitSource = new QueuedSplitSource((Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit));
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(queuedSplitSource);
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assert.assertFalse((boolean)scheduleResult.isFinished());
        Assert.assertFalse((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)0);
        Assert.assertEquals((int)stage.getAllTasks().size(), (int)0);
        queuedSplitSource.addSplits(1);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
    }

    @Test
    public void testNoNodes() {
        try {
            NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
            InMemoryNodeManager nodeManager = new InMemoryNodeManager();
            NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap);
            StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(20, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)));
            SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
            StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((SqlStageExecution)stage, (PlanNodeId)((PlanNodeId)Iterables.getOnlyElement(plan.getSplitSources().keySet())), (SplitSource)((SplitSource)Iterables.getOnlyElement(plan.getSplitSources().values())), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(CONNECTOR_ID), () -> ((SqlStageExecution)stage).getAllTasks()), (int)2);
            scheduler.schedule();
            Assert.fail((String)"expected PrestoException");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NO_NODES_AVAILABLE.toErrorCode());
        }
    }

    @Test
    public void testBalancedSplitAssignment() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecutionPlan firstPlan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(15, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)));
        SqlStageExecution firstStage = this.createSqlStageExecution(firstPlan, nodeTaskMap);
        StageScheduler firstScheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(firstPlan, firstStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200);
        ScheduleResult scheduleResult = firstScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, firstScheduler);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)3);
        Assert.assertEquals((int)firstStage.getAllTasks().size(), (int)3);
        for (RemoteTask remoteTask : firstStage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)5);
        }
        InternalNode additionalNode = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{additionalNode});
        StageExecutionPlan secondPlan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(5, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)));
        SqlStageExecution secondStage = this.createSqlStageExecution(secondPlan, nodeTaskMap);
        StageScheduler secondScheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(secondPlan, secondStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200);
        scheduleResult = secondScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, secondScheduler);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)1);
        Assert.assertEquals((int)secondStage.getAllTasks().size(), (int)1);
        RemoteTask task = (RemoteTask)secondStage.getAllTasks().get(0);
        Assert.assertEquals((int)task.getPartitionedSplitCount(), (int)5);
        firstStage.abort();
        secondStage.abort();
    }

    @Test
    public void testBlockCausesFullSchedule() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecutionPlan firstPlan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(60, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)));
        SqlStageExecution firstStage = this.createSqlStageExecution(firstPlan, nodeTaskMap);
        StageScheduler firstScheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(firstPlan, firstStage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 200);
        ScheduleResult scheduleResult = firstScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, firstScheduler);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)3);
        Assert.assertEquals((int)firstStage.getAllTasks().size(), (int)3);
        for (RemoteTask remoteTask : firstStage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        StageExecutionPlan secondPlan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(5, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)));
        SqlStageExecution secondStage = this.createSqlStageExecution(secondPlan, nodeTaskMap);
        StageScheduler secondScheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(secondPlan, secondStage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 200);
        scheduleResult = secondScheduler.schedule();
        Assert.assertFalse((boolean)scheduleResult.isFinished());
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)3);
        Assert.assertEquals((int)secondStage.getAllTasks().size(), (int)3);
        for (RemoteTask remoteTask : secondStage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)0);
        }
        firstStage.abort();
        secondStage.abort();
    }

    private static void assertPartitionedSplitCount(SqlStageExecution stage, int expectedPartitionedSplitCount) {
        Assert.assertEquals((int)stage.getAllTasks().stream().mapToInt(RemoteTask::getPartitionedSplitCount).sum(), (int)expectedPartitionedSplitCount);
    }

    private static void assertEffectivelyFinished(ScheduleResult scheduleResult, StageScheduler scheduler) {
        if (scheduleResult.isFinished()) {
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            return;
        }
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        ScheduleResult nextScheduleResult = scheduler.schedule();
        Assert.assertTrue((boolean)nextScheduleResult.isFinished());
        Assert.assertTrue((boolean)nextScheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)nextScheduleResult.getNewTasks().size(), (int)0);
        Assert.assertEquals((int)nextScheduleResult.getSplitsScheduled(), (int)0);
    }

    private static StageScheduler getSourcePartitionedScheduler(StageExecutionPlan plan, SqlStageExecution stage, InternalNodeManager nodeManager, NodeTaskMap nodeTaskMap, int splitBatchSize) {
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setIncludeCoordinator(false).setMaxSplitsPerNode(20).setMaxPendingSplitsPerTask(0);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), nodeManager, nodeSchedulerConfig, nodeTaskMap);
        PlanNodeId sourceNode = (PlanNodeId)Iterables.getOnlyElement(plan.getSplitSources().keySet());
        SplitSource splitSource = (SplitSource)Iterables.getOnlyElement(plan.getSplitSources().values());
        DynamicSplitPlacementPolicy placementPolicy = new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(splitSource.getCatalogName()), () -> ((SqlStageExecution)stage).getAllTasks());
        return SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((SqlStageExecution)stage, (PlanNodeId)sourceNode, (SplitSource)splitSource, (SplitPlacementPolicy)placementPolicy, (int)splitBatchSize);
    }

    private static StageExecutionPlan createPlan(ConnectorSplitSource splitSource) {
        Symbol symbol = new Symbol("column");
        PlanNodeId tableScanNodeId = new PlanNodeId("plan_id");
        TableScanNode tableScan = TableScanNode.newInstance((PlanNodeId)tableScanNodeId, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")));
        RemoteSourceNode remote = new RemoteSourceNode(new PlanNodeId("remote_id"), new PlanFragmentId("plan_fragment_id"), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.GATHER);
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId("plan_id"), (PlanNode)new JoinNode(new PlanNodeId("join_id"), JoinNode.Type.INNER, (PlanNode)tableScan, (PlanNode)remote, (List)ImmutableList.of(), (List)ImmutableList.builder().addAll((Iterable)tableScan.getOutputSymbols()).addAll((Iterable)remote.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)tableScanNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());
        return new StageExecutionPlan(testFragment, (Map)ImmutableMap.of((Object)tableScanNodeId, (Object)new ConnectorAwareSplitSource(CONNECTOR_ID, splitSource)), (List)ImmutableList.of());
    }

    private static ConnectorSplitSource createFixedSplitSource(int splitCount, Supplier<ConnectorSplit> splitFactory) {
        ImmutableList.Builder splits = ImmutableList.builder();
        for (int i = 0; i < splitCount; ++i) {
            splits.add(splitFactory.get());
        }
        return new FixedSplitSource((Iterable)splits.build());
    }

    private SqlStageExecution createSqlStageExecution(StageExecutionPlan tableScanPlan, NodeTaskMap nodeTaskMap) {
        StageId stageId = new StageId(new QueryId("query"), 0);
        SqlStageExecution stage = SqlStageExecution.createSqlStageExecution((StageId)stageId, (URI)this.locationFactory.createStageLocation(stageId), (PlanFragment)tableScanPlan.getFragment(), (RemoteTaskFactory)new MockRemoteTaskFactory(this.queryExecutor, this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)nodeTaskMap, (ExecutorService)this.queryExecutor, (FailureDetector)new NoOpFailureDetector(), (SplitSchedulerStats)new SplitSchedulerStats());
        stage.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        return stage;
    }

    private static class QueuedSplitSource
    implements ConnectorSplitSource {
        private final Supplier<ConnectorSplit> splitFactory;
        private final LinkedBlockingQueue<ConnectorSplit> queue = new LinkedBlockingQueue();
        private CompletableFuture<?> notEmptyFuture = new CompletableFuture();
        private boolean closed;

        public QueuedSplitSource(Supplier<ConnectorSplit> splitFactory) {
            this.splitFactory = Objects.requireNonNull(splitFactory, "splitFactory is null");
        }

        synchronized void addSplits(int count) {
            if (this.closed) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                this.queue.add((ConnectorSplit)this.splitFactory.get());
                this.notEmptyFuture.complete(null);
            }
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
            Preconditions.checkArgument((boolean)partitionHandle.equals((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED), (Object)"partitionHandle must be NOT_PARTITIONED");
            return ((CompletableFuture)this.notEmptyFuture.thenApply(x -> this.getBatch(maxSize))).thenApply(splits -> new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
        }

        private synchronized List<ConnectorSplit> getBatch(int maxSize) {
            ArrayList elements = new ArrayList(maxSize);
            this.queue.drainTo(elements, maxSize);
            if (this.queue.isEmpty() && !this.closed && this.notEmptyFuture.isDone()) {
                this.notEmptyFuture = new CompletableFuture();
            }
            return ImmutableList.copyOf(elements);
        }

        public synchronized boolean isFinished() {
            return this.closed && this.queue.isEmpty();
        }

        public synchronized void close() {
            this.closed = true;
        }
    }
}

