/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import io.airlift.units.DataSize;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.NodeMemoryConfig;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLocalMemoryManager {
    @Test
    public void testReservedMemoryPoolDisabled() {
        NodeMemoryConfig config = new NodeMemoryConfig().setReservedPoolEnabled(false).setHeapHeadroom(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setMaxQueryMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE));
        LocalMemoryManager localMemoryManager = new LocalMemoryManager(config, new DataSize(60.0, DataSize.Unit.GIGABYTE).toBytes());
        Assert.assertFalse((boolean)localMemoryManager.getReservedPool().isPresent());
        Assert.assertEquals((int)localMemoryManager.getPools().size(), (int)1);
    }

    @Test
    public void testReservedMemoryPoolEnabled() {
        NodeMemoryConfig config = new NodeMemoryConfig().setHeapHeadroom(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setMaxQueryMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE));
        LocalMemoryManager localMemoryManager = new LocalMemoryManager(config, new DataSize(60.0, DataSize.Unit.GIGABYTE).toBytes());
        Assert.assertTrue((boolean)localMemoryManager.getReservedPool().isPresent());
        Assert.assertEquals((int)localMemoryManager.getPools().size(), (int)2);
    }

    @Test
    public void testMaxQueryMemoryPerNodeBiggerThanQueryTotalMemoryPerNode() {
        NodeMemoryConfig config = new NodeMemoryConfig().setHeapHeadroom(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setMaxQueryMemoryPerNode(new DataSize(200.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new LocalMemoryManager(config, new DataSize(60.0, DataSize.Unit.GIGABYTE).toBytes())).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Max query memory per node (query.max-memory-per-node) cannot be greater than the max query total memory per node (query.max-total-memory-per-node)");
    }

    @Test
    public void testNotEnoughAvailableMemory() {
        NodeMemoryConfig config = new NodeMemoryConfig().setHeapHeadroom(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setMaxQueryMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new LocalMemoryManager(config, new DataSize(25.0, DataSize.Unit.GIGABYTE).toBytes())).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Invalid memory configuration\\. The sum of max total query memory per node .* and heap headroom .*cannot be larger than the available heap memory .*");
    }
}

