/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.prestosql.memory.NodeMemoryConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNodeMemoryConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeMemoryConfig)ConfigAssertions.recordDefaults(NodeMemoryConfig.class)).setMaxQueryMemoryPerNode(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE)).setMaxQueryTotalMemoryPerNode(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE)).setHeapHeadroom(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE)).setReservedPoolEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.max-memory-per-node", (Object)"1GB").put((Object)"query.max-total-memory-per-node", (Object)"3GB").put((Object)"memory.heap-headroom-per-node", (Object)"1GB").put((Object)"experimental.reserved-pool-enabled", (Object)"false").build();
        NodeMemoryConfig expected = new NodeMemoryConfig().setMaxQueryMemoryPerNode(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(3.0, DataSize.Unit.GIGABYTE)).setHeapHeadroom(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setReservedPoolEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

