/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.QueryId;
import io.prestosql.spiller.SpillSpaceTracker;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.LocalQueryRunner;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestQueryContext {
    private static final ScheduledExecutorService TEST_EXECUTOR = Executors.newScheduledThreadPool(1, Threads.threadsNamed((String)"test-executor-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        TEST_EXECUTOR.shutdownNow();
    }

    @DataProvider
    public Object[][] testSetMemoryPoolOptions() {
        return new Object[][]{{false}, {true}};
    }

    @Test(dataProvider="testSetMemoryPoolOptions")
    public void testSetMemoryPool(boolean useReservedPool) {
        QueryId secondQuery = new QueryId("second");
        MemoryPool reservedPool = new MemoryPool(LocalMemoryManager.RESERVED_POOL, new DataSize(10.0, DataSize.Unit.BYTE));
        long secondQueryMemory = reservedPool.getMaxBytes() - 1L;
        if (useReservedPool) {
            Assert.assertTrue((boolean)reservedPool.reserve(secondQuery, "test", secondQueryMemory).isDone());
        }
        try (LocalQueryRunner localQueryRunner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);){
            QueryContext queryContext = new QueryContext(new QueryId("query"), new DataSize(10.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new MemoryPool(LocalMemoryManager.GENERAL_POOL, new DataSize(10.0, DataSize.Unit.BYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)localQueryRunner.getExecutor(), localQueryRunner.getScheduler(), new DataSize(0.0, DataSize.Unit.BYTE), new SpillSpaceTracker(new DataSize(0.0, DataSize.Unit.BYTE)));
            queryContext.getQueryMemoryContext().initializeLocalMemoryContexts("test");
            LocalMemoryContext userMemoryContext = queryContext.getQueryMemoryContext().localUserMemoryContext();
            LocalMemoryContext revocableMemoryContext = queryContext.getQueryMemoryContext().localRevocableMemoryContext();
            Assert.assertTrue((boolean)userMemoryContext.setBytes(3L).isDone());
            Assert.assertTrue((boolean)revocableMemoryContext.setBytes(5L).isDone());
            queryContext.setMemoryPool(reservedPool);
            if (useReservedPool) {
                reservedPool.free(secondQuery, "test", secondQueryMemory);
            }
            userMemoryContext.close();
            revocableMemoryContext.close();
        }
    }

    @Test
    public void testMoveTaggedAllocations() {
        MemoryPool generalPool = new MemoryPool(LocalMemoryManager.GENERAL_POOL, new DataSize(10000.0, DataSize.Unit.BYTE));
        MemoryPool reservedPool = new MemoryPool(LocalMemoryManager.RESERVED_POOL, new DataSize(10000.0, DataSize.Unit.BYTE));
        QueryId queryId = new QueryId("query");
        QueryContext queryContext = TestQueryContext.createQueryContext(queryId, generalPool);
        TaskStateMachine taskStateMachine = new TaskStateMachine(TaskId.valueOf((String)"task-id"), (Executor)TEST_EXECUTOR);
        TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, SessionTestUtils.TEST_SESSION, false, false, OptionalInt.empty());
        DriverContext driverContext = taskContext.addPipelineContext(0, false, false, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), "test");
        LocalMemoryContext memoryContext = operatorContext.aggregateUserMemoryContext().newLocalMemoryContext("test_context");
        memoryContext.setBytes(1000L);
        Map allocations = (Map)generalPool.getTaggedMemoryAllocations().get(queryId);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_context", (Object)1000L));
        queryContext.setMemoryPool(reservedPool);
        Assert.assertNull(generalPool.getTaggedMemoryAllocations().get(queryId));
        allocations = (Map)reservedPool.getTaggedMemoryAllocations().get(queryId);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_context", (Object)1000L));
        Assert.assertEquals((long)generalPool.getFreeBytes(), (long)10000L);
        Assert.assertEquals((long)reservedPool.getFreeBytes(), (long)9000L);
        memoryContext.close();
        Assert.assertEquals((long)generalPool.getFreeBytes(), (long)10000L);
        Assert.assertEquals((long)reservedPool.getFreeBytes(), (long)10000L);
    }

    private static QueryContext createQueryContext(QueryId queryId, MemoryPool generalPool) {
        return new QueryContext(queryId, new DataSize(10000.0, DataSize.Unit.BYTE), new DataSize(10000.0, DataSize.Unit.BYTE), generalPool, (GcMonitor)new TestingGcMonitor(), (Executor)TEST_EXECUTOR, TEST_EXECUTOR, new DataSize(0.0, DataSize.Unit.BYTE), new SpillSpaceTracker(new DataSize(0.0, DataSize.Unit.BYTE)));
    }
}

