/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.Lifespan;
import io.prestosql.execution.ScheduledSplit;
import io.prestosql.execution.TaskSource;
import io.prestosql.memory.MemoryPool;
import io.prestosql.metadata.Split;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.Driver;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.TableScanOperator;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.PageConsumerOperator;
import io.prestosql.testing.TestingHandles;
import io.prestosql.testing.TestingTaskContext;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSystemMemoryBlocking {
    private static final QueryId QUERY_ID = new QueryId("test_query");
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private MemoryPool memoryPool;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        TaskContext taskContext = TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setQueryMaxMemory(DataSize.valueOf((String)"100MB")).setMemoryPoolSize(DataSize.valueOf((String)"10B")).setQueryId(QUERY_ID).build();
        this.memoryPool = taskContext.getQueryContext().getMemoryPool();
        this.driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testTableScanSystemMemoryBlocking() {
        PlanNodeId sourceId = new PlanNodeId("source");
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        TableScanOperator source = new TableScanOperator(this.driverContext.addOperatorContext(1, new PlanNodeId("test"), "values"), sourceId, (arg_0, arg_1, arg_2, arg_3) -> TestSystemMemoryBlocking.lambda$testTableScanSystemMemoryBlocking$0((List)types, arg_0, arg_1, arg_2, arg_3), TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of());
        PageConsumerOperator sink = this.createSinkOperator((List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)this.driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        Split testSplit = new Split(new CatalogName("test"), (ConnectorSplit)new TestSplit(), Lifespan.taskWide());
        driver.updateSource(new TaskSource(sourceId, (Set)ImmutableSet.of((Object)new ScheduledSplit(0L, sourceId, testSplit)), true));
        ListenableFuture blocked = driver.processFor(new Duration(1.0, TimeUnit.NANOSECONDS));
        Assert.assertTrue((boolean)blocked.isDone());
        Assert.assertFalse((boolean)source.getOperatorContext().isWaitingForMemory().isDone());
        for (int i = 0; i < 10; ++i) {
            blocked = driver.processFor(new Duration(1.0, TimeUnit.NANOSECONDS));
            Assert.assertFalse((boolean)blocked.isDone());
            Assert.assertFalse((boolean)source.getOperatorContext().isWaitingForMemory().isDone());
        }
        this.memoryPool.free(QUERY_ID, "test", this.memoryPool.getReservedBytes());
        Assert.assertTrue((boolean)source.getOperatorContext().isWaitingForMemory().isDone());
        blocked = driver.processFor(new Duration(1.0, TimeUnit.NANOSECONDS));
        Assert.assertTrue((boolean)blocked.isDone());
    }

    private PageConsumerOperator createSinkOperator(List<Type> types) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), types);
        return new PageConsumerOperator(this.driverContext.addOperatorContext(2, new PlanNodeId("test"), "sink"), arg_0 -> ((MaterializedResult.Builder)resultBuilder).page(arg_0), Function.identity());
    }

    private static /* synthetic */ ConnectorPageSource lambda$testTableScanSystemMemoryBlocking$0(List types, Session session, Split split, TableHandle table, List columns) {
        return new FixedPageSource(RowPagesBuilder.rowPagesBuilder(types).addSequencePage(10, 1).addSequencePage(10, 1).addSequencePage(10, 1).addSequencePage(10, 1).addSequencePage(10, 1).build());
    }

    private static class TestSplit
    implements ConnectorSplit {
        private TestSplit() {
        }

        public boolean isRemotelyAccessible() {
            return false;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return null;
        }
    }
}

